/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.util;

import com.vividsolutions.jts.algorithm.distance.DistanceToPoint;
import com.vividsolutions.jts.algorithm.distance.PointPairDistance;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import java.util.ArrayList;
import java.util.Collection;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;

class OpenJUMPUtils {
    OpenJUMPUtils() {
    }

    static Geometry offsetCleanOpenLine(IProjection proj, ArrayListCoordinateSequence coordinates, double distance) {
        GeometryFactory factory = JTSUtils.getFactory(coordinates);
        LineString jtsGeom = JTSUtils.createJTSLineString(proj, coordinates);
        BufferParameters bufParams = JTSUtils.getBufferParameters();
        com.vividsolutions.jts.geom.Geometry sidedBuffer = new BufferOp((com.vividsolutions.jts.geom.Geometry)jtsGeom, bufParams).getResultGeometry(distance).getBoundary();
        ArrayList<LineString> offsetSegments = new ArrayList<LineString>();
        int quadrantSegments = bufParams.getQuadrantSegments();
        double lowerBound = Math.abs(distance) * Math.sin(Math.PI / (double)(4 * quadrantSegments));
        double upperBound = Math.abs(distance) * Math.cos(Math.PI / (double)(2 * quadrantSegments));
        for (int i = 0; i < sidedBuffer.getNumGeometries(); ++i) {
            Coordinate[] cc = sidedBuffer.getGeometryN(i).getCoordinates();
            PointPairDistance ppd = new PointPairDistance();
            DistanceToPoint.computeDistance((LineString)jtsGeom, (Coordinate)cc[0], (PointPairDistance)ppd);
            double dj = ppd.getDistance();
            for (int j = 1; j < cc.length; ++j) {
                double di = dj;
                ppd = new PointPairDistance();
                DistanceToPoint.computeDistance((LineString)jtsGeom, (Coordinate)cc[j], (PointPairDistance)ppd);
                dj = ppd.getDistance();
                if (Math.max(di, dj) < lowerBound || di == 0.0 || dj == 0.0) continue;
                if (Math.min(di, dj) > upperBound) {
                    LineString segment = jtsGeom.getFactory().createLineString(new Coordinate[]{cc[j - 1], cc[j]});
                    offsetSegments.add(segment);
                    continue;
                }
                if (Math.min(di, dj) > lowerBound && Math.max(di, dj) < upperBound) continue;
                OpenJUMPUtils.divide(offsetSegments, (com.vividsolutions.jts.geom.Geometry)jtsGeom, cc[j - 1], cc[j], di, dj, lowerBound, upperBound);
            }
        }
        ArrayList<LineString> offsetCurves = new ArrayList<LineString>();
        offsetCurves.addAll(OpenJUMPUtils.merge(offsetSegments));
        return JTSUtils.createGeometry(proj, factory.buildGeometry(offsetCurves));
    }

    static Geometry offsetCleanOpenLine(IProjection proj, ArrayListCoordinateSequence coordinates, BufferParameters bufParams, double distance) {
        GeometryFactory factory = JTSUtils.getFactory(coordinates);
        LineString jtsGeom = JTSUtils.createJTSLineString(proj, coordinates);
        com.vividsolutions.jts.geom.Geometry sidedBuffer = new BufferOp((com.vividsolutions.jts.geom.Geometry)jtsGeom, bufParams).getResultGeometry(distance).getBoundary();
        ArrayList<LineString> offsetSegments = new ArrayList<LineString>();
        int quadrantSegments = bufParams.getQuadrantSegments();
        double lowerBound = Math.abs(distance) * Math.sin(Math.PI / (double)(4 * quadrantSegments));
        double upperBound = Math.abs(distance) * Math.cos(Math.PI / (double)(2 * quadrantSegments));
        for (int i = 0; i < sidedBuffer.getNumGeometries(); ++i) {
            Coordinate[] cc = sidedBuffer.getGeometryN(i).getCoordinates();
            PointPairDistance ppd = new PointPairDistance();
            DistanceToPoint.computeDistance((LineString)jtsGeom, (Coordinate)cc[0], (PointPairDistance)ppd);
            double dj = ppd.getDistance();
            for (int j = 1; j < cc.length; ++j) {
                double di = dj;
                ppd = new PointPairDistance();
                DistanceToPoint.computeDistance((LineString)jtsGeom, (Coordinate)cc[j], (PointPairDistance)ppd);
                dj = ppd.getDistance();
                if (Math.max(di, dj) < lowerBound || di == 0.0 || dj == 0.0) continue;
                if (Math.min(di, dj) > upperBound) {
                    LineString segment = jtsGeom.getFactory().createLineString(new Coordinate[]{cc[j - 1], cc[j]});
                    offsetSegments.add(segment);
                    continue;
                }
                if (Math.min(di, dj) > lowerBound && Math.max(di, dj) < upperBound) continue;
                OpenJUMPUtils.divide(offsetSegments, (com.vividsolutions.jts.geom.Geometry)jtsGeom, cc[j - 1], cc[j], di, dj, lowerBound, upperBound);
            }
        }
        ArrayList<LineString> offsetCurves = new ArrayList<LineString>();
        offsetCurves.addAll(OpenJUMPUtils.merge(offsetSegments));
        return JTSUtils.createGeometry(proj, factory.buildGeometry(offsetCurves));
    }

    private static void divide(Collection<LineString> offsetSegments, com.vividsolutions.jts.geom.Geometry sourceCurve, Coordinate c1, Coordinate c2, double d1, double d2, double lb, double ub) {
        LineString segment;
        if (c1.distance(c2) < 2.0 * lb) {
            return;
        }
        Coordinate c = new Coordinate((c1.x + c2.x) / 2.0, (c1.y + c2.y) / 2.0);
        PointPairDistance ppd = new PointPairDistance();
        DistanceToPoint.computeDistance((com.vividsolutions.jts.geom.Geometry)sourceCurve, (Coordinate)c, (PointPairDistance)ppd);
        double d = ppd.getDistance();
        if (!(Math.max(d1, d) < lb || Math.min(d1, d) > lb && Math.max(d1, d) < ub)) {
            if (Math.min(d1, d) > ub) {
                segment = sourceCurve.getFactory().createLineString(new Coordinate[]{c1, c});
                offsetSegments.add(segment);
            } else {
                OpenJUMPUtils.divide(offsetSegments, sourceCurve, c1, c, d1, d, lb, ub);
            }
        }
        if (!(Math.max(d, d2) < lb || Math.min(d, d2) > lb && Math.max(d, d2) < ub)) {
            if (Math.min(d, d2) > ub) {
                segment = sourceCurve.getFactory().createLineString(new Coordinate[]{c, c2});
                offsetSegments.add(segment);
            } else {
                OpenJUMPUtils.divide(offsetSegments, sourceCurve, c, c2, d, d2, lb, ub);
            }
        }
    }

    private static Collection<LineString> merge(Collection<LineString> linestrings) {
        LineMerger merger = new LineMerger();
        merger.add(linestrings);
        return merger.getMergedLineStrings();
    }
}

