/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.prov.kml.dynformfield.layer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogr;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.services.dynformfield.String.JDynFormFieldString;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.DynObjectValueItem;

public class JDynFormFieldKmlLayer
extends JDynFormFieldString {
    private JDynFormField.JDynFormFieldListener fileChangedListener;
    private DynObjectValueItem[] availableValues;
    private File lastSelectedFile;

    public JDynFormFieldKmlLayer(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
    }

    public DynObjectValueItem[] getAvailableValues() {
        if (this.availableValues == null) {
            this.availableValues = new DynObjectValueItem[0];
        }
        return this.availableValues;
    }

    public void setValue(Object value) {
        this.addListenerToFile();
        super.setValue(value);
    }

    public void addListenerToFile() {
        if (this.fileChangedListener != null) {
            return;
        }
        JDynForm form = this.getForm();
        JDynFormField fileField = form.getField("file");
        if (fileField == null) {
            return;
        }
        JDynFormField.JDynFormFieldListener listener = new JDynFormField.JDynFormFieldListener(){

            public void fieldEnter(JDynFormField field) {
            }

            public void fieldExit(JDynFormField field) {
            }

            public void fieldChanged(JDynFormField field) {
                JDynFormFieldKmlLayer.this.doChangeFile(field);
            }

            public void message(JDynFormField field, String message) {
            }
        };
        fileField.addListener(listener);
        this.fileChangedListener = listener;
        this.doChangeFile(fileField);
    }

    private DynObjectValueItem[] getAvailableLayers(File file) {
        try {
            if (file == null) {
                return null;
            }
            List<String> layerNames = this.getLayerList();
            DynObjectValueItem[] values = new DynObjectValueItem[layerNames.size()];
            for (int i = 0; i < layerNames.size(); ++i) {
                values[i] = new DynObjectValueItem((Object)layerNames.get(i), layerNames.get(i));
            }
            return values;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve the layers.", (Throwable)ex);
            return null;
        }
    }

    public void doChangeFile(JDynFormField field) {
        File currentFile = (File)field.getValue();
        DefaultComboBoxModel<DynObjectValueItem> model = new DefaultComboBoxModel<DynObjectValueItem>();
        if (currentFile != null && (this.lastSelectedFile == null || currentFile.getPath().equals(this.lastSelectedFile.getPath()))) {
            this.availableValues = this.getAvailableLayers(currentFile);
            if (this.availableValues != null) {
                for (DynObjectValueItem availableValue : this.availableValues) {
                    model.addElement(availableValue);
                }
            }
            this.lastSelectedFile = currentFile;
        }
        this.getDropDown().setModel(model);
        if (model.getSize() > 0) {
            this.getDropDown().setSelectedIndex(0);
            this.fireFieldChangedEvent();
        }
    }

    private synchronized DataSource getDataSource() {
        File f = this.lastSelectedFile;
        if (f == null || !f.exists()) {
            return null;
        }
        DataSource dataSource = ogr.Open((String)f.getAbsolutePath(), (int)1);
        if (dataSource == null) {
            dataSource = ogr.Open((String)f.getAbsolutePath());
        }
        return dataSource;
    }

    private List<String> getLayerList() {
        DataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> layers = new ArrayList<String>();
        for (int i = 0; i < dataSource.GetLayerCount(); ++i) {
            Layer layer = dataSource.GetLayer(i);
            layers.add(layer.GetName());
            layer = null;
        }
        dataSource = null;
        return layers;
    }
}

