/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.swipe.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.swipe.swing.impl.AbstractSwipePanel;
import org.gvsig.swipe.swing.impl.VerticalSwipeView;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerticalSwipePanel
extends AbstractSwipePanel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(VerticalSwipePanel.class);
    private JScrollPane spUp;
    private JScrollPane spDown;
    private MapControl mapControlUp;
    private MapControl mapControlDown;
    protected VerticalSwipeView view = new VerticalSwipeView();

    public VerticalSwipePanel() {
        this.initComponents();
    }

    protected void initComponents() {
        try {
            this.configureCombos();
            this.configureSplitPanel();
            this.getView().pnlUpPanel.setLayout(new BorderLayout());
            this.spUp = new JScrollPane(21, 31);
            this.spUp.setViewportView((Component)this.mapControlUp);
            this.getView().pnlUpPanel.add((Component)this.spUp, "Center");
            this.getView().pnlDownPanel.setLayout(new BorderLayout());
            this.spDown = new JScrollPane(21, 31);
            this.spDown.setViewportView((Component)this.mapControlDown);
            this.getView().pnlDownPanel.add((Component)this.spDown, "Center");
            ToolsSwingUtils.configurePickersButton((AbstractButton)this.getView().btnZoomUpView, (String)"_Zoom_to_all_up_view", (String)"view-navigation-zoom-all", e -> this.doZoomAllView1(), null);
            ToolsSwingUtils.configurePickersButton((AbstractButton)this.getView().btnZoomDownView, (String)"_Zoom_to_all_down_view", (String)"view-navigation-zoom-all", e -> this.doZoomAllView2(), null);
            this.configureCombosActions();
            this.translate();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't initialize swipe panel", (Throwable)ex);
        }
    }

    protected void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate((JComponent)this.getView().cboUpView);
        toolsSwingManager.translate((JComponent)this.getView().cboDownView);
        toolsSwingManager.translate((AbstractButton)this.getView().btnZoomUpView);
        toolsSwingManager.translate((AbstractButton)this.getView().btnZoomDownView);
    }

    @Override
    protected MapControl getMapControl1() {
        if (this.mapControlUp == null) {
            this.mapControlUp = this.createMapControl();
        }
        return this.mapControlUp;
    }

    @Override
    protected MapControl getMapControl2() {
        if (this.mapControlDown == null) {
            this.mapControlDown = this.createMapControl();
        }
        return this.mapControlDown;
    }

    protected JComboBox getComboDocuments1() {
        return this.getView().cboUpView;
    }

    protected JComboBox getComboDocuments2() {
        return this.getView().cboDownView;
    }

    @Override
    protected void adjustJViewPortWindows() {
        this.spUp.getViewport().setViewPosition(new Point(0, 0));
        this.spDown.getViewport().setViewPosition(new Point(0, this.mapControlDown.getHeight()));
    }

    @Override
    protected JSplitPane createSplitPanel() {
        JSplitPane splitPanel = ToolsSwingUtils.createVerticalSplit((JPanel)this.getView().pnlSplitPanel, (JPanel)this.getView().pnlUpPanel, (boolean)false, (JPanel)this.getView().pnlDownPanel, (boolean)false);
        splitPanel.setContinuousLayout(true);
        return splitPanel;
    }

    @Override
    protected VerticalSwipeView getView() {
        return this.view;
    }

    @Override
    protected JPanel getViewSplitPanel() {
        return this.getView().pnlSplitPanel;
    }
}

