/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComponent;
import org.apache.commons.io.IOUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.catalog.CatalogLocator;
import org.gvsig.catalog.CatalogManager;
import org.gvsig.catalog.gui.ConnectDialog;
import org.gvsig.catalog.loaders.ARCIMSLayerLoader;
import org.gvsig.catalog.loaders.LinkLoader;
import org.gvsig.catalog.loaders.PostgisLayerLoader;
import org.gvsig.catalog.loaders.WCSLayerLoader;
import org.gvsig.catalog.loaders.WFSLayerLoader;
import org.gvsig.catalog.loaders.WMSLayerLoader;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.utils.swing.jcomboServer.ServerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogClientExtension
extends Extension {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogClientExtension.class);
    private static final String CATALOGLAYERS = "CatalogLayers";
    private static final String serversPropsFilename = "servers.properties";

    public void initialize() {
        ExtensionPointManager extensionPointManager = ToolsLocator.getExtensionPointManager();
        extensionPointManager.add(CATALOGLAYERS, "List of possible layers that can be loaded from a catalog");
        this.registerIcons();
        this.setPersistence();
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"catalog", (String)"catalog-move-down", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"catalog", (String)"catalog-move-up", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"catalog", (String)"catalog-server-properties", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"catalog", (String)"catalog-search", (Object)((Object)this));
    }

    public void postInitialize() {
        CatalogManager catalogManager = CatalogLocator.getCatalogManager();
        catalogManager.addLayerLoader("OGC:WMS", WMSLayerLoader.class);
        catalogManager.addLayerLoader("POSTGIS", PostgisLayerLoader.class);
        catalogManager.addLayerLoader("OGC:WCS", WCSLayerLoader.class);
        catalogManager.addLayerLoader("WWW:LINK", LinkLoader.class);
        catalogManager.addLayerLoader("WWW:DOWNLOAD", LinkLoader.class);
        catalogManager.addLayerLoader("OGC:WFS", WFSLayerLoader.class);
        catalogManager.addLayerLoader("ESRI:AIMS--HTTP-GET-IMAGE", ARCIMSLayerLoader.class);
        catalogManager.addLayerLoader("ESRI:AIMS--HTTP-GET-FEATURE", ARCIMSLayerLoader.class);
    }

    public void execute(String actionCommand) {
        this.actionConnectDialogStart();
    }

    private void actionConnectDialogStart() {
        System.out.println("Bot\u00f3n Cliente de metadatos pulsado");
        ConnectDialog connectDialog = new ConnectDialog();
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        windowManager.showWindow((JComponent)((Object)connectDialog), Messages.getText((String)"metadata_catalog"), WindowManager.MODE.TOOL, Collections.singletonMap("align", 23));
    }

    private void setPersistence() {
        PluginServices plugin = PluginsLocator.getManager().getPlugin(((Object)((Object)this)).getClass());
        DynObject preferences = plugin.getPluginProperties();
        HashMap serversMapPersistence = (HashMap)preferences.getDynValue("servers");
        if (serversMapPersistence == null) {
            serversMapPersistence = new HashMap();
            preferences.setDynValue("servers", serversMapPersistence);
        }
        this.addDefaultServers(serversMapPersistence);
        CatalogManager cm = CatalogLocator.getCatalogManager();
        cm.setServersPersistence(serversMapPersistence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void addDefaultServers(Map serversMapPersistence) {
        PluginServices plugin = PluginsLocator.getManager().getPlugin(((Object)((Object)this)).getClass());
        Properties prop = new Properties();
        File propFile = new File(plugin.getPluginDirectory(), serversPropsFilename);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propFile);
            prop.load(fis);
        }
        catch (FileNotFoundException e) {
            LOG.info("Properties file '" + propFile.getAbsolutePath() + "' not found", (Throwable)e);
            IOUtils.closeQuietly((InputStream)fis);
        }
        catch (IOException e2) {
            LOG.info("Error reading properties file '" + propFile.getAbsolutePath() + "'.", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
        IOUtils.closeQuietly((InputStream)fis);
        for (int i = 0; i < prop.size(); ++i) {
            Object subType;
            Object value;
            String host;
            String serverKey = "server[" + i + "]";
            String subtypeKey = "subtype[" + i + "]";
            if (!prop.containsKey(serverKey) || !prop.containsKey(subtypeKey) || serversMapPersistence.containsKey(host = (value = prop.get(serverKey)).toString()) || (subType = prop.get(subtypeKey)) == null) continue;
            ServerData server = new ServerData(host, "CATALOG", subType.toString());
            serversMapPersistence.put(host, server);
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f == null) {
            return false;
        }
        return f instanceof AbstractViewPanel;
    }
}

