/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.catalog.CatalogClient;
import org.gvsig.catalog.drivers.GetRecordsReply;
import org.gvsig.catalog.gui.ChooseResourceDialog;
import org.gvsig.catalog.gui.ShowTreeDialog;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.schemas.Record;
import org.gvsig.catalog.schemas.Resource;
import org.gvsig.catalog.ui.showresults.ShowResultsDialogPanel;
import org.gvsig.catalog.utils.Frames;
import org.gvsig.i18n.Messages;

public class ShowResultsDialog
extends ShowResultsDialogPanel {
    public ShowResultsDialog(CatalogClient client, GetRecordsReply recordsReply, int currentRecord) {
        super(client, recordsReply, currentRecord);
        this.setPreferredSize(new Dimension(640, 440));
    }

    public void descriptionButtonActionPerformed() {
        Record record = this.recordsReply.getRecordAt(this.getCurrentNode());
        if (record == null) {
            return;
        }
        XMLNode node = record.getNode();
        if (node == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), Messages.getText((String)"Error_accediendo_a_los_datos"));
        } else {
            JDialog panel = new JDialog((Frame)PluginServices.getMainFrame(), false);
            Frames.centerFrame((JDialog)panel, (int)796, (int)675);
            panel.setTitle(Messages.getText((String)"metadata_tree"));
            panel.setResizable(false);
            ShowTreeDialog dialog = new ShowTreeDialog(panel, node);
            panel.getContentPane().add((Component)((Object)dialog));
            panel.show();
        }
    }

    public void mapButtonActionPerformed() {
        Resource[] resources = this.controlsPanel.getRecord().getResources();
        ArrayList<Resource> col = new ArrayList<Resource>();
        col.addAll(Arrays.asList(resources));
        ChooseResourceDialog dialog = new ChooseResourceDialog(col);
        dialog.setName(Messages.getText((String)"Recursos Disponibles"));
        dialog.setVisible(true);
        PluginServices.getMDIManager().addWindow((IWindow)dialog);
    }

    public void closeButtonActionPerformed() {
        this.closeJDialog();
    }

    public void closeJDialog() {
        this.setVisible(false);
    }
}

