/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.annotation.swing.impl.panel;

import javax.swing.JComboBox;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.i18n.Messages;

public class FeatuteAttributeCombo
extends JComboBox {
    private FeatureStore featureStore;
    private boolean isNullable = true;

    public FeatuteAttributeCombo(FeatureStore featureStore, boolean isNullable) throws DataException {
        this.featureStore = featureStore;
        this.setNullable(isNullable);
        this.addFields();
    }

    public FeatuteAttributeCombo(FeatureStore featureStore, int dataType, boolean isNullable) throws DataException {
        this.featureStore = featureStore;
        this.setNullable(isNullable);
        this.addFields(dataType);
    }

    private void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
        if (isNullable) {
            this.addItem(new String("- " + Messages.getText((String)"default") + " -"));
        }
    }

    private void addFields() throws DataException {
        FeatureAttributeDescriptor[] featureAttributeDescriptors = this.featureStore.getDefaultFeatureType().getAttributeDescriptors();
        for (int i = 0; i < featureAttributeDescriptors.length; ++i) {
            this.addItem(featureAttributeDescriptors[i].getName());
        }
    }

    private void addFields(int dataType) throws DataException {
        FeatureAttributeDescriptor[] featureAttributeDescriptors = this.featureStore.getDefaultFeatureType().getAttributeDescriptors();
        for (int i = 0; i < featureAttributeDescriptors.length; ++i) {
            if (featureAttributeDescriptors[i].getDataType().getType() == dataType) {
                this.addItem(featureAttributeDescriptors[i].getName());
            }
            if (7 != dataType) continue;
            if (4 == featureAttributeDescriptors[i].getDataType().getType()) {
                this.addItem(featureAttributeDescriptors[i].getName());
                continue;
            }
            if (5 != featureAttributeDescriptors[i].getDataType().getType()) continue;
            this.addItem(featureAttributeDescriptors[i].getName());
        }
    }

    public String getSelectedAttribute() {
        if (this.isNullable) {
            int index = super.getSelectedIndex();
            if (index == 0) {
                return null;
            }
            return (String)super.getSelectedItem();
        }
        return (String)super.getSelectedItem();
    }
}

