/*
 * Decompiled with CFR 0.152.
 */
package gishur.core;

import gishur.core.Comparitor;
import gishur.core.FibonacciNode;
import gishur.core.KeyValueHolder;
import gishur.core.PriorityQueue;
import gishur.core.SimpleList;
import gishur.core.StdComparitor;

public class FibonacciHeap
implements PriorityQueue {
    private SimpleList _rootlist;
    private FibonacciNode _min = null;
    private int _size = 0;
    private Comparitor _comparitor = new StdComparitor();

    private int log(int n) {
        int n2 = 1;
        int n3 = 0;
        while (n2 < n) {
            n2 = 2 * n2;
            ++n3;
        }
        return n3;
    }

    private void consolidate() {
        int n = 2 * this.log(this._size);
        FibonacciNode[] fibonacciNodeArray = new FibonacciNode[n];
        int n2 = 0;
        while (n2 < n) {
            fibonacciNodeArray[n2] = null;
            ++n2;
        }
        while (!this._rootlist.empty()) {
            FibonacciNode fibonacciNode = (FibonacciNode)this._rootlist.first();
            this._rootlist.remove(fibonacciNode);
            this.tableInsert(fibonacciNodeArray, fibonacciNode);
        }
        this._min = null;
        int n3 = 0;
        while (n3 < n) {
            if (fibonacciNodeArray[n3] != null) {
                fibonacciNodeArray[n3]._mark = false;
                fibonacciNodeArray[n3]._parent = null;
                this._rootlist.insert(null, fibonacciNodeArray[n3]);
                if (this._min == null || this._comparitor.compare(fibonacciNodeArray[n3].key(), this._min.key()) == -1) {
                    this._min = fibonacciNodeArray[n3];
                }
            }
            ++n3;
        }
    }

    public String toString() {
        return this._rootlist.toString();
    }

    public KeyValueHolder extractMin() {
        if (this._min == null) {
            return null;
        }
        this._rootlist.concat(this._min._childlist);
        this._min._degree = 0;
        this._rootlist.remove(this._min);
        FibonacciNode fibonacciNode = this._min;
        if (this._rootlist.empty()) {
            this._min = null;
        } else {
            this.consolidate();
        }
        --this._size;
        return fibonacciNode;
    }

    public FibonacciHeap() {
        this._rootlist = new SimpleList();
    }

    public FibonacciHeap(Comparitor comparitor) {
        this._rootlist = new SimpleList();
        this._comparitor = comparitor;
    }

    public KeyValueHolder insert(KeyValueHolder keyValueHolder) {
        FibonacciNode fibonacciNode = new FibonacciNode(keyValueHolder);
        FibonacciHeap fibonacciHeap = new FibonacciHeap();
        fibonacciHeap._rootlist.insert(null, fibonacciNode);
        fibonacciHeap._min = fibonacciNode;
        fibonacciHeap._size = 1;
        this.meld(fibonacciHeap);
        return fibonacciNode;
    }

    public void meld(PriorityQueue priorityQueue) {
        if (priorityQueue == null) {
            return;
        }
        FibonacciHeap fibonacciHeap = (FibonacciHeap)priorityQueue;
        this._rootlist.concat(fibonacciHeap._rootlist);
        this._size += fibonacciHeap._size;
        if (this._min == null) {
            this._min = fibonacciHeap._min;
        } else if (fibonacciHeap._min != null && this._comparitor.compare(fibonacciHeap._min.key(), this._min.key()) == -1) {
            this._min = fibonacciHeap._min;
        }
        fibonacciHeap.clear();
    }

    public FibonacciNode insert(FibonacciNode fibonacciNode) {
        FibonacciHeap fibonacciHeap = new FibonacciHeap();
        fibonacciHeap._rootlist.insert(null, fibonacciNode);
        fibonacciHeap._min = fibonacciNode;
        fibonacciHeap._size = 1;
        this.meld(fibonacciHeap);
        return fibonacciNode;
    }

    public void setComparitor(Comparitor comparitor) {
        this._comparitor = comparitor;
    }

    public Comparitor comparitor() {
        return this._comparitor;
    }

    public boolean empty() {
        return this._rootlist.empty();
    }

    public void decreaseKey(Object object, KeyValueHolder keyValueHolder) {
        FibonacciNode fibonacciNode = (FibonacciNode)keyValueHolder;
        if (this._comparitor.compare(object, fibonacciNode.key()) == 1) {
            return;
        }
        fibonacciNode.setKey(object);
        if (this._comparitor.compare(fibonacciNode.key(), this._min.key()) == -1) {
            this._min = fibonacciNode;
        }
        if (fibonacciNode._parent == null || this._comparitor.compare(fibonacciNode._parent.key(), fibonacciNode.key()) == -1) {
            return;
        }
        fibonacciNode._mark = true;
        while (fibonacciNode._parent != null && fibonacciNode._mark) {
            FibonacciNode fibonacciNode2 = fibonacciNode._parent;
            this.cut(fibonacciNode);
            fibonacciNode = fibonacciNode2;
        }
        if (fibonacciNode._parent != null) {
            fibonacciNode._mark = true;
        }
    }

    public void clear() {
        this._size = 0;
        this._min = null;
        this._rootlist.clear();
    }

    public KeyValueHolder min() {
        return this._min;
    }

    public void delete(KeyValueHolder keyValueHolder) {
        this.decreaseKey(new Integer(Integer.MIN_VALUE), keyValueHolder);
        this.extractMin();
    }

    private void cut(FibonacciNode fibonacciNode) {
        FibonacciNode fibonacciNode2 = fibonacciNode._parent;
        if (fibonacciNode2 != null) {
            fibonacciNode._parent._childlist.remove(fibonacciNode);
            --fibonacciNode._parent._degree;
            fibonacciNode._parent = null;
            fibonacciNode._mark = false;
            this._rootlist.insert(null, fibonacciNode);
        }
    }

    private FibonacciNode link(FibonacciNode fibonacciNode, FibonacciNode fibonacciNode2) {
        if (this._comparitor.compare(fibonacciNode.key(), fibonacciNode2.key()) == 1) {
            return this.link(fibonacciNode2, fibonacciNode);
        }
        fibonacciNode._childlist.insert(null, fibonacciNode2);
        fibonacciNode2._parent = fibonacciNode;
        ++fibonacciNode._degree;
        return fibonacciNode;
    }

    private void tableInsert(FibonacciNode[] fibonacciNodeArray, FibonacciNode fibonacciNode) {
        if (fibonacciNodeArray[fibonacciNode._degree] == null) {
            fibonacciNodeArray[fibonacciNode._degree] = fibonacciNode;
            return;
        }
        FibonacciNode fibonacciNode2 = fibonacciNodeArray[fibonacciNode._degree];
        fibonacciNodeArray[fibonacciNode._degree] = null;
        fibonacciNode = this.link(fibonacciNode, fibonacciNode2);
        this.tableInsert(fibonacciNodeArray, fibonacciNode);
    }
}

