/*
 * Decompiled with CFR 0.152.
 */
package gishur.core;

import gishur.core.Parameters;
import java.awt.Point;

public class ParameterContainer
implements Parameters {
    private Object[] _param;
    private int _offset;
    private int _length;

    public void setParameter(int n, boolean bl) {
        if (n < 0 || n >= this._length) {
            return;
        }
        this._param[this._offset + n] = new Boolean(bl);
    }

    public Object parameter(int n) {
        if (n < 0 || n >= this._length) {
            return null;
        }
        return this._param[n + this._offset];
    }

    public Object[] parameter(int n, int n2) {
        if (n < 0 || n >= this._length || n + n2 > this._length) {
            return null;
        }
        Object[] objectArray = new Object[n2];
        System.arraycopy(this._param, n + this._offset, objectArray, 0, n2);
        return objectArray;
    }

    public void setParameterGlobal(int n, Object object) {
        if (n < 0 || n >= this._param.length) {
            return;
        }
        this._param[n] = object;
    }

    public void setParameterGlobal(int n, Object[] objectArray, int n2, int n3) {
        if ((n3 = Math.min(n3, this._param.length - n)) <= 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n2 >= objectArray.length || n2 + n3 > objectArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(objectArray, n2, this._param, n, n3);
    }

    public String toString() {
        String string = this.getClass().getName() + "[offset=" + this._offset + ",length=" + this._length + ",{";
        if (this._length > 0) {
            int n = 0;
            while (n < this._length) {
                string = string + this._param[this._offset + n].toString();
                if (n < this._length - 1) {
                    string = string + ",";
                }
                ++n;
            }
        }
        string = string + "}]";
        return string;
    }

    public int getInt(int n) {
        if (n < 0 || n >= this._length) {
            return Integer.MAX_VALUE;
        }
        if (this._param[n + this._offset] instanceof Integer) {
            return (Integer)this._param[n + this._offset];
        }
        throw new IllegalArgumentException();
    }

    public ParameterContainer(int n) {
        this._param = new Object[n];
        this._offset = 0;
        this._length = n;
    }

    public ParameterContainer(Object object) {
        this._param = new Object[]{object};
        this._offset = 0;
        this._length = 1;
    }

    public ParameterContainer(Object[] objectArray, int n, int n2) {
        this._param = new Object[Math.min(n + n2, objectArray.length)];
        System.arraycopy(objectArray, n, this._param, 0, Math.min(n + n2, objectArray.length));
        this._offset = 0;
        this._length = this._param.length;
    }

    public void setParameterPoint(int n, int n2, int n3) {
        if (n >= this._length || n < 0) {
            return;
        }
        this._param[this._offset + n] = new Point(n2, n3);
    }

    public float getFloat(int n) {
        if (n < 0 || n >= this._length) {
            return Float.MAX_VALUE;
        }
        if (this._param[n + this._offset] instanceof Float) {
            return ((Float)this._param[n + this._offset]).floatValue();
        }
        throw new IllegalArgumentException();
    }

    public boolean getBoolean(int n) {
        if (n < 0 || n >= this._length) {
            return false;
        }
        if (this._param[n + this._offset] instanceof Boolean) {
            return (Boolean)this._param[n + this._offset];
        }
        throw new IllegalArgumentException();
    }

    public long getLong(int n) {
        if (n < 0 || n >= this._length) {
            return Long.MAX_VALUE;
        }
        if (this._param[n + this._offset] instanceof Long) {
            return (Long)this._param[n + this._offset];
        }
        throw new IllegalArgumentException();
    }

    public int globalLength() {
        return this._param.length;
    }

    public void setParameter(int n, Object object) {
        if (n >= this._length || n < 0) {
            return;
        }
        this._param[this._offset + n] = object;
    }

    public void setParameter(int n, Object[] objectArray, int n2, int n3) {
        if ((n3 = Math.min(n3, this._length - n)) <= 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n2 >= objectArray.length || n2 + n3 > objectArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(objectArray, n2, this._param, this._offset + n, n3);
    }

    public void setParameter(int n, int n2) {
        if (n < 0 || n >= this._length) {
            return;
        }
        this._param[this._offset + n] = new Integer(n2);
    }

    public void setMask(int n, int n2) {
        this.setOffset(n);
        this.setLength(n2);
    }

    public Point point(int n) {
        if (n < 0 || n >= this._length) {
            return null;
        }
        if (!(this._param[n + this._offset] instanceof Point)) {
            return null;
        }
        return (Point)this._param[n + this._offset];
    }

    public void setOffset(int n) {
        if (n < 0 || n >= this._param.length) {
            this._offset = this._param.length;
            this._length = 0;
            return;
        }
        this._offset = n;
        this._length = Math.min(this._length, this._param.length - n);
    }

    public int offset() {
        return this._offset;
    }

    public Point[] point(int n, int n2) {
        if (n < 0 || n >= this._length || n + n2 > this._length) {
            return null;
        }
        Point[] pointArray = new Point[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (!(this._param[n + n3 + this._offset] instanceof Point)) {
                return null;
            }
            pointArray[n3] = (Point)this._param[n + n3 + this._offset];
            ++n3;
        }
        return pointArray;
    }

    public int length() {
        return this._length;
    }

    public void setLength(int n) {
        if (this._offset + n > this._param.length || n < 0) {
            this._length = this._param.length - this._offset;
            return;
        }
        this._length = n;
    }

    public void setParameter(int n, short s) {
        if (n < 0 || n >= this._length) {
            return;
        }
        this._param[this._offset + n] = new Short(s);
    }

    public void setParameter(int n, long l) {
        if (n < 0 || n >= this._length) {
            return;
        }
        this._param[this._offset + n] = new Long(l);
    }

    public void setParameter(int n, float f) {
        if (n < 0 || n >= this._length) {
            return;
        }
        this._param[this._offset + n] = new Float(f);
    }

    public void setParameter(int n, double d) {
        if (n < 0 || n >= this._length) {
            return;
        }
        this._param[this._offset + n] = new Double(d);
    }

    public short getShort(int n) {
        if (n < 0 || n >= this._length) {
            return Short.MAX_VALUE;
        }
        if (this._param[n + this._offset] instanceof Short) {
            return (Short)this._param[n + this._offset];
        }
        throw new IllegalArgumentException();
    }

    public double getDouble(int n) {
        if (n < 0 || n >= this._length) {
            return Double.MAX_VALUE;
        }
        if (this._param[n + this._offset] instanceof Double) {
            return (Double)this._param[n + this._offset];
        }
        throw new IllegalArgumentException();
    }
}

