/*
 * Decompiled with CFR 0.152.
 */
package gishur.core.algorithms;

import gishur.core.algorithms.TraceException;
import gishur.core.algorithms.TraceLabel;
import gishur.core.algorithms.Tracer;

public class TraceCursor {
    private Tracer _tracer;
    private TraceLabel _label = null;

    public void invalidate() {
        this._label = null;
    }

    public void end() {
        this._label = this._tracer.lastLabel();
    }

    public void end(int n) {
        this._label = this._tracer.firstLabel().prev(n);
    }

    public void goTo(TraceLabel traceLabel) {
        if (this._tracer != traceLabel.parent()) {
            return;
        }
        this._label = traceLabel;
    }

    public boolean valid() {
        return this._label != null && this._label.level() >= 0;
    }

    TraceCursor(Tracer tracer) {
        if (tracer == null) {
            throw new TraceException(0);
        }
        this._tracer = tracer;
    }

    public String toString() {
        if (this._label == null) {
            return "TraceCursor@" + this._tracer.toString();
        }
        String string = "TraceCursor@";
        return this._label.toString(string, true);
    }

    public void nextUp() {
        if (this._label == null) {
            return;
        }
        this._label = this._label.nextUp();
    }

    public boolean isLast() {
        if (this._label == null || this._label.level() < 0) {
            return false;
        }
        return this._label.next() == null;
    }

    public void prevUp() {
        if (this._label == null) {
            return;
        }
        this._label = this._label.prevUp();
    }

    public void next() {
        if (this._label == null) {
            this._label = this._tracer.firstLabel().next();
            return;
        }
        this._label = this._label.next();
    }

    public void next(int n) {
        if (this._label == null) {
            this._label = this._tracer.firstLabel().next(n);
            return;
        }
        this._label = this._label.next(n);
    }

    public void home() {
        this._label = this._tracer.firstLabel().next();
    }

    public void home(int n) {
        this._label = this._tracer.firstLabel().next(n);
    }

    public boolean isFirst() {
        if (this._label == null || this._label.level() < 0) {
            return false;
        }
        return this._label.prev() == null;
    }

    public void prev() {
        if (this._label == null) {
            this._label = this._tracer.lastLabel();
            return;
        }
        this._label = this._label.prev();
    }

    public void prev(int n) {
        if (this._label == null) {
            this._label = this._tracer.firstLabel().prev(n);
            return;
        }
        this._label = this._label.prev(n);
    }

    public final TraceLabel label() {
        return this._label;
    }
}

