/*
 * Decompiled with CFR 0.152.
 */
package gishur.core.algorithms;

import gishur.core.Cloneable;
import gishur.core.ControlledCloneable;
import gishur.core.List;
import gishur.core.ListItem;
import gishur.core.algorithms.TraceException;
import gishur.core.algorithms.Tracer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class TraceObject {
    private Tracer _parent = null;
    private String _name = null;
    private int[] _step = null;
    private Object[] _instance;

    public synchronized void record(Object object) {
        if (!this._parent.recordMode()) {
            throw new TraceException(2563);
        }
        if (this._step != null) {
            throw new TraceException(2563);
        }
        List list = (List)this._instance[0];
        list.add(new Integer(this._parent.getStepNumber()), TraceObject.cloneObject(object));
    }

    TraceObject(Tracer tracer, String string) {
        if (string == null && tracer == null) {
            throw new TraceException(2561);
        }
        this._name = string;
        this._parent = tracer;
        this.startRecord();
    }

    synchronized void finishRecord() {
        if (this._step != null) {
            return;
        }
        List list = (List)this._instance[0];
        int n = list.length();
        this._step = new int[n];
        this._instance = new Object[n];
        if (n == 0) {
            return;
        }
        n = 0;
        ListItem listItem = list.first();
        while (listItem != null) {
            this._step[n] = (Integer)listItem.key();
            this._instance[n++] = listItem.value();
            listItem = listItem.next();
        }
    }

    public boolean accessMode() {
        return this._step != null;
    }

    private int findIndex(int n) {
        if (this._step.length <= 0) {
            return -1;
        }
        int n2 = 0;
        int n3 = this._step.length;
        int n4 = n3 / 2;
        while (n4 != n2) {
            if (this._step[n4] == n) {
                n2 = n3 = n4;
                continue;
            }
            if (this._step[n4] < n) {
                n2 = n4;
            } else {
                n3 = n4;
            }
            n4 = (n2 + n3) / 2;
        }
        if (n4 == 0 && this._step[0] > n) {
            return -1;
        }
        return n4;
    }

    synchronized void startRecord() {
        this._step = null;
        this._instance = new Object[1];
        this._instance[0] = new List();
    }

    public Object[] instances(int n, int n2) {
        int n3;
        if (this._step == null || n >= n2) {
            return new Object[0];
        }
        int n4 = this.findIndex(n) + 1;
        if (n4 > (n3 = this.findIndex(n2))) {
            return new Object[0];
        }
        Object[] objectArray = new Object[n3 - n4 + 1];
        System.arraycopy(this._instance, n4, objectArray, 0, objectArray.length);
        return objectArray;
    }

    public Object instance(int n) {
        if (this._step == null) {
            List list = (List)this._instance[0];
            if (list.length() <= 0) {
                return null;
            }
            return list.lastValue();
        }
        int n2 = this.findIndex(n);
        if (n2 < 0) {
            return null;
        }
        return this._instance[n2];
    }

    private static final Object cloneObject(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof java.lang.Cloneable)) {
            return object;
        }
        if (object instanceof ControlledCloneable) {
            return ((ControlledCloneable)object).clone(new Hashtable(), -1);
        }
        if (object instanceof Cloneable) {
            return ((Cloneable)object).clone();
        }
        try {
            Method method = object.getClass().getDeclaredMethod("clone", new Class[0]);
            if (Modifier.isPublic(method.getModifiers())) {
                return method.invoke(object, new Object[0]);
            }
        }
        catch (Exception exception) {}
        return object;
    }

    public synchronized void recordNoClone(Object object) {
        if (!this._parent.recordMode()) {
            throw new TraceException(2563);
        }
        if (this._step != null) {
            throw new TraceException(2563);
        }
        List list = (List)this._instance[0];
        list.add(new Integer(this._parent.getStepNumber()), object);
    }

    public boolean recordMode() {
        return this._step == null && this._parent.recordMode();
    }

    public String name() {
        return this._name;
    }
}

