/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.gui.layerproperties;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.JExpressionPicker;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;

public class ExpressionFieldCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final JExpressionPicker picker;

    public ExpressionFieldCellEditor(FeatureStore store) {
        ExpressionEvaluatorSwingManager manager = ExpressionEvaluatorSwingLocator.getManager();
        this.picker = manager.createJExpressionPicker();
        if (store != null) {
            DataSwingManager dataSwingManager = DALSwingLocator.getManager();
            dataSwingManager.configureExpressionBuilder(this.picker.getConfig(), store);
        }
    }

    @Override
    public Object getCellEditorValue() {
        Expression value = this.picker.getExpression();
        if (value == null) {
            return null;
        }
        return value.getPhrase();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof String) {
            this.picker.setExpression(ExpressionUtils.createExpression((String)((String)value)));
        } else {
            this.picker.setExpression(null);
        }
        return this.picker.asJComponent();
    }
}

