/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.gui.layerproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.view.legend.gui.Categories;
import org.gvsig.app.project.documents.view.legend.gui.ILegendPanel;
import org.gvsig.app.project.documents.view.legend.gui.JSymbolPreviewButton;
import org.gvsig.app.project.documents.view.legend.gui.SymbolTable;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.ClassifiableVectorial;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.PictureFillSymbol;
import org.gvsig.symbology.fmap.rendering.VectorFilterExpressionLegend;
import org.gvsig.symbology.gui.layerproperties.ExpressionFieldCellEditor;
import org.gvsig.symbology.gui.layerproperties.ExpressionSymbolPanel;
import org.gvsig.symbology.swing.SymbologySwingLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.usability.UsabilitySwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorFilterExpressionPanel
extends JPanel
implements ILegendPanel,
ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(VectorFilterExpressionPanel.class);
    private static final long serialVersionUID = -7187473609965942511L;
    private VectorFilterExpressionLegend theLegend;
    private VectorFilterExpressionLegend auxLegend;
    private ClassifiableVectorial layer;
    private PictureFillSymbol previewSymbol;
    private JPanel pnlCenter;
    private JPanel pnlMovBut;
    private SymbolTable symbolTable;
    private JButton btnAddExpression;
    private JButton btnRemoveExpression;
    private JButton moveUp;
    private JButton moveDown;
    private int shapeType;
    protected JCheckBox chkdefaultvalues = null;
    protected JSymbolPreviewButton defaultSymbolPrev;
    private GridBagLayoutPanel defaultSymbolPanel = new GridBagLayoutPanel();
    private UsabilitySwingManager usabilitySwingManager = ToolsSwingLocator.getUsabilitySwingManager();

    public VectorFilterExpressionPanel() {
        this.initialize();
    }

    private void initialize() {
        this.pnlCenter = new JPanel();
        this.pnlCenter.setLayout(new BorderLayout());
        JPanel pnlButtons = new JPanel();
        this.btnAddExpression = this.usabilitySwingManager.createJButton(Messages.getText((String)"Anadir"));
        this.btnAddExpression.setActionCommand("NEW_EXPRESSION");
        this.btnAddExpression.addActionListener(this);
        pnlButtons.add(this.btnAddExpression);
        this.btnRemoveExpression = this.usabilitySwingManager.createJButton(Messages.getText((String)"Quitar"));
        this.btnRemoveExpression.setActionCommand("REMOVE");
        this.btnRemoveExpression.addActionListener(this);
        pnlButtons.add(this.btnRemoveExpression);
        this.defaultSymbolPanel.add((Component)this.getChkDefaultvalues());
        this.pnlCenter.add((Component)this.defaultSymbolPanel, "North");
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlCenter, "Center");
        this.add((Component)pnlButtons, "South");
    }

    public void getDefaultSymbolPrev(int shapeType) {
        if (this.defaultSymbolPrev == null) {
            this.defaultSymbolPrev = new JSymbolPreviewButton(shapeType);
            this.defaultSymbolPrev.setPreferredSize(new Dimension(110, 20));
            this.defaultSymbolPanel.add((Component)this.defaultSymbolPrev, null);
        }
    }

    public String getDescription() {
        return Messages.getText((String)"shows_the_elements_of_the_layer_depending_on_the_value_of_a_filter_expression") + ".";
    }

    public ISymbol getIconSymbol() {
        if (this.previewSymbol == null) {
            try {
                this.previewSymbol = new PictureFillSymbol();
                this.previewSymbol.setImage(new File(this.getClass().getClassLoader().getResource("images" + File.separator + "legend" + File.separator + "legend-overview-vectorial-unique-value.png").getFile()).toURI().toURL());
                this.previewSymbol.getMarkerFillProperties().setFillStyle(2);
            }
            catch (IOException e) {
                return null;
            }
        }
        return this.previewSymbol;
    }

    public ILegend getLegend() {
        this.auxLegend.clear();
        this.fillSymbolListFromTable();
        this.theLegend = (VectorFilterExpressionLegend)this.auxLegend.cloneLegend();
        if (this.defaultSymbolPrev.getSymbol() != null) {
            this.theLegend.setDefaultSymbol(this.defaultSymbolPrev.getSymbol());
        }
        this.theLegend.useDefaultSymbol(this.chkdefaultvalues.isSelected());
        return this.theLegend;
    }

    private void fillSymbolListFromTable() {
        FLyrVect m = (FLyrVect)this.layer;
        try {
            if (this.auxLegend.getClassifyingFieldNames() != null) {
                String[] fNames = this.auxLegend.getClassifyingFieldNames();
                int[] fieldTypes = new int[this.auxLegend.getClassifyingFieldNames().length];
                FeatureStore fsto = (FeatureStore)m.getDataStore();
                FeatureType fty = fsto.getDefaultFeatureType();
                for (int i = 0; i < fNames.length; ++i) {
                    fieldTypes[i] = fty.getAttributeDescriptor(fNames[i]).getType();
                }
                this.auxLegend.setClassifyingFieldTypes(fieldTypes);
            }
        }
        catch (Exception fNames) {
            // empty catch block
        }
        this.auxLegend.useDefaultSymbol(this.chkdefaultvalues.isSelected());
        for (int row = 0; row < this.symbolTable.getRowCount(); ++row) {
            Object clave = this.symbolTable.getFieldValue(row, 1);
            ISymbol theSymbol = (ISymbol)this.symbolTable.getFieldValue(row, 0);
            theSymbol.setDescription((String)this.symbolTable.getFieldValue(row, 2));
            this.auxLegend.addSymbol(clave, theSymbol);
        }
        if (this.chkdefaultvalues.isSelected() && this.defaultSymbolPrev.getSymbol() != null) {
            String description = VectorFilterExpressionLegend.I18N_DEFAULT;
            this.defaultSymbolPrev.getSymbol().setDescription(description);
            this.auxLegend.addSymbol(description, this.defaultSymbolPrev.getSymbol());
        }
    }

    public Class<VectorFilterExpressionLegend> getLegendClass() {
        return VectorFilterExpressionLegend.class;
    }

    public JPanel getPanel() {
        return this;
    }

    public Class<Categories> getParentClass() {
        return Categories.class;
    }

    public String getTitle() {
        return Messages.getText((String)"expressions");
    }

    public boolean isSuitableFor(FLayer layer) {
        if (!(layer instanceof FLyrVect)) {
            return false;
        }
        FLyrVect lVect = (FLyrVect)layer;
        try {
            return VectorFilterExpressionLegend.isPoint(lVect.getShapeType()) || VectorFilterExpressionLegend.isLinear(lVect.getShapeType()) || VectorFilterExpressionLegend.isPolygonal(lVect.getShapeType());
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setData(FLayer lyr, ILegend legend) {
        this.layer = (ClassifiableVectorial)lyr;
        this.shapeType = 0;
        try {
            this.shapeType = this.layer.getGeometryType().getType();
        }
        catch (ReadException e) {
            logger.info("Error while getting layer shp type", (Throwable)e);
            ApplicationLocator.getManager().message(Messages.getText((String)"generating_intervals"), 0);
        }
        if (this.symbolTable != null) {
            this.pnlCenter.remove((Component)this.symbolTable);
        }
        if (this.pnlMovBut != null) {
            this.pnlCenter.remove(this.pnlMovBut);
        }
        this.getDefaultSymbolPrev(this.shapeType);
        this.symbolTable = new SymbolTable((Component)this, "expressions", this.shapeType);
        try {
            ExpressionFieldCellEditor cellEditor = new ExpressionFieldCellEditor(((FLyrVect)this.layer).getFeatureStore());
            this.symbolTable.setCellEditor((TableCellEditor)cellEditor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pnlCenter.add((Component)this.symbolTable, "Center");
        this.pnlCenter.add((Component)this.getPnlMovBut(), "East");
        if (legend instanceof VectorFilterExpressionLegend) {
            this.auxLegend = (VectorFilterExpressionLegend)legend.cloneLegend();
            if (this.auxLegend.isUseDefaultSymbol()) {
                this.fillTableSkipDefault(this.auxLegend);
            } else {
                this.symbolTable.fillTableFromSymbolList(this.auxLegend.getSymbols(), this.auxLegend.getValues(), this.auxLegend.getDescriptions());
            }
        } else {
            this.auxLegend = new VectorFilterExpressionLegend();
            this.auxLegend.setShapeType(this.shapeType);
        }
        this.defaultSymbolPrev.setSymbol(this.auxLegend.getDefaultSymbol());
        this.getChkDefaultvalues().setSelected(this.auxLegend.isUseDefaultSymbol());
    }

    private JPanel getPnlMovBut() {
        if (this.pnlMovBut == null) {
            this.pnlMovBut = new JPanel();
            this.pnlMovBut.setLayout(new BoxLayout(this.pnlMovBut, 1));
            this.pnlMovBut.add((Component)new JBlank(1, 70));
            ImageIcon ico = IconThemeHelper.getImageIcon((String)"symbol-layer-move-up");
            this.moveUp = this.usabilitySwingManager.createJButton((Icon)ico);
            this.pnlMovBut.add(this.moveUp);
            this.moveUp.setSize(new Dimension(15, 15));
            this.pnlMovBut.add((Component)new JBlank(1, 10));
            ico = IconThemeHelper.getImageIcon((String)"symbol-layer-move-down");
            this.moveDown = this.usabilitySwingManager.createJButton((Icon)ico);
            this.pnlMovBut.add(this.moveDown);
            this.pnlMovBut.add((Component)new JBlank(1, 70));
            this.moveDown.setActionCommand("MOVE-DOWN");
            this.moveUp.setActionCommand("MOVE-UP");
            this.moveDown.addActionListener(this);
            this.moveUp.addActionListener(this);
        }
        return this.pnlMovBut;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int targetPos;
        int classIndex;
        int[] indices = null;
        Object dummyFeat = null;
        if (e.getActionCommand() == "MOVE-UP" || e.getActionCommand() == "MOVE-DOWN") {
            indices = this.symbolTable.getSelectedRows();
        }
        if (e.getActionCommand() == "MOVE-UP" && indices.length > 0) {
            classIndex = indices[0];
            targetPos = Math.max(0, classIndex - 1);
            this.symbolTable.moveUpRows(classIndex, targetPos, indices.length);
        }
        if (e.getActionCommand() == "MOVE-DOWN" && indices.length > 0) {
            classIndex = indices[indices.length - 1];
            targetPos = Math.min(this.symbolTable.getRowCount() - 1, classIndex + 1);
            this.symbolTable.moveDownRows(classIndex, targetPos, indices.length);
        }
        if (e.getActionCommand() == "MOVE-UP" || e.getActionCommand() == "MOVE-DOWN") {
            ArrayList<String> orders = new ArrayList<String>();
            for (int i = 0; i < this.symbolTable.getRowCount(); ++i) {
                orders.add(this.symbolTable.getFieldValue(i, 1).toString());
            }
        }
        if (e.getActionCommand() == "NEW_EXPRESSION") {
            FLyrVect vect = (FLyrVect)this.layer;
            FeatureStore fsto = vect.getFeatureStore();
            FeatureType fty = fsto.getDefaultFeatureTypeQuietly();
            int shptype = fty.getDefaultGeometryAttribute().getGeomType().getType();
            I18nManager i18n = ToolsLocator.getI18nManager();
            ExpressionSymbolPanel esp = new ExpressionSymbolPanel(fsto, shptype, (ISymbol)this.previewSymbol);
            WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            Dialog dialog = windowManager.createDialog((JComponent)esp, i18n.getTranslation("expression_creator"), "", 3);
            dialog.addActionListener(e1 -> {
                if (dialog.getAction() != 1) {
                    return;
                }
                String expr = esp.getExpression();
                if (StringUtils.isBlank((CharSequence)expr)) {
                    ApplicationLocator.getManager().messageDialog(Messages.getText((String)"error_validating_filter_query"), Messages.getText((String)"error"), 0);
                    return;
                }
                ISymbol sym = esp.getSymbol();
                this.addClassFieldNames(fty);
                this.auxLegend.addSymbol(expr, sym);
                this.symbolTable.removeAllItems();
                this.fillTableSkipDefault(this.auxLegend);
                this.repaint();
            });
            dialog.show(WindowManager.MODE.DIALOG);
        } else if (e.getActionCommand() == "REMOVE") {
            if (this.symbolTable.getSelectedRowElements() == null) {
                JOptionPane.showMessageDialog(this, Messages.getText((String)"select_one_row"));
            } else {
                String my_expr = (String)this.symbolTable.getSelectedRowElements()[1];
                this.auxLegend.delSymbol(my_expr);
                this.symbolTable.removeAllItems();
                this.fillTableSkipDefault(this.auxLegend);
                this.repaint();
            }
        }
    }

    private void addClassFieldNames(FeatureType ft) {
        FeatureAttributeDescriptor[] atts = ft.getAttributeDescriptors();
        String[] nn = new String[atts.length];
        for (int i = 0; i < atts.length; ++i) {
            nn[i] = atts[i].getName();
        }
        this.addClassFieldNames(nn);
    }

    private void addClassFieldNames(String[] fieldNamesExpression) {
        boolean appears = false;
        ArrayList<String> myFieldNames = new ArrayList<String>();
        if (this.auxLegend.getClassifyingFieldNames() != null) {
            int i;
            for (i = 0; i < this.auxLegend.getClassifyingFieldNames().length; ++i) {
                myFieldNames.add(this.auxLegend.getClassifyingFieldNames()[i]);
            }
            for (i = 0; i < fieldNamesExpression.length; ++i) {
                appears = false;
                for (int j = 0; j < this.auxLegend.getClassifyingFieldNames().length; ++j) {
                    if (this.auxLegend.getClassifyingFieldNames()[j].compareTo(fieldNamesExpression[i]) != 0) continue;
                    appears = true;
                }
                if (appears) continue;
                myFieldNames.add(fieldNamesExpression[i]);
            }
            this.auxLegend.setClassifyingFieldNames(myFieldNames.toArray(new String[myFieldNames.size()]));
        } else {
            for (int i = 0; i < fieldNamesExpression.length; ++i) {
                myFieldNames.add(fieldNamesExpression[i]);
            }
            this.auxLegend.setClassifyingFieldNames(myFieldNames.toArray(new String[myFieldNames.size()]));
        }
    }

    public ImageIcon getIcon() {
        ImageIcon ii = IconThemeHelper.getImageIcon((String)"legend-overview-vector-filter-expression");
        return ii;
    }

    protected JCheckBox getChkDefaultvalues() {
        if (this.chkdefaultvalues == null) {
            this.chkdefaultvalues = new JCheckBox();
            this.chkdefaultvalues.setText(Messages.getText((String)"resto_valores") + ": ");
            this.chkdefaultvalues.setBounds(new Rectangle(342, 26, 141, 20));
            this.chkdefaultvalues.setSelected(false);
            this.chkdefaultvalues.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (VectorFilterExpressionPanel.this.chkdefaultvalues.isSelected()) {
                        VectorFilterExpressionPanel.this.auxLegend.useDefaultSymbol(true);
                    } else {
                        VectorFilterExpressionPanel.this.auxLegend.useDefaultSymbol(false);
                    }
                }
            });
        }
        return this.chkdefaultvalues;
    }

    private void fillTableSkipDefault(VectorFilterExpressionLegend leg) {
        Object[] src_expr = leg.getValues();
        ArrayList<Integer> rem_ind = new ArrayList<Integer>();
        for (int i = 0; i < src_expr.length; ++i) {
            if (VectorFilterExpressionLegend.I18N_DEFAULT.compareToIgnoreCase((String)src_expr[i]) != 0) continue;
            rem_ind.add(new Integer(i));
        }
        ISymbol[] src_syms = leg.getSymbols();
        String[] src_descs = leg.getDescriptions();
        ArrayList<ISymbol> syms = new ArrayList<ISymbol>();
        ArrayList<Object> vals = new ArrayList<Object>();
        ArrayList<String> descs = new ArrayList<String>();
        for (int i = 0; i < src_expr.length; ++i) {
            if (this.isIn(i, rem_ind)) continue;
            syms.add(src_syms[i]);
            vals.add(src_expr[i]);
            descs.add(src_descs[i]);
        }
        this.symbolTable.fillTableFromSymbolList(syms.toArray(new ISymbol[0]), vals.toArray(new Object[0]), descs.toArray(new String[0]));
        this.doUpdateCellEditor();
    }

    private void doUpdateCellEditor() {
        try {
            ExpressionFieldCellEditor cellEditor = new ExpressionFieldCellEditor(((FLyrVect)this.layer).getFeatureStore());
            this.symbolTable.setCellEditor((TableCellEditor)cellEditor);
        }
        catch (Exception ex) {
            logger.debug("Can't update cell editors", (Throwable)ex);
        }
    }

    private boolean isIn(int n, List<Integer> int_list) {
        if (int_list == null || int_list.size() == 0) {
            return false;
        }
        for (int i = 0; i < int_list.size(); ++i) {
            Integer item;
            if (!(int_list.get(i) instanceof Integer) || (item = int_list.get(i)) != n) continue;
            return true;
        }
        return false;
    }

    public static void selfRegister() {
        IconThemeHelper.registerIcon((String)"legend", (String)"legend-overview-vector-filter-expression", VectorFilterExpressionPanel.class);
        IconThemeHelper.registerIcon((String)"legend", (String)"legend-overview-vectorial-unique-value", VectorFilterExpressionPanel.class);
        IconThemeHelper.registerIcon((String)"symbol", (String)"symbol-layer-move-down", VectorFilterExpressionPanel.class);
        IconThemeHelper.registerIcon((String)"symbol", (String)"symbol-layer-move-up", VectorFilterExpressionPanel.class);
        SymbologySwingLocator.getSwingManager().registerLegendEditor(VectorFilterExpressionPanel.class);
        SymbolTable.addNewCellEditor((String)"expressions", (TableCellEditor)new ExpressionFieldCellEditor(null));
    }
}

