/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.osm.app.osmclient.layer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.print.attribute.PrintRequestAttributeSet;
import org.cresques.cts.ICoordTrans;
import org.gvsig.andami.PluginServices;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.ViewPortData;
import org.gvsig.fmap.dal.coverage.exception.FilePaletteException;
import org.gvsig.fmap.dal.coverage.exception.InfoByPointException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.IHasImageLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.fmap.layers.NotAvailableStateException;
import org.gvsig.raster.osm.io.OSMDataParameters;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.util.CancelTaskImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLyrOSM
extends DefaultFLyrRaster
implements IHasImageLegend {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(FLyrOSM.class);
    private List<WeakReference<Thread>> disableUpdateDrawVersion;
    private boolean firstLoad = false;
    private RasterManager rManager = RasterLocator.getManager();
    private boolean deleteCache = false;

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("FLyrOSM_Persistent");
        if (definition == null) {
            if (manager.getDefinition(DefaultFLyrRaster.class) == null) {
                DefaultFLyrRaster.registerPersistence();
            }
            definition = manager.addDefinition(FLyrOSM.class, "FLyrOSM_Persistent", "FLyrOSM Persistent Definition", null, null);
            definition.extend("Persistence", "FLyrRasterSE_Persistent");
        }
    }

    public FLyrOSM() {
        this.updateDrawVersion();
        try {
            this.enableAwake();
        }
        catch (NotAvailableStateException e) {
            logger.error("Fallo el estado de open. Closed=" + this.isClosed() + " Awake=" + this.isAwake(), (Object)this, (Object)e);
        }
    }

    public static DataStore createDataStore(URI host) throws InitializeException {
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        RasterDataParameters params = null;
        try {
            params = (RasterDataParameters)dataman.createStoreParameters("OSM Raster");
        }
        catch (InitializeException e) {
            RasterSwingLibrary.messageBoxInfo((String)"error_creating_parameters", (Object)PluginServices.getMDIManager().getActiveWindow(), (Exception)((Object)e));
        }
        catch (ProviderNotRegisteredException e) {
            RasterSwingLibrary.messageBoxInfo((String)"error_creating_parameters", (Object)PluginServices.getMDIManager().getActiveWindow(), (Exception)((Object)e));
        }
        params.setURI(host);
        try {
            return dataman.openStore(params.getDataStoreName(), (DataStoreParameters)params);
        }
        catch (ValidateDataParametersException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    public void setDataStore(DataStore dataStore) throws LoadLayerException {
        this.dataStore = (RasterDataStore)dataStore;
        try {
            this.enableOpen();
        }
        catch (NotAvailableStateException e) {
            logger.error("Fallo el estado de open. Closed=" + this.isClosed() + " Awake=" + this.isAwake(), (Object)this, (Object)e);
        }
        this.setProjection(this.dataStore.getProjection());
    }

    public void draw(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale) throws ReadException {
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        DefaultFLyrRaster.RasterTaskStatus taskStatus = new DefaultFLyrRaster.RasterTaskStatus((DefaultFLyrRaster)this, "Drawing " + this.getName() + "...", cancel);
        manager.add((TaskStatus)taskStatus);
        taskStatus.setAutoremove(true);
        if (this.recalcLevel) {
            double pixelSize = viewPort.getExtent().getWidth() / (double)viewPort.getImageWidth();
            this.zoomLevel = this.dataStore.getNearestLevel(pixelSize);
        }
        this.recalcLevel = true;
        if (!this.firstLoad) {
            try {
                this.initFilters();
                try {
                    if (!this.isOpen()) {
                        this.enableOpen();
                    }
                }
                catch (NotAvailableStateException e) {
                    throw new ReadException("Fallo el estado de open. Closed=" + this.isClosed() + " Awake=" + this.isAwake(), (Throwable)e);
                }
            }
            catch (FilePaletteException e) {
                throw new ReadException(e.getMessage(), (Throwable)e);
            }
            this.firstLoad = true;
        }
        this.enableStopped();
        if (this.isWithinScale(scale)) {
            if (!viewPort.getAdjustedExtent().intersects(this.getFullEnvelope())) {
                return;
            }
            Envelope adjustedExtent = viewPort.getAdjustedEnvelope();
            Extent ext = this.rManager.getDataStructFactory().createExtent(adjustedExtent.getLowerCorner().getX(), adjustedExtent.getUpperCorner().getY(), adjustedExtent.getUpperCorner().getX(), adjustedExtent.getLowerCorner().getY());
            Dimension imgSz = viewPort.getImageSize();
            ViewPortData vp2 = this.rManager.getDataStructFactory().createViewPortData(viewPort.getProjection(), ext, (Dimension2D)imgSz);
            vp2.setMat(viewPort.getAffineTransform());
            vp2.setDPI((int)viewPort.getDPI());
            try {
                OSMDataParameters par = this.getOSMParameters(this.getDataStore().getParameters());
                par.setWidth((int)viewPort.getImageSize().getWidth());
                par.setHeight((int)viewPort.getImageSize().getHeight());
                this.getRender().drawTiledService(g, vp2, (Dimension2D)viewPort.getImageSize(), (TaskStatus)taskStatus);
            }
            catch (ProcessInterruptedException e) {
                throw new ReadException("Problems drawing this layer: " + e.getMessage(), (Throwable)e);
            }
            catch (QueryException e) {
                throw new ReadException("Problems drawing this layer: " + e.getMessage(), (Throwable)e);
            }
            finally {
                taskStatus.terminate();
            }
        }
        this.disableStopped();
    }

    public void print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, PrintRequestAttributeSet properties) throws ReadException {
    }

    public void _print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale) throws ReadException {
        this.draw(null, g, viewPort, cancel, scale);
    }

    public HashMap<String, Object> getProperties() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        OSMDataParameters par = this.getOSMParameters(this.getDataStore().getParameters());
        String layerName = this.getName();
        try {
            info.put("selectedLayer", layerName);
            info.put("host", par.getURI());
            info.put("srs", this.dataStore.getProjection().getAbrev());
            return info;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getTocImageIcon() {
        return "icon-layer-osm";
    }

    public boolean isActionEnabled(int action) {
        switch (action) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 21: 
            case 22: {
                return false;
            }
            case 6: 
            case 20: {
                return true;
            }
        }
        return super.isActionEnabled(action);
    }

    public ILegend getLegend() {
        return null;
    }

    public boolean isRemote() {
        return true;
    }

    public boolean overviewsSupport() {
        return false;
    }

    protected void updateDrawVersion() {
        if (this.disableUpdateDrawVersion != null) {
            Thread curThread = Thread.currentThread();
            Iterator<WeakReference<Thread>> iter = this.disableUpdateDrawVersion.iterator();
            while (iter.hasNext()) {
                Thread aThread = (Thread)iter.next().get();
                if (aThread == null) {
                    iter.remove();
                    continue;
                }
                if (!aThread.equals(curThread)) continue;
                return;
            }
        }
        super.updateDrawVersion();
    }

    protected void disableUpdateDrawVersion() {
        if (this.disableUpdateDrawVersion == null) {
            this.disableUpdateDrawVersion = new ArrayList<WeakReference<Thread>>();
        }
        this.disableUpdateDrawVersion.add(new WeakReference<Thread>(Thread.currentThread()));
    }

    protected void enableUpdateDrawVersion() {
        if (this.disableUpdateDrawVersion == null) {
            return;
        }
        Thread curThread = Thread.currentThread();
        Iterator<WeakReference<Thread>> iter = this.disableUpdateDrawVersion.iterator();
        while (iter.hasNext()) {
            Thread aThread = (Thread)iter.next().get();
            if (aThread == null) {
                iter.remove();
                continue;
            }
            if (!aThread.equals(curThread)) continue;
            iter.remove();
            break;
        }
    }

    public String getFileFormat() {
        return "OSM";
    }

    public Envelope getFullEnvelope() {
        ICoordTrans ct;
        Extent e1 = this.getDataStore().getExtent();
        Envelope rAux = null;
        try {
            rAux = geomManager.createEnvelope(e1.getMin().getX(), e1.getMin().getY(), e1.getMax().getX(), e1.getMax().getY(), 0);
        }
        catch (CreateEnvelopeException exc) {
            logger.error("Error creating the envelope", (Throwable)exc);
        }
        if (rAux == null || rAux.getMaximum(0) - rAux.getMinimum(0) == 0.0 && rAux.getMaximum(1) - rAux.getMinimum(1) == 0.0) {
            try {
                rAux = geomManager.createEnvelope(0.0, 0.0, 100.0, 100.0, 0);
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error creating the envelope", (Throwable)e);
            }
        }
        if ((ct = this.getCoordTrans()) != null) {
            Point2D pt1 = new Point2D.Double(rAux.getMinimum(0), rAux.getMinimum(1));
            Point2D pt2 = new Point2D.Double(rAux.getMaximum(0), rAux.getMaximum(1));
            pt1 = ct.convert(pt1, null);
            pt2 = ct.convert(pt2, null);
            try {
                rAux = geomManager.createEnvelope(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY(), 0);
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error creating the envelope", (Throwable)e);
            }
        }
        return rAux;
    }

    public Extent getFullRasterExtent() {
        Envelope env = this.getFullEnvelope();
        double minx = env.getMinimum(0);
        double miny = env.getMinimum(1);
        double maxx = env.getMaximum(0);
        double maxy = env.getMaximum(1);
        Point2D.Double ul = new Point2D.Double(minx, maxy);
        Point2D.Double ur = new Point2D.Double(maxx, maxy);
        Point2D.Double ll = new Point2D.Double(minx, miny);
        Point2D.Double lr = new Point2D.Double(maxx, miny);
        return this.rManager.getDataStructFactory().createExtent((Point2D)ul, (Point2D)lr, (Point2D)ur, (Point2D)ll);
    }

    public DynObjectSet getInfo(Point p, double tolerance, Cancellable cancel) throws LoadLayerException, DataException {
        return null;
    }

    public DynObjectSet getInfo(Point p, double tolerance, Cancellable cancel, boolean fast) throws LoadLayerException, DataException {
        Point2D pReal = this.getMapContext().getViewPort().toMapPoint((Point2D)p);
        String fInfo = null;
        try {
            fInfo = this.getDataStore().getInfoByPoint(pReal.getX(), pReal.getY(), (ICancellable)new CancelTaskImpl(cancel));
        }
        catch (InfoByPointException e) {
            throw new LoadLayerException("Error in getInfoByPoint", (Throwable)e);
        }
        return null;
    }

    public void setParameters(DataStoreParameters params) throws InitializeException {
        if (params instanceof TileDataParameters) {
            ((TileDataParameters)params).deleteCache(this.deleteCache);
        }
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            DataParameters p;
            DataStore dStore = dataman.openStore(params.getDataStoreName(), params);
            this.setDataStore(dStore);
            if (params instanceof OSMDataParameters) {
                this.setName(((OSMDataParameters)params).getURI().getPath());
            }
            if (params instanceof TileDataParameters && (p = ((TileDataParameters)params).getDataParameters()) instanceof OSMDataParameters) {
                this.setName(((OSMDataParameters)p).getURI().getPath());
            }
        }
        catch (ValidateDataParametersException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (InitializeException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (LoadLayerException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    private OSMDataParameters getOSMParameters(DataStoreParameters parameters) {
        DataParameters p;
        OSMDataParameters params = null;
        if (parameters instanceof OSMDataParameters) {
            params = (OSMDataParameters)parameters;
        }
        if (parameters instanceof TileDataParameters && (p = ((TileDataParameters)parameters).getDataParameters()) instanceof OSMDataParameters) {
            params = (OSMDataParameters)p;
        }
        return params;
    }

    public Image getImageLegend() {
        return null;
    }

    public String getPathImage() {
        return null;
    }

    public FLayer cloneLayer() throws Exception {
        return super.cloneLayer();
    }

    public void deleteCache(boolean deleteCache) {
        this.deleteCache = deleteCache;
    }
}

