/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.raster.swing.impl.bands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.gvsig.fmap.mapcontext.raster.swing.impl.bands.RasterStoreBand;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.locator.LocatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BandsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5993288441174158255L;
    private static final Logger LOG = LoggerFactory.getLogger(BandsTableModel.class);
    List<RasterStoreBand> rasterStoreBands = new ArrayList<RasterStoreBand>();
    public static final List<String> RGBColorSpace = Arrays.asList("Red", "Green", "Blue", "Alpha");
    public static final List<String> CMYKColorSpace = Arrays.asList("Cyan", "Magenta", "Yellow", "Black", "Alpha");
    public static final List<String> HSLColorSpace = Arrays.asList("Hue", "Saturation", "Lightness", "Alpha");
    public static final List<String> YCBCRColorSpace = Arrays.asList("YCbCr_Cb", "YCbCr_Cr", "YCbCr_Y", "Alpha");
    public static final List<List<String>> ColorSpaces = Arrays.asList(RGBColorSpace, CMYKColorSpace, HSLColorSpace, YCBCRColorSpace);
    public static final List<String> ColorSpaceNames = Arrays.asList("RGB", "CMYK", "HSL", "YCBCR");
    public static final int COLUMN_COLOR = 0;
    public static final int COLUMN_NODATA = 1;
    public static final int COLUMN_DATA_TYPE = 2;
    public static final int COLUMN_STORE_NAME = 3;
    public static final int COLUMN_BAND = 4;
    public static final int COLUMN_BAND_NAME = 5;
    public static final int COLUMN_STORE_FULL_NAME = 6;

    @Override
    public int getRowCount() {
        return this.rasterStoreBands.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        RasterStoreBand rasterStoreBand = this.rasterStoreBands.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return rasterStoreBand.getBandColorInterpretation();
            }
            case 1: {
                return rasterStoreBand.getNoDataNumber();
            }
            case 2: {
                return rasterStoreBand.getDataType();
            }
            case 3: {
                return rasterStoreBand.getStore().getName();
            }
            case 4: {
                return rasterStoreBand.getBand();
            }
            case 5: {
                return rasterStoreBand.getBandName();
            }
            case 6: {
                return rasterStoreBand.getStore().getFullName();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        switch (column) {
            case 0: {
                return i18nManager.getTranslation("_color");
            }
            case 1: {
                return i18nManager.getTranslation("_nodata");
            }
            case 2: {
                return i18nManager.getTranslation("_data_type");
            }
            case 3: {
                return i18nManager.getTranslation("_store_name");
            }
            case 4: {
                return i18nManager.getTranslation("_band");
            }
            case 5: {
                return i18nManager.getTranslation("_band_name");
            }
            case 6: {
                return i18nManager.getTranslation("_store_full_name");
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex <= 1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Object value = aValue;
        if (columnIndex == 0) {
            this.rasterStoreBands.get(rowIndex).setBandColorInterpretation((String)aValue);
            String colorInterpretation = "Palette";
            if (((String)aValue).equalsIgnoreCase(colorInterpretation)) {
                this.setUndefinedAnyOtherBand(rowIndex);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "Gray")) {
                this.setUndefinedAnyOtherBand(rowIndex);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "Red")) {
                this.setUndefinedAnyOtherBandWithSameColorInterpretation(rowIndex, colorInterpretation);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "Green")) {
                this.setUndefinedAnyOtherBandWithSameColorInterpretation(rowIndex, colorInterpretation);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "Blue")) {
                this.setUndefinedAnyOtherBandWithSameColorInterpretation(rowIndex, colorInterpretation);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "Alpha")) {
                this.setUndefinedAnyOtherBandWithSameColorInterpretation(rowIndex, colorInterpretation);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "Hue")) {
                this.setUndefinedAnyOtherBandWithSameColorInterpretation(rowIndex, colorInterpretation);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "Saturation")) {
                this.setUndefinedAnyOtherBandWithSameColorInterpretation(rowIndex, colorInterpretation);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "Lightness")) {
                this.setUndefinedAnyOtherBandWithSameColorInterpretation(rowIndex, colorInterpretation);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "Cyan")) {
                this.setUndefinedAnyOtherBandWithSameColorInterpretation(rowIndex, colorInterpretation);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "Magenta")) {
                this.setUndefinedAnyOtherBandWithSameColorInterpretation(rowIndex, colorInterpretation);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "Yellow")) {
                this.setUndefinedAnyOtherBandWithSameColorInterpretation(rowIndex, colorInterpretation);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "Black")) {
                this.setUndefinedAnyOtherBandWithSameColorInterpretation(rowIndex, colorInterpretation);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "YCbCr_Y")) {
                this.setUndefinedAnyOtherBandWithSameColorInterpretation(rowIndex, colorInterpretation);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "YCbCr_Cb")) {
                this.setUndefinedAnyOtherBandWithSameColorInterpretation(rowIndex, colorInterpretation);
            }
            if (((String)aValue).equalsIgnoreCase(colorInterpretation = "YCbCr_Cr")) {
                this.setUndefinedAnyOtherBandWithSameColorInterpretation(rowIndex, colorInterpretation);
            }
            this.fireTableDataChanged();
        } else if (columnIndex == 1) {
            int dataType = this.rasterStoreBands.get(rowIndex).getDataType();
            BufferManager bufferManager = BufferLocator.getBufferManager();
            try {
                value = bufferManager.coerce(dataType, aValue);
                this.rasterStoreBands.get(rowIndex).setNoDataNumber((Number)value);
            }
            catch (CoercionException | LocatorException e) {
                I18nManager i18nManager = ToolsLocator.getI18nManager();
                LOG.warn(i18nManager.getTranslation("_it_cant_be_reconized_XvalueX_as_a_XdatatypenameX.", new String[]{aValue.toString(), bufferManager.getTypeName(dataType)}));
            }
        }
        super.setValueAt(value, rowIndex, columnIndex);
    }

    private void setUndefinedAnyOtherBand(int rowIndex) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (i == rowIndex) continue;
            this.rasterStoreBands.get(i).setBandColorInterpretation("Undefined");
        }
    }

    private void setUndefinedAnyOtherBandWithSameColorInterpretation(int rowIndex, String colorInterpretation) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (i == rowIndex) continue;
            if (((String)this.getValueAt(i, 0)).equalsIgnoreCase(colorInterpretation)) {
                this.rasterStoreBands.get(i).setBandColorInterpretation("Undefined");
            }
            if (this.areCompatible(colorInterpretation, (String)this.getValueAt(i, 0))) continue;
            this.rasterStoreBands.get(i).setBandColorInterpretation("Undefined");
        }
    }

    private boolean areCompatible(String colorInterpretation, String colorInterpretation2) {
        for (List<String> colorSpace : ColorSpaces) {
            if (!colorSpace.contains(colorInterpretation) || !colorSpace.contains(colorInterpretation2)) continue;
            return true;
        }
        return false;
    }

    public void add(RasterStoreBand rasterStoreBand) {
        this.rasterStoreBands.add(rasterStoreBand);
        DisposeUtils.bind((Disposable)rasterStoreBand);
    }

    public void removeElementAt(int selectedRow) {
        RasterStoreBand rasterStoreBand = this.rasterStoreBands.get(selectedRow);
        this.rasterStoreBands.remove(selectedRow);
        DisposeUtils.disposeQuietly((Disposable)rasterStoreBand);
    }

    public RasterStoreBand getElementAt(int selectedRow) {
        return this.rasterStoreBands.get(selectedRow);
    }
}

