/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.raster.swing.impl.previewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.FLyrDefault;
import org.gvsig.fmap.mapcontext.raster.swing.previewer.OneLayerPreviewer;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendChangedEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.listeners.LegendListener;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlCreationException;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseWheelBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MoveBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.RectangleBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.fmap.mapcontrol.tools.PanListenerImpl;
import org.gvsig.fmap.mapcontrol.tools.ZoomInListenerImpl;
import org.gvsig.fmap.mapcontrol.tools.ZoomOutListenerImpl;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.locator.LocatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOneLayerPreviewer
extends JPanel
implements OneLayerPreviewer,
Disposable {
    private static final long serialVersionUID = -2657400357281080433L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOneLayerPreviewer.class);
    private MapControl mapControl;
    private FLayer layer;
    private LegendListener legendListener;

    public DefaultOneLayerPreviewer() {
        this.setPreferredSize(new Dimension(300, 200));
        this.legendListener = new LegendListener(){

            public void legendChanged(LegendChangedEvent e) {
                DefaultOneLayerPreviewer.this.doLegendChanged(e);
            }
        };
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMapControl(), "Center");
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setProjection(IProjection projection) {
        MapContext mapContext = this.mapControl.getMapContext();
        mapContext.setProjection(projection);
    }

    public void setLayer(FLayer layer) {
        this.layer = layer;
        MapControl mapControl = this.getMapControl();
        MapContext mapContext = mapControl.getMapContext();
        FLayers layers = mapContext.getLayers();
        while (layers.size() > 0) {
            layers.remove(0);
        }
        if (layer != null) {
            DisposeUtils.bind((Disposable)layer);
            if (mapContext.getProjection() == null) {
                this.setProjection(layer.getProjection());
            }
            layers.add(layer);
            ((FLyrDefault)this.layer).addLegendListener(this.legendListener);
            try {
                mapControl.getViewPort().setEnvelope(layer.getFullEnvelope());
            }
            catch (ReadException e) {
                LOG.warn("Can't get the full envelope of the layer.", (Throwable)e);
            }
        }
    }

    protected MapControl getMapControl() {
        if (this.mapControl == null) {
            try {
                MapContext mapContext = MapContextLocator.getMapContextManager().createMapContext();
                this.mapControl = MapControlLocator.getMapControlManager().createJMapControlPanel(mapContext);
                PanListenerImpl panListener = new PanListenerImpl(this.mapControl);
                this.mapControl.addBehavior("pan", (Behavior)new MoveBehavior((PanListener)panListener, 1));
                ZoomOutListenerImpl zoomOutListener = new ZoomOutListenerImpl(this.mapControl);
                this.mapControl.addBehavior("zoomOut", (Behavior)new PointBehavior((PointListener)zoomOutListener));
                ZoomInListenerImpl zoomInListener = new ZoomInListenerImpl(this.mapControl);
                this.mapControl.addBehavior("zoomIn", new Behavior[]{new RectangleBehavior((RectangleListener)zoomInListener), new PointBehavior((PointListener)zoomOutListener, 4)});
                this.mapControl.setTool("zoomIn");
                this.mapControl.addCombinedBehavior((Behavior)new MouseWheelBehavior());
                this.mapControl.addCombinedBehavior((Behavior)new MoveBehavior((PanListener)panListener, 2));
            }
            catch (MapControlCreationException | LocatorException e) {
                LOG.warn("Can't create mapControl to preview.", e);
            }
        }
        return this.mapControl;
    }

    private void doLegendChanged(LegendChangedEvent e) {
        MapContext mapContext = this.mapControl.getMapContext();
        mapContext.invalidate();
        this.mapControl.paintImmediately(new Rectangle(this.mapControl.getSize()));
    }

    public FLayer getLayer() {
        return this.layer;
    }

    public void dispose() {
        if (this.mapControl == null) {
            return;
        }
        MapContext mapContext = this.mapControl.getMapContext();
        FLayers layers = mapContext.getLayers();
        while (layers.size() > 0) {
            ((FLyrDefault)layers.get(0)).removeLegendListener(this.legendListener);
            layers.remove(0);
        }
        DisposeUtils.dispose((Disposable)this.layer);
        this.layer = null;
        DisposeUtils.dispose((Disposable)mapContext);
        mapContext = null;
        this.mapControl.dispose();
    }
}

