/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.legend.impl.colortable.selector;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.api.colortable.ColorTable;
import org.gvsig.raster.lib.legend.api.colortable.ColorTableIO;
import org.gvsig.raster.lib.legend.api.colortable.ColorTableIOFactory;
import org.gvsig.raster.lib.legend.api.colortable.MakeColorTable;
import org.gvsig.raster.lib.legend.api.exceptions.ColorTableIOException;
import org.gvsig.raster.swing.legend.RasterSwingLegendLocator;
import org.gvsig.raster.swing.legend.RasterSwingLegendManager;
import org.gvsig.raster.swing.legend.colortable.create.CreateColorTablePanel;
import org.gvsig.raster.swing.legend.colortable.editor.ColorTableEditorPanel;
import org.gvsig.raster.swing.legend.colortable.selector.ColorTableSelectorPanel;
import org.gvsig.raster.swing.legend.colortable.selector.ColorTablesTableModel;
import org.gvsig.raster.swing.legend.impl.colortable.editor.ColorTableEditorPanelController;
import org.gvsig.raster.swing.legend.impl.colortable.selector.ColorTableSelectorPanelView;
import org.gvsig.raster.swing.legend.impl.colortable.selector.DefaultColorTablesTableModel;
import org.gvsig.raster.swing.legend.impl.colortable.selector.PreviewerColorTableCellRenderer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorTableSelectorPanelController
extends ColorTableSelectorPanelView
implements ColorTableSelectorPanel {
    private static final long serialVersionUID = -2427828721121167549L;
    private static final Logger LOG = LoggerFactory.getLogger(ColorTableSelectorPanelController.class);
    private List<Pair<File, ColorTable>> colorTables;
    private List<ColorTable> addedColorTables;
    private List<Pair<File, ColorTable>> modifiedColorTables;
    private List<Pair<File, ColorTable>> removedColorTables;
    private boolean editable;

    public ColorTableSelectorPanelController() {
        this.translate();
        this.editable = true;
        this.initializeComponents();
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initializeComponents() {
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        this.btnNew.setIcon(iconTheme.get("new-color-table-icon"));
        this.btnEdit.setIcon(iconTheme.get("edit-color-table-icon"));
        this.btnExport.setIcon(iconTheme.get("export-color-table-icon"));
        this.btnImport.setIcon(iconTheme.get("import-color-table-icon"));
        this.btnRemove.setIcon(iconTheme.get("remove-color-table-icon"));
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableSelectorPanelController.this.doNewColorTable();
            }
        });
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableSelectorPanelController.this.doEditColorTable();
            }
        });
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableSelectorPanelController.this.doExportColorTable();
            }
        });
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableSelectorPanelController.this.doImportColorTable();
            }
        });
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableSelectorPanelController.this.doRemoveColorTable();
            }
        });
        this.tblColorTables.setRowSelectionAllowed(true);
        this.tblColorTables.setColumnSelectionAllowed(false);
        this.tblColorTables.setSelectionMode(0);
        this.tblColorTables.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ColorTableSelectorPanelController.this.updateComponents();
            }
        });
        this.updateComponents();
    }

    protected void doEditColorTable() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        int index = this.tblColorTables.getSelectedRow();
        ColorTable sourceColorTable = (ColorTable)((ColorTablesTableModel)this.tblColorTables.getModel()).getColorTable(index).getValue();
        ColorTable colorTable = RasterLegendLocator.getRasterLegendManager().createColorTable();
        colorTable.copyFrom(colorTable);
        final ColorTableEditorPanelController panel = new ColorTableEditorPanelController();
        panel.set(colorTable);
        panel.asJComponent().setPreferredSize(new Dimension(600, 400));
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        final Dialog dialog = winManager.createDialog(panel.asJComponent(), i18nManager.getTranslation("color-table-edit"), null, 7);
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (dialog.getAction()) {
                    case 4: {
                        ColorTableSelectorPanelController.this.doApplyEditColorTable(panel);
                        break;
                    }
                    case 1: {
                        if (!ColorTableSelectorPanelController.this.doApplyEditColorTable(panel)) break;
                        panel.asJComponent().setVisible(false);
                        break;
                    }
                    case 2: {
                        panel.asJComponent().setVisible(false);
                    }
                }
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    protected boolean doApplyEditColorTable(ColorTableEditorPanel panel) {
        int selectedRow = this.tblColorTables.getSelectedRow();
        ColorTable colorTableEdited = panel.getColorTable();
        if (panel.isModified()) {
            ColorTablesTableModel colorTablesTableModel = (ColorTablesTableModel)this.tblColorTables.getModel();
            colorTablesTableModel.setColorTable(selectedRow, colorTableEdited);
            if (!this.modifiedColorTables.contains(colorTablesTableModel.getColorTable(selectedRow))) {
                this.modifiedColorTables.add((Pair<File, ColorTable>)colorTablesTableModel.getColorTable(selectedRow));
            }
            this.tblColorTables.setRowSelectionInterval(selectedRow, selectedRow);
        }
        return true;
    }

    protected void doRemoveColorTable() {
        int row = this.tblColorTables.getSelectedRow();
        ColorTablesTableModel colorTablesTableModel = (ColorTablesTableModel)this.tblColorTables.getModel();
        Pair pair = colorTablesTableModel.getColorTable(row);
        this.removedColorTables.add((Pair<File, ColorTable>)pair);
        colorTablesTableModel.removeColorTable(this.tblColorTables.getSelectedRow());
    }

    protected void doImportColorTable() {
        RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
        JFileChooser fileChooser = new JFileChooser();
        List factories = legendManager.getColorTableIOFactories();
        for (ColorTableIOFactory colorTableIOFactory : factories) {
            fileChooser.addChoosableFileFilter(new MyFileFilter(colorTableIOFactory));
        }
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            File[] files;
            for (File file : files = fileChooser.getSelectedFiles()) {
                for (ColorTableIOFactory colorTableIOFactory : factories) {
                    ColorTable colorTable;
                    if (!colorTableIOFactory.accept(file)) continue;
                    ColorTableIO colorTableIO = colorTableIOFactory.create();
                    try {
                        colorTable = colorTableIO.read(file);
                    }
                    catch (ColorTableIOException e) {
                        LOG.warn("Can't read color table '" + file.getName() + "'.", (Throwable)e);
                        throw new RuntimeException("Can't read color table '" + file.getName() + "'.", e);
                    }
                    this.addedColorTables.add(colorTable);
                    ((ColorTablesTableModel)this.tblColorTables.getModel()).addColorTable((Pair)new MutablePair(null, (Object)colorTable));
                }
            }
        }
    }

    protected void doExportColorTable() {
        ColorTable colorTable = (ColorTable)((ColorTablesTableModel)this.tblColorTables.getModel()).getColorTable(this.tblColorTables.getSelectedRow()).getValue();
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
        JFileChooser fileChooser = new JFileChooser();
        List factories = legendManager.getColorTableIOFactories();
        for (ColorTableIOFactory colorTableIOFactory : factories) {
            fileChooser.addChoosableFileFilter(new MyFileFilter(colorTableIOFactory));
        }
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int result = fileChooser.showSaveDialog(this);
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            MyFileFilter fileFilter = (MyFileFilter)fileChooser.getFileFilter();
            File parent = file.getParentFile();
            String filename = file.getName();
            ColorTableIOFactory colorTableIOFactory = fileFilter.getColorTableIOFactory();
            if (FilenameUtils.getExtension((String)filename).isEmpty()) {
                file = new File(parent, filename + "." + colorTableIOFactory.getDefaultExtension());
            }
            try {
                colorTableIOFactory.create().write(colorTable, file);
            }
            catch (ColorTableIOException e) {
                LOG.warn("Can't write color table '" + file.getName() + "'.", (Throwable)e);
                throw new RuntimeException("Can't write color table '" + file.getName() + "'.", e);
            }
        }
    }

    protected void doNewColorTable() {
        RasterSwingLegendManager rasterSwingLegendManager = RasterSwingLegendLocator.getSwingManager();
        final CreateColorTablePanel panel = rasterSwingLegendManager.createCreateColorTablePanel();
        panel.setFromColor(new Color(0, 0, 0, 255));
        panel.setToColor(new Color(255, 255, 255, 255));
        panel.setMinimum(0.0);
        panel.setMaximum(255.0);
        panel.setIntervals(1);
        panel.setMode(1);
        panel.setName("");
        panel.asJComponent().setPreferredSize(new Dimension(400, 300));
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        final Dialog dialog = winManager.createDialog(panel.asJComponent(), i18nManager.getTranslation("color-tables-library"), null, 3);
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (dialog.getAction()) {
                    case 1: {
                        if (!ColorTableSelectorPanelController.this.doMakeColorTable(panel)) break;
                        panel.asJComponent().setVisible(false);
                        break;
                    }
                    case 2: {
                        panel.asJComponent().setVisible(false);
                    }
                }
            }
        });
        dialog.show(WindowManager.MODE.WINDOW);
    }

    protected boolean doMakeColorTable(CreateColorTablePanel panel) {
        MakeColorTable makeColorTable = RasterLegendLocator.getRasterLegendManager().createMakeColorTable();
        panel.fetch(makeColorTable);
        ColorTable colorTable = makeColorTable.getColorTable();
        ((ColorTablesTableModel)this.tblColorTables.getModel()).addColorTable((Pair)new MutablePair(null, (Object)colorTable));
        this.addedColorTables.add(colorTable);
        return true;
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.btnNew.setToolTipText(i18nManager.getTranslation(this.btnNew.getToolTipText()));
        this.btnImport.setToolTipText(i18nManager.getTranslation(this.btnImport.getToolTipText()));
        this.btnExport.setToolTipText(i18nManager.getTranslation(this.btnExport.getToolTipText()));
        this.btnRemove.setToolTipText(i18nManager.getTranslation(this.btnRemove.getToolTipText()));
    }

    public void setLocate(Locale locale) {
        Locale l = super.getLocale();
        if (!l.equals(locale)) {
            this.translate();
        }
        super.setLocale(locale);
    }

    public ColorTable getSelected() {
        int row = this.tblColorTables.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return (ColorTable)((ColorTablesTableModel)this.tblColorTables.getModel()).getValueAt(row, 0);
    }

    public void set(List<Pair<File, ColorTable>> colorTables) {
        this.colorTables = colorTables != null ? colorTables : new ArrayList<Pair<File, ColorTable>>();
        this.modifiedColorTables = new ArrayList<Pair<File, ColorTable>>();
        this.addedColorTables = new ArrayList<ColorTable>();
        this.removedColorTables = new ArrayList<Pair<File, ColorTable>>();
        this.init();
    }

    private void init() {
        DefaultColorTablesTableModel tableModel = new DefaultColorTablesTableModel(this.colorTables);
        this.tblColorTables.setModel(tableModel);
        this.tblColorTables.setColumnModel(new DefaultTableColumnModel());
        TableColumnModel columnModel = this.tblColorTables.getColumnModel();
        columnModel.setColumnSelectionAllowed(false);
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            TableColumn tableColumn = new TableColumn(i);
            tableColumn.setIdentifier(tableModel.getColumnName(i));
            tableColumn.setHeaderValue(tableModel.getColumnName(i));
            if (i == 0) {
                tableColumn.setCellRenderer(new PreviewerColorTableCellRenderer());
            }
            columnModel.addColumn(tableColumn);
        }
    }

    private void updateComponents() {
        boolean selected = this.tblColorTables.getSelectedRowCount() >= 1;
        this.btnExport.setEnabled(selected);
        this.btnRemove.setEnabled(selected && this.editable);
        this.btnEdit.setEnabled(selected && this.editable);
        this.btnEdit.setVisible(this.editable);
        this.btnImport.setVisible(this.editable);
        this.btnNew.setVisible(this.editable);
        this.btnRemove.setVisible(this.editable);
        this.btnExport.setVisible(this.editable);
    }

    public List<Pair<File, ColorTable>> getModifiedColorTables() {
        return this.modifiedColorTables;
    }

    public List<Pair<File, ColorTable>> getRemovedColorTables() {
        return this.removedColorTables;
    }

    public List<ColorTable> getAddedColorTables() {
        return this.addedColorTables;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.updateComponents();
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.tblColorTables.getSelectionModel().addListSelectionListener(listener);
    }

    public void select(int i) {
        this.tblColorTables.getSelectionModel().setValueIsAdjusting(true);
        this.tblColorTables.getSelectionModel().setSelectionInterval(i, i);
        this.tblColorTables.getSelectionModel().setValueIsAdjusting(false);
    }

    private static class MyFileFilter
    extends FileFilter {
        private ColorTableIOFactory factory;

        public MyFileFilter(ColorTableIOFactory factory) {
            this.factory = factory;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return this.getColorTableIOFactory().accept(f);
        }

        @Override
        public String getDescription() {
            return this.getColorTableIOFactory().getName();
        }

        public ColorTableIOFactory getColorTableIOFactory() {
            return this.factory;
        }
    }
}

