/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl;

import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

public class ExtendedFileFilter
extends FileFilter {
    String description = null;
    ArrayList<String> extensions = new ArrayList();

    public ExtendedFileFilter() {
    }

    public ExtendedFileFilter(String extension) {
        this.addExtension(extension);
    }

    public void addExtension(String extension) {
        if (extension == null) {
            return;
        }
        this.extensions.add(extension);
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            String extension = s.substring(i + 1).toLowerCase();
            for (int j = 0; j < this.extensions.size(); ++j) {
                if (!this.extensions.get(j).toString().toLowerCase().equals(extension)) continue;
                return true;
            }
        }
        return false;
    }

    public String getNormalizedFilename(File file) {
        String s = file.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            String extension = s.substring(i + 1).toLowerCase();
            for (int j = 0; j < this.extensions.size(); ++j) {
                if (!this.extensions.get(j).toString().toLowerCase().equals(extension)) continue;
                return file.toString();
            }
        }
        return file.toString() + "." + this.extensions.get(0).toString().toLowerCase();
    }

    @Override
    public String getDescription() {
        String format1 = "";
        String format2 = "";
        for (int j = 0; j < this.extensions.size(); ++j) {
            if (format1.length() != 0) {
                format1 = format1 + ", ";
                format2 = format2 + "; ";
            }
            if (j >= 4) {
                format1 = "...";
                format2 = "...";
                break;
            }
            format1 = format1 + this.extensions.get(j).toString().toUpperCase();
            format2 = format2 + "*." + this.extensions.get(j).toString().toLowerCase();
        }
        if (this.description == null) {
            return "files " + format1 + " (" + format2 + ")";
        }
        return this.description + " (" + format2 + ")";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void removeExtension(String extension) {
        this.extensions.remove(extension);
    }

    public void clearExtensions() {
        this.extensions.clear();
    }

    public ArrayList<String> getExtensions() {
        return this.extensions;
    }
}

