/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.openfile;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import org.gvsig.raster.swing.impl.openfile.OpenFileContainerImpl;
import org.gvsig.raster.swing.impl.openfile.ReadFilter;

public class OpenFileListener
implements ActionListener {
    private JButton button = null;
    private String fName = null;
    private OpenFileContainerImpl controlPanel = null;
    private String[] fileFilter = null;
    private String lastDirectory = null;

    public OpenFileListener(OpenFileContainerImpl panel, String[] fileFilter, String lastDirectory) {
        this.controlPanel = panel;
        this.fileFilter = fileFilter;
        this.lastDirectory = lastDirectory;
    }

    public void setButton(JButton but) {
        this.button = but;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button) {
            JFileChooser file = new JFileChooser();
            file.setDialogTitle("Select File");
            if (this.lastDirectory != null) {
                File lastDir = new File(this.lastDirectory);
                if (lastDir.isDirectory() && lastDir.exists()) {
                    file.setCurrentDirectory(lastDir);
                }
                if (!lastDir.isDirectory() && (lastDir = new File(lastDir.getParent())).exists()) {
                    file.setCurrentDirectory(lastDir);
                }
            }
            if (this.fileFilter != null) {
                for (int i = 0; i < this.fileFilter.length; ++i) {
                    file.addChoosableFileFilter(new ReadFilter(file, this.fileFilter[i]));
                }
                int returnVal = file.showOpenDialog(this.controlPanel);
                if (returnVal == 0) {
                    this.lastDirectory = file.getSelectedFile().getAbsolutePath();
                    this.fName = file.getSelectedFile().toString();
                    this.controlPanel.getTOpen().setText(this.fName);
                }
            }
        }
    }

    public String getFileName() {
        return this.fName;
    }
}

