/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.preview;

import java.awt.Component;
import java.awt.Graphics2D;
import javax.swing.JOptionPane;
import org.gvsig.gui.beans.imagenavigator.IClientImageNavigator;
import org.gvsig.gui.beans.imagenavigator.ImageUnavailableException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.preview.DataSourcePreview;
import org.gvsig.raster.swing.preview.PreviewRenderProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewRequestManager
implements IClientImageNavigator {
    private static final Logger logger = LoggerFactory.getLogger(PreviewRequestManager.class);
    private DataSourcePreview previewLayer = null;
    private PreviewRenderProcess renderProcess = null;

    public PreviewRequestManager(PreviewRenderProcess renderProcess, DataSourcePreview layer) {
        this.renderProcess = renderProcess;
        this.setLayer(layer);
    }

    private void setLayer(DataSourcePreview fLayer) {
        this.previewLayer = fLayer.cloneDataSourcePreview();
    }

    public void closePreviewLayer() {
        this.previewLayer.closePreviewLayer();
    }

    public void drawImage(Graphics2D g, double x1, double y1, double x2, double y2, double zoom, int width, int height) throws ImageUnavailableException {
        if (this.previewLayer == null) {
            throw new ImageUnavailableException(Messages.getText((String)"error_dont_exists_layer"));
        }
        this.previewLayer.pushStatus();
        try {
            if (this.renderProcess != null) {
                this.renderProcess.process(this.previewLayer);
            }
        }
        catch (ImageUnavailableException e2) {
            throw new ImageUnavailableException(Messages.getText((String)"error_adding_filters"));
        }
        catch (Exception e2) {
            logger.debug("error_adding_filters", (Object)this, (Object)e2);
            throw new ImageUnavailableException(Messages.getText((String)"error_adding_filters"));
        }
        try {
            double[] coords = new double[]{x1, y1, x2, y2};
            this.previewLayer.draw(null, g, coords, width, height, null, 1.0);
        }
        catch (ImageUnavailableException e) {
            logger.debug("error_preview_render", (Object)this, (Object)e);
            throw new ImageUnavailableException(Messages.getText((String)"error_preview_render"));
        }
        catch (Exception e2) {
            logger.debug("error_preview_render", (Object)this, (Object)e2);
            throw new ImageUnavailableException(Messages.getText((String)"error_preview_render"));
        }
        this.previewLayer.popStatus();
    }

    public void messageBoxError(String msg, Object parentWindow, Exception exception) {
        logger.debug(msg, parentWindow, (Object)exception);
        String string = Messages.getText((String)"accept");
        Object[] options = new Object[]{string};
        JOptionPane.showOptionDialog((Component)parentWindow, "<html>" + Messages.getText((String)msg).replaceAll("\n", "<br>") + "</html>", Messages.getText((String)"confirmacion"), 0, 0, null, options, string);
    }
}

