/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.tool.infobypoint;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.gvsig.raster.swing.infobypoint.InfoByPointDataModel;

public class DefaultInfoByPointDataModel
extends Observable
implements InfoByPointDataModel {
    private static final int LONG_STRING = 26;
    public int bands = 0;
    public List<Double> bandsValues = new ArrayList<Double>();
    public Point2D pixelPoint = new Point2D.Double();
    public Point2D worldPoint = new Point2D.Double();
    public Point2D viewPoint = new Point2D.Double();
    public int[] rgb = new int[3];
    public double[] cmyk = new double[4];
    public double[] hsl = new double[3];
    public List<String> layers = null;
    public boolean projected = true;

    public DefaultInfoByPointDataModel() {
        this.setARGB(0, 0, 0);
        this.setCMYK(new double[]{0.0, 0.0, 0.0, 0.0});
        this.setHSL(0.0, 0.0, 0.0);
        this.setBandValues(new double[]{Double.NaN});
        this.setNumberOfBands(0);
        this.setPixelPoint(-1.0, -1.0);
        this.setViewPoint(Double.NaN, Double.NaN);
        this.setWorldPoint(Double.NaN, Double.NaN);
        ArrayList<String> list = new ArrayList<String>();
        list.add("...");
        this.setLayerList(list);
    }

    public void setProjected(boolean projected) {
        this.projected = projected;
    }

    public void setBandValues(double[] list) {
        this.bandsValues.clear();
        for (int i = 0; i < list.length; ++i) {
            this.bandsValues.add(list[i]);
        }
    }

    public void setNumberOfBands(int n) {
        this.bands = n;
    }

    public void setLayerList(List<String> list) {
        this.layers = list;
    }

    public void setARGB(int r, int g, int b) {
        this.rgb[0] = r;
        this.rgb[1] = g;
        this.rgb[2] = b;
    }

    public void setCMYK(double[] cmyk) {
        this.cmyk = cmyk;
    }

    public void setHSL(double h, double s, double l) {
        this.hsl[0] = h;
        this.hsl[1] = s;
        this.hsl[2] = l;
    }

    public void setPixelPoint(double x, double y) {
        this.pixelPoint.setLocation(x, y);
    }

    public void setWorldPoint(double x, double y) {
        this.worldPoint.setLocation(x, y);
    }

    public void setViewPoint(double x, double y) {
        this.viewPoint.setLocation(x, y);
    }

    public String getFormatedLayerName(int i) {
        if (26 < this.layers.get(i).length()) {
            return "..." + this.layers.get(i).substring(this.layers.get(i).length() - 26, this.layers.get(i).length());
        }
        return this.layers.get(i);
    }

    @Override
    public void notifyObservers() {
        this.setChanged();
        super.notifyObservers();
    }
}

