/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.tool.infobypoint;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gvsig.raster.swing.pixelinspector.PixelInspector;

public class PixelInspectorPanel
extends JPanel
implements MouseListener,
PixelInspector {
    private static final long serialVersionUID = -3370601314380922368L;
    private JPopupMenu menu = null;
    private int w = 0;
    private int h = 0;
    private int scale = 8;
    public BufferedImage img = null;
    private int posX = 0;
    private int posY = 0;
    public int pixX = 0;
    public int pixY = 0;
    int red = 0;
    int green = 0;
    int blue = 0;
    private boolean clear = false;
    private Color color = Color.red;
    private JCheckBoxMenuItem[] entry = new JCheckBoxMenuItem[6];
    private HashMap<String, String> tr = null;

    public PixelInspectorPanel(HashMap<String, String> translations) {
        this.tr = translations;
        if (this.tr == null || this.tr.get("layer_list") == null) {
            this.tr = new HashMap();
            this.tr.put("green", "green");
            this.tr.put("red", "red");
            this.tr.put("blue", "blue");
        }
        this.addMouseListener(this);
        this.initMenu();
    }

    public void setViewCoordinates(int pixX, int pixY) {
        this.pixX = pixX;
        this.pixY = pixY;
    }

    public void setClear(boolean clear) {
        this.clear = clear;
    }

    private void initMenu() {
        this.menu = new JPopupMenu();
        PopupMenuListener lis = new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                PixelInspectorPanel.this.clear = true;
                PixelInspectorPanel.this.repaint();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        };
        this.menu.addPopupMenuListener(lis);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int i;
                String txt = ((JMenuItem)evt.getSource()).getText();
                if (txt.compareTo("X4") == 0) {
                    PixelInspectorPanel.this.scale = 4;
                    for (i = 1; i <= 3; ++i) {
                        PixelInspectorPanel.this.entry[i].setSelected(false);
                    }
                    PixelInspectorPanel.this.entry[0].setSelected(true);
                }
                if (txt.compareTo("X8") == 0) {
                    PixelInspectorPanel.this.scale = 8;
                    PixelInspectorPanel.this.entry[0].setSelected(false);
                    PixelInspectorPanel.this.entry[1].setSelected(true);
                    PixelInspectorPanel.this.entry[2].setSelected(false);
                    PixelInspectorPanel.this.entry[3].setSelected(false);
                }
                if (txt.compareTo("X16") == 0) {
                    PixelInspectorPanel.this.scale = 16;
                    PixelInspectorPanel.this.entry[0].setSelected(false);
                    PixelInspectorPanel.this.entry[1].setSelected(false);
                    PixelInspectorPanel.this.entry[2].setSelected(true);
                    PixelInspectorPanel.this.entry[3].setSelected(false);
                }
                if (txt.compareTo("X32") == 0) {
                    PixelInspectorPanel.this.scale = 32;
                    for (i = 0; i < 3; ++i) {
                        PixelInspectorPanel.this.entry[i].setSelected(false);
                    }
                    PixelInspectorPanel.this.entry[3].setSelected(true);
                }
                if (txt.compareTo((String)PixelInspectorPanel.this.tr.get("green")) == 0) {
                    PixelInspectorPanel.this.color = Color.GREEN;
                    PixelInspectorPanel.this.entry[4].setSelected(false);
                    PixelInspectorPanel.this.entry[5].setSelected(true);
                }
                if (txt.compareTo((String)PixelInspectorPanel.this.tr.get("red")) == 0) {
                    PixelInspectorPanel.this.color = Color.RED;
                    PixelInspectorPanel.this.entry[4].setSelected(true);
                    PixelInspectorPanel.this.entry[5].setSelected(false);
                }
            }
        };
        this.entry[0] = new JCheckBoxMenuItem("X4");
        this.entry[0].addActionListener(al);
        this.menu.add(this.entry[0]);
        this.entry[1] = new JCheckBoxMenuItem("X8");
        this.entry[1].setSelected(true);
        this.entry[1].addActionListener(al);
        this.menu.add(this.entry[1]);
        this.entry[2] = new JCheckBoxMenuItem("X16");
        this.entry[2].addActionListener(al);
        this.menu.add(this.entry[2]);
        this.entry[3] = new JCheckBoxMenuItem("X32");
        this.entry[3].addActionListener(al);
        this.menu.add(this.entry[3]);
        this.entry[4] = new JCheckBoxMenuItem(this.tr.get("red"));
        this.entry[4].addActionListener(al);
        this.entry[4].setSelected(true);
        this.menu.add(this.entry[4]);
        this.entry[5] = new JCheckBoxMenuItem(this.tr.get("green"));
        this.entry[5].addActionListener(al);
        this.menu.add(this.entry[5]);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.w = this.getVisibleRect().width;
        this.h = this.getVisibleRect().height;
        if (this.clear) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.w, this.h);
            return;
        }
        if (this.img != null) {
            int sizeCrux = 10;
            int value = 0;
            try {
                value = this.img.getRGB(this.pixX, this.pixY);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            this.red = (value & 0xFF0000) >> 16;
            this.green = (value & 0xFF00) >> 8;
            this.blue = value & 0xFF;
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.w, this.h);
            ((Graphics2D)g).scale(this.scale, this.scale);
            g.drawImage(this.img, this.posX, this.posY, this);
            ((Graphics2D)g).setTransform(new AffineTransform());
            g.setXORMode(Color.WHITE);
            g.setColor(this.color);
            int middleW = this.w >> 1;
            int middleH = this.h >> 1;
            g.drawLine(middleW - sizeCrux, middleH, middleW + sizeCrux, middleH);
            g.drawLine(middleW, middleH - sizeCrux, middleW, middleH + sizeCrux);
        }
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public int getScale() {
        return this.scale;
    }

    public BufferedImage getDataBuffer() {
        return this.img;
    }

    public void setDataBuffer(BufferedImage img) {
        this.img = img;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.clear = true;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.clear = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.clear = true;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.menu.show(e.getComponent(), e.getX(), e.getY());
            this.clear = true;
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

