/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import javax.json.JsonObject;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.impl.DefaultOptimizer;
import org.gvsig.expressionevaluator.impl.symboltable.FeatureSymbolTableImpl;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.AbstractFeatureRule;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureRuleExpression;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.exception.ValidateFeaturesException;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultFeatureRuleExpression
extends AbstractFeatureRule
implements FeatureRuleExpression {
    private static final String FEATURERULEEXPRESSION_PERSISTENCE_DEFINITION_NAME = "FeatureRuleExpression";
    private Expression expression;
    private FeatureSymbolTable featureSymbolTable;
    private Interpreter interpreter;
    private ExpressionEvaluatorManager manager;

    public DefaultFeatureRuleExpression() {
        super(null, null, false, false);
    }

    public DefaultFeatureRuleExpression(String name, String description, boolean checkAtUpdate, boolean checkAtFinishEdition, Expression expression) {
        super(name, description, checkAtUpdate, checkAtFinishEdition);
        this.expression = expression;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void validate(EditableFeature feature, FeatureStore featureStore) throws DataException {
        Object value = this.execute(feature);
        boolean ok = false;
        if (value != null) {
            ok = value instanceof Boolean ? (Boolean)value : DataTypeUtils.toBoolean((Object)value, (boolean)false);
        }
        if (ok) {
            return;
        }
        throw new ValidateFeaturesException(featureStore.getName(), null);
    }

    public Object execute(EditableFeature feature) {
        if (this.interpreter == null) {
            this.manager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
            this.interpreter = this.manager.createInterpreter();
            this.featureSymbolTable = new FeatureSymbolTableImpl();
            this.featureSymbolTable.addSymbolTable((SymbolTable)this.manager.createSymbolTable());
            this.interpreter.setSymbolTable((SymbolTable)this.featureSymbolTable);
            DefaultOptimizer optimizer = new DefaultOptimizer(this.manager, (SymbolTable)this.featureSymbolTable);
            Code code = optimizer.optimize(this.expression.getCode());
            this.interpreter.link(code);
        }
        this.featureSymbolTable.setFeature((Feature)feature);
        Code code_exp = this.expression.getCode();
        if (this.manager.hasHostExpressions(code_exp)) {
            code_exp = this.manager.resolveHostExpressions(code_exp, this.interpreter);
        }
        Object x = this.interpreter.run(code_exp);
        return x;
    }

    public static void selfRegister() {
        Json.registerSerializer(DefaultFeatureRuleExpression.class);
        DefaultFeatureRuleExpression.registerPersistenceDefinition();
    }

    private static void registerPersistenceDefinition() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(FEATURERULEEXPRESSION_PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(DefaultFeatureRuleExpression.class, FEATURERULEEXPRESSION_PERSISTENCE_DEFINITION_NAME, "FeatureRuleExpression persistent definition", null, null);
            definition.addDynFieldString("name");
            definition.addDynFieldString("description");
            definition.addDynFieldBoolean("checkAtFinishEdition");
            definition.addDynFieldBoolean("checkAtUpdate");
            definition.addDynFieldObject("expression").setClassOfValue(Expression.class);
            definition.addDynFieldInt("checkWhen").setMandatory(false);
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.name = state.getString("name");
        this.description = state.getString("description");
        this.checkwhen.set(state.getInt("checkWhen", 0));
        if (state.getBoolean("checkAtFinishEdition")) {
            this.checkwhen.setBits(1);
        }
        if (state.getBoolean("checkAtUpdate")) {
            this.checkwhen.setBits(2);
        }
        this.expression = (Expression)state.get("expression");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("name", this.name);
        state.set("description", this.description);
        state.set("checkWhen", this.checkwhen.get());
        state.set("checkAtFinishEdition", this.checkwhen.isSetBits(1));
        state.set("checkAtUpdate", this.checkwhen.isSetBits(2));
        state.set("expression", (Persistent)this.expression);
    }

    public void setCheckAtUpdate(boolean checkAtUpdate) {
        if (checkAtUpdate) {
            this.checkwhen.setBits(2);
        } else {
            this.checkwhen.clearBits(2);
        }
    }

    public void setCheckAtFinishEditing(boolean checkAtFinishEditing) {
        if (checkAtFinishEditing) {
            this.checkwhen.setBits(1);
        } else {
            this.checkwhen.clearBits(1);
        }
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public JsonObject toJson() {
        JsonObjectBuilder builder = this.toJsonBuilder();
        return builder.build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class((Object)this);
        builder.add("name", this.name);
        builder.add("description", this.description);
        builder.add("checkWhen", this.checkwhen.get());
        builder.add("checkAtFinishEdition", this.checkwhen.isSetBits(1));
        builder.add("checkAtUpdate", this.checkwhen.isSetBits(2));
        builder.add("expression", this.expression.getPhrase());
        return builder;
    }

    public void fromJson(JsonObject json) {
        this.name = json.getString("name");
        this.description = json.getString("description");
        this.checkwhen.set(json.getInt("checkWhen", 0));
        if (json.getBoolean("checkAtFinishEdition", false)) {
            this.checkwhen.setBits(1);
        }
        if (json.getBoolean("checkAtUpdate", false)) {
            this.checkwhen.setBits(2);
        }
        this.expression = ExpressionUtils.createExpression((String)json.getString("expression", null));
    }

    public void setCheckWhen(int mask) {
        super.setCheckWhen(mask);
    }
}

