/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.dataaccess;

import javax.json.JsonObject;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.I18N;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.expressionevaluator.spi.JsonUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;

public abstract class AbstractFeatureFunction
extends AbstractFunction {
    protected AbstractFeatureFunction(String group, String name, Range argc, String description, String template, String[] descriptionArgs, String returnType, boolean sqlCompatible) {
        super(group, name, argc, description, template, descriptionArgs, returnType, sqlCompatible);
    }

    protected AbstractFeatureFunction(String group, String name, Range argc, String description, String template, String[] descriptionArgs, String returnType) {
        super(group, name, argc, description, template, descriptionArgs, returnType);
    }

    public Feature current_row(Interpreter interpreter) {
        try {
            Feature f = (Feature)interpreter.call("CURRENT_ROW", new Object[0]);
            return f;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public FeatureStore current_store(Interpreter interpreter) {
        try {
            FeatureStore store = (FeatureStore)interpreter.call("CURRENT_STORE", new Object[0]);
            return store;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected NewFeatureStoreParameters getNewFeatureStoreParameters(Object[] args, int n) {
        NewFeatureStoreParameters parameters;
        Object v = this.getObject(args, n);
        if (v instanceof NewFeatureStoreParameters) {
            return (NewFeatureStoreParameters)v;
        }
        JsonObject jsonObj = this.getJsonObject(args, n);
        try {
            String providerName = jsonObj.getString("ProviderName");
            DataManager dataManager = DALLocator.getDataManager();
            parameters = (NewFeatureStoreParameters)dataManager.createNewStoreParameters(providerName);
            for (String paramName : jsonObj.keySet()) {
                if (StringUtils.equalsIgnoreCase((CharSequence)paramName, (CharSequence)"ProviderName")) continue;
                parameters.setDynValue(paramName, JsonUtils.getitem((JsonObject)jsonObj, (String)paramName));
            }
        }
        catch (Exception ex) {
            String type = v.getClass().getCanonicalName();
            throw new IllegalArgumentException(I18N.The_type_of_the_argument_XargnX_for_the_XIdentifierX_function_is_incorrect((String)this.name(), (int)n) + " " + I18N.Expected_XexpectedX_and_found_XfoundX((String)"NewFeatureStoreParameters", (String)type));
        }
        return parameters;
    }

    protected FeatureType getFeatureType(Object[] args, int n) {
        EditableFeatureType featureType;
        Object v = this.getObject(args, n);
        if (v instanceof FeatureType) {
            return (FeatureType)v;
        }
        JsonObject jsonObj = this.getJsonObject(args, n);
        try {
            DataManager dataManager = DALLocator.getDataManager();
            featureType = dataManager.createFeatureType(jsonObj);
        }
        catch (Exception ex) {
            String type = v.getClass().getCanonicalName();
            throw new IllegalArgumentException(I18N.The_type_of_the_argument_XargnX_for_the_XIdentifierX_function_is_incorrect((String)this.name(), (int)n) + " " + I18N.Expected_XexpectedX_and_found_XfoundX((String)"NewFeatureStoreParameters", (String)type));
        }
        return featureType;
    }
}

