/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreNotification;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureIndex;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.FeatureIndexException;
import org.gvsig.fmap.dal.feature.exception.FeatureIndexOperationException;
import org.gvsig.fmap.dal.feature.exception.InvalidFeatureIndexException;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStoreNotification;
import org.gvsig.fmap.dal.feature.impl.IndexFeatureSet;
import org.gvsig.fmap.dal.feature.spi.DefaultLongList;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.feature.spi.LongList;
import org.gvsig.fmap.dal.feature.spi.index.FeatureIndexProvider;
import org.gvsig.fmap.dal.feature.spi.index.FeatureIndexProviderServices;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.WeakReferencingObservable;
import org.gvsig.tools.observer.impl.DelegateWeakReferencingObservable;
import org.gvsig.tools.task.AbstractMonitorableTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureIndex
extends AbstractDisposable
implements FeatureIndexProviderServices,
WeakReferencingObservable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFeatureIndex.class);
    private final FeatureStoreProviderServices featureStore;
    private final FeatureType featureType;
    private final String attributeName;
    private final String indexName;
    private final int dataType;
    private final FeatureIndexProvider indexProvider;
    private List attributeNames;
    private Object featureOperationTaskLock = new Object();
    private FeatureIndexOperationTask featureIndexTask;
    private boolean valid = true;
    private DelegateWeakReferencingObservable observable = new DelegateWeakReferencingObservable((WeakReferencingObservable)this);

    public DefaultFeatureIndex(FeatureStoreProviderServices featureStore, FeatureType featureType, FeatureIndexProvider indexProvider, String attributeName, String indexName) {
        if (featureStore == null) {
            throw new IllegalArgumentException("featureStore cannot be null.");
        }
        if (featureType == null) {
            throw new IllegalArgumentException("featureType cannot be null.");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName cannot be null.");
        }
        if (indexName == null) {
            throw new IllegalArgumentException("indexName cannot be null.");
        }
        if (featureStore.getProvider().getOIDType() != 4 && featureStore.getProvider().getOIDType() != 5) {
            throw new IllegalArgumentException();
        }
        FeatureAttributeDescriptor attr = featureType.getAttributeDescriptor(attributeName);
        if (attr == null) {
            throw new IllegalArgumentException("Attribute " + attributeName + " not found in FeatureType " + featureType.toString());
        }
        this.featureStore = featureStore;
        this.featureType = featureType;
        this.attributeName = attributeName;
        this.indexName = indexName;
        this.dataType = attr.getType();
        this.indexProvider = indexProvider;
        this.attributeNames = new ArrayList();
        this.attributeNames.add(attributeName);
        this.indexProvider.setFeatureIndexProviderServices((FeatureIndexProviderServices)this);
    }

    public final FeatureAttributeDescriptor getFeatureAttributeDescriptor() {
        return this.featureType.getAttributeDescriptor(this.attributeName);
    }

    public final FeatureStoreProviderServices getFeatureStoreProviderServices() {
        return this.featureStore;
    }

    public final FeatureType getFeatureType() {
        return this.featureType;
    }

    public final String getAttributeName() {
        return this.attributeName;
    }

    public final int getDataType() {
        return this.dataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureIndexOperationTask createIndexTask(int operation, FeatureSet data, Observer observer) {
        Object object = this.featureOperationTaskLock;
        synchronized (object) {
            FeatureIndexOperationTask fillingTask;
            if (this.featureIndexTask != null) {
                this.featureIndexTask.cancelRequest();
                this.removeTask(this.featureIndexTask);
            }
            this.featureIndexTask = fillingTask = new FeatureIndexOperationTask(this, this.featureStore.getFeatureStore(), operation, data, observer);
            return fillingTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTask(FeatureIndexOperationTask task) {
        Object object = this.featureOperationTaskLock;
        synchronized (object) {
            if (this.featureIndexTask == task) {
                this.featureIndexTask = null;
            }
        }
    }

    public void fill() throws FeatureIndexException {
        this.fill(false, null);
    }

    public void fill(boolean background, Observer observer) throws FeatureIndexException {
        FeatureIndexOperationTask task = this.createIndexTask(0, null, observer);
        if (background) {
            task.start();
        } else {
            task.run();
        }
    }

    public final void insert(FeatureSet data) throws DataException {
        if (!this.isValid()) {
            throw new InvalidFeatureIndexException();
        }
        FeatureIndexOperationTask task = this.createIndexTask(1, data, null);
        task.run();
    }

    public final synchronized void insert(Feature feat) throws DataException {
        try {
            FeatureIndexProvider prov = this.getIndexProvider();
            Object value = feat.get(this.getAttributeName());
            if (prov.allowNulls() || value != null) {
                prov.insert(value, (FeatureReferenceProviderServices)feat.getReference());
            }
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Could not add Feature: " + feat + " to index " + (Object)((Object)this) + ". It does not contain a column with name " + this.getAttributeName());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Could not add Feature: " + feat + " to index " + (Object)((Object)this) + ". Attribute " + this.getAttributeName() + " data type is not valid.");
        }
    }

    public final void delete(FeatureSet data) throws FeatureIndexException {
        if (!this.isValid()) {
            throw new InvalidFeatureIndexException();
        }
        FeatureIndexOperationTask task = this.createIndexTask(2, data, null);
        task.run();
    }

    public final synchronized void delete(Feature feat) throws DataException {
        this.getIndexProvider().delete(feat.get(this.getAttributeName()), (FeatureReferenceProviderServices)feat.getReference());
    }

    private synchronized void clear() throws DataException {
        this.getIndexProvider().clear();
    }

    public synchronized FeatureSet getMatchFeatureSet(Object value) throws FeatureIndexException {
        if (!this.isValid()) {
            throw new InvalidFeatureIndexException();
        }
        return new IndexFeatureSet(this, (LongList)new DefaultLongList(this.indexProvider.match(value)));
    }

    public synchronized FeatureSet getRangeFeatureSet(Object value1, Object value2) throws FeatureIndexException {
        if (!this.isValid()) {
            throw new InvalidFeatureIndexException();
        }
        return new IndexFeatureSet(this, (LongList)new DefaultLongList(this.indexProvider.range(value1, value2)));
    }

    public synchronized FeatureSet getNearestFeatureSet(int count, Object value) throws FeatureIndexException {
        if (!this.isValid()) {
            throw new InvalidFeatureIndexException();
        }
        return new IndexFeatureSet(this, (LongList)new DefaultLongList(this.indexProvider.nearest(count, value)));
    }

    public synchronized FeatureSet getNearestFeatureSet(int count, Object value, Object tolerance) throws FeatureIndexException {
        if (!this.isValid()) {
            throw new InvalidFeatureIndexException();
        }
        return new IndexFeatureSet(this, (LongList)new DefaultLongList(this.indexProvider.nearest(count, value, tolerance)));
    }

    public void initialize() throws InitializeException {
        this.indexProvider.setFeatureIndexProviderServices((FeatureIndexProviderServices)this);
        this.indexProvider.initialize();
    }

    public List getAttributeNames() {
        return this.attributeNames;
    }

    public String getNewFileName(String prefix, String sufix) {
        int n = 0;
        File file = new File(prefix + this.getName(), sufix);
        while (file.exists()) {
            file = new File(prefix + this.getName() + ++n, sufix);
        }
        return file.getAbsolutePath();
    }

    public String getFileName() {
        return null;
    }

    public String getTemporaryFileName() {
        return null;
    }

    public FeatureIndexProvider getFeatureIndexProvider() {
        return this.indexProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFilling() {
        Object object = this.featureOperationTaskLock;
        synchronized (object) {
            return this.featureIndexTask != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.featureOperationTaskLock;
        synchronized (object) {
            return !this.isFilling() && this.valid;
        }
    }

    public synchronized void waitForIndex() {
        LOG.debug("Wait finished for index: {}", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValid(boolean valid) {
        Object object = this.featureOperationTaskLock;
        synchronized (object) {
            this.valid = valid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispose() throws BaseException {
        Object object = this.featureOperationTaskLock;
        synchronized (object) {
            this.setValid(false);
            if (this.featureIndexTask != null) {
                this.featureIndexTask.cancelRequest();
                this.featureIndexTask = null;
            }
        }
        object = this;
        synchronized (object) {
            return;
        }
    }

    public String toString() {
        return "Feature index with name" + this.indexName + ", for the FeatureType: " + this.featureType + ", and the attribute: " + this.attributeName;
    }

    public void notifyObservers(Object notification) {
        this.observable.notifyObservers(notification);
    }

    public String getName() {
        return this.indexName;
    }

    private FeatureIndexProvider getIndexProvider() {
        return this.indexProvider;
    }

    public void addObserver(Observer observer) {
        this.observable.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.observable.deleteObserver(observer);
    }

    public void deleteObservers() {
        this.observable.deleteObservers();
    }

    private static class FeatureIndexOperationTask
    extends AbstractMonitorableTask {
        private final DefaultFeatureIndex index;
        public static final int OP_FILL = 0;
        public static final int OP_INSERT_FSET = 1;
        public static final int OP_DELETE_FSET = 2;
        private static final String[] OP_NAMES = new String[]{Messages.getText((String)"filling_index"), Messages.getText((String)"updating_index"), Messages.getText((String)"updating_index")};
        private final int operation;
        private final FeatureSet data;
        private final Observer operationObserver;
        private final FeatureStore store;

        protected FeatureIndexOperationTask(DefaultFeatureIndex index, FeatureStore store, int operation, FeatureSet data, Observer operationObserver) {
            super(OP_NAMES[operation]);
            this.index = index;
            this.store = store;
            this.operation = operation;
            this.data = data;
            this.operationObserver = operationObserver;
            this.setDaemon(true);
            this.setPriority(1);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                switch (this.operation) {
                    case 0: {
                        this.notify("Index_Filling_Started");
                        this.clearAndFill();
                        return;
                    }
                    case 1: {
                        this.notify("Index_Filling_Started");
                        this.insert(this.data);
                        return;
                    }
                    case 2: {
                        this.notify("Index_Filling_Started");
                        this.delete(this.data);
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                FeatureIndexOperationException fioex = new FeatureIndexOperationException((FeatureIndex)this.index, OP_NAMES[this.operation], (Throwable)e);
                this.notify("Index_Filling_Error", (Exception)fioex);
                throw new RuntimeException((Throwable)fioex);
            }
            finally {
                this.index.removeTask(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void clearAndFill() throws DataException {
            block11: {
                set = null;
                var2_2 = this.index;
                // MONITORENTER : var2_2
                set = this.store.getFeatureSet();
                if (this.isCancellationRequested()) {
                    this.cancel();
                    // MONITOREXIT : var2_2
                    DisposeUtils.dispose((Disposable)set);
                    return;
                }
                ** try [egrp 2[TRYBLOCK] [5 : 37->57)] { 
lbl-1000:
                // 1 sources

                {
                    DefaultFeatureIndex.access$100(this.index);
                    if (!this.isCancellationRequested()) break block11;
                    this.cancel();
                    // MONITOREXIT : var2_2
                }
                DisposeUtils.dispose((Disposable)set);
                return;
            }
            try {
                this.insert(set);
                this.index.setValid(true);
                // MONITOREXIT : var2_2
            }
lbl25:
            // 3 sources

            catch (IllegalStateException e) {
                this.cancel();
                return;
            }
            finally {
                DisposeUtils.dispose(set);
            }
            DisposeUtils.dispose((Disposable)set);
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void insert(FeatureSet data) throws DataException {
            DisposableIterator it = null;
            long counter = 0L;
            try {
                it = data.fastIterator();
                DefaultFeatureIndex defaultFeatureIndex = this.index;
                synchronized (defaultFeatureIndex) {
                    this.taskStatus.setRangeOfValues(0L, data.getSize());
                    this.taskStatus.add();
                    while (it.hasNext()) {
                        if (this.isCancellationRequested()) {
                            this.index.clear();
                            this.cancel();
                            return;
                        }
                        Feature feat = (Feature)it.next();
                        this.index.insert(feat);
                        this.taskStatus.setCurValue(counter++);
                    }
                    this.notify("Index_Filling_Success");
                }
                this.taskStatus.terminate();
                return;
            }
            catch (IllegalStateException e) {
                this.taskStatus.cancel();
                return;
            }
            catch (RuntimeException e) {
                this.taskStatus.abort();
                throw e;
            }
            catch (DataException e) {
                this.taskStatus.abort();
                throw e;
            }
            finally {
                DisposeUtils.dispose((Disposable)it);
                this.taskStatus.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void delete(FeatureSet data) throws FeatureIndexException {
            DisposableIterator it = null;
            try {
                it = data.fastIterator();
                DefaultFeatureIndex defaultFeatureIndex = this.index;
                synchronized (defaultFeatureIndex) {
                    while (it.hasNext()) {
                        if (this.isCancellationRequested()) {
                            this.cancel();
                            return;
                        }
                        Feature feat = (Feature)it.next();
                        this.index.delete(feat);
                    }
                    this.notify("Index_Filling_Success");
                    return;
                }
            }
            catch (DataException e) {
                throw new FeatureIndexException((Exception)((Object)e));
            }
            finally {
                DisposeUtils.dispose((Disposable)it);
            }
        }

        private void cancel() {
            this.notify("Index_Filling_Cancelled");
            this.taskStatus.cancel();
        }

        public void notifyOperationObserver(DataStoreNotification notification) {
            if (this.operationObserver != null) {
                this.operationObserver.update((Observable)this.index, (Object)notification);
            }
        }

        private void notify(String notificationType) {
            DefaultFeatureStoreNotification notification = new DefaultFeatureStoreNotification((DataStore)this.store, notificationType, (FeatureIndex)this.index);
            this.notifyOperationObserver((DataStoreNotification)notification);
            this.index.notifyObservers((Object)notification);
        }

        private void notify(String notificationType, Exception exception) {
            DefaultFeatureStoreNotification notification = new DefaultFeatureStoreNotification((DataStore)this.store, notificationType, exception);
            this.notifyOperationObserver((DataStoreNotification)notification);
            this.index.notifyObservers((Object)notification);
        }
    }
}

