/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.AbstractList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataStoreProvider;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.memory.AbstractMemoryStoreProvider;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.memory.MemoryStoreParameters;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.timesupport.Time;

public class FeatureTypeToStoreProviderAdapter
extends AbstractMemoryStoreProvider {
    private static final String NAME = "FeatureType";
    private static final int ATTR_NAME = 0;
    private static final int ATTR_TYPE = 1;
    private static final int ATTR_TYPENAME = 2;
    private static final int ATTR_SIZE = 3;
    private static final int ATTR_PRECISION = 4;
    private static final int ATTR_LABEL = 5;
    private static final int ATTR_SHORTLABEL = 6;
    private static final int ATTR_DESCRIPTION = 7;
    private static final int ATTR_PROFILE = 8;
    private static final int ATTR_GROUP = 9;
    private static final int ATTR_ORDER = 10;
    private static final int ATTR_ISPK = 11;
    private static final int ATTR_ISFK = 12;
    private static final int ATTR_ISCLOSEDLIST = 13;
    private static final int ATTR_ISREADONLY = 14;
    private static final int ATTR_ISCOMPUTED = 15;
    private static final int ATTR_ISCAUTOMATIC = 16;
    private static final int ATTR_ISHIDDEN = 17;
    private static final int ATTR_ALLOWNULLS = 18;
    private static final int ATTR_EXPRESSION = 19;
    private static final int ATTR_FKTABLE = 20;
    private static final int ATTR_FKCODE = 21;
    private static final int ATTR_FKLABEL = 22;
    private static final int ATTR_SCALE = 23;
    private static Map<String, Integer> attrName2Index;
    private static FeatureType featureTypeOfFeatureType;
    private final FeatureType featureType;
    private final ResourceProvider resource;
    private final Double sourceID;

    private FeatureTypeToStoreProviderAdapter(DataStoreParameters parameters, DataStoreProviderServices storeServices, FeatureType featureType) throws InitializeException {
        super(parameters, storeServices);
        this.featureType = featureType;
        this.data = new Features(featureType);
        this.sourceID = Math.random();
        this.resource = this.createResource("memory", new Object[]{NAME});
        if (featureTypeOfFeatureType == null) {
            this.initFeatureType();
        }
        this.getStoreServices().setFeatureTypes(Collections.singletonList(featureTypeOfFeatureType), featureTypeOfFeatureType);
    }

    public static FeatureStore createFeatureStore(FeatureType featureType) {
        try {
            MemoryStoreParameters parameters = FeatureTypeToStoreProviderAdapter.getParameters(featureType);
            DefaultFeatureStore store = new DefaultFeatureStore();
            FeatureTypeToStoreProviderAdapter provider = new FeatureTypeToStoreProviderAdapter((DataStoreParameters)parameters, (DataStoreProviderServices)store, featureType);
            store.intialize(DALLocator.getDataManager(), (DataStoreParameters)parameters);
            store.setProvider((DataStoreProvider)provider);
            return store;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void initFeatureType() {
        if (featureTypeOfFeatureType != null) {
            return;
        }
        EditableFeatureType ft = this.getStoreServices().createFeatureType(this.getName());
        ft.setHasOID(true);
        ft.add("name", 8, 100);
        ft.add("type", 4, 0);
        ft.add("typeName", 8, 100);
        ft.add("size", 4, 0);
        ft.add("precision", 4, 0);
        ft.add("label", 8, 100);
        ft.add("shortlabel", 8, 100);
        ft.add("description", 8, 1024);
        ft.add("profile", 8, 100);
        ft.add("group", 8, 100);
        ft.add("order", 4, 0);
        ft.add("isPk", 1, 0);
        ft.add("isFk", 1, 0);
        ft.add("isClosedList", 1, 0);
        ft.add("isReadOnly", 1, 0);
        ft.add("isComputed", 1, 0);
        ft.add("isAutomatic", 1, 0);
        ft.add("isHidden", 1, 0);
        ft.add("allowNulls", 1, 0);
        ft.add("expression", 8, 1024);
        ft.add("fkTable", 8, 100);
        ft.add("fkCode", 8, 100);
        ft.add("fkLabel", 8, 1024);
        featureTypeOfFeatureType = ft;
        attrName2Index = new HashMap<String, Integer>();
        for (FeatureAttributeDescriptor attr : ft) {
            attrName2Index.put(attr.getName(), attr.getIndex());
        }
    }

    private static MemoryStoreParameters getParameters(FeatureType featureType) {
        MemoryStoreParameters params = new MemoryStoreParameters(NAME);
        params.setDynValue("autoOrderAttributeName", "name");
        return params;
    }

    public void open() throws OpenException {
    }

    public FeatureProvider createFeatureProvider(FeatureType featureType) throws DataException {
        return null;
    }

    public ResourceProvider getResource() {
        return this.resource;
    }

    public final Object getSourceId() {
        return this.sourceID;
    }

    public final String getProviderName() {
        return NAME;
    }

    public final String getName() {
        return this.featureType.getStore().getName() + "!" + this.featureType.getId();
    }

    public final String getFullName() {
        return this.featureType.getStore().getFullName() + "!" + this.featureType.getId();
    }

    public Object createNewOID() {
        return null;
    }

    public int getOIDType() {
        return 5;
    }

    private static class Features
    extends AbstractList<FeatureProvider>
    implements List<FeatureProvider> {
        private final FeatureType featureType;

        public Features(FeatureType featureType) {
            this.featureType = featureType;
        }

        @Override
        public FeatureProvider get(int index) {
            return new MyFeatureProvider(this.featureType.get(index));
        }

        @Override
        public int size() {
            return this.featureType.size();
        }

        private static class MyFeatureProvider
        implements FeatureProvider {
            private FeatureAttributeDescriptor descriptor;

            public MyFeatureProvider(FeatureAttributeDescriptor descriptor) {
                this.descriptor = descriptor;
            }

            public boolean isReadOnly(int i) {
                return true;
            }

            public void set(int i, Object value) {
            }

            public Object get(int i) {
                switch (i) {
                    case 0: {
                        return this.descriptor.getName();
                    }
                    case 3: {
                        return this.descriptor.getSize();
                    }
                    case 1: {
                        return this.descriptor.getType();
                    }
                    case 2: {
                        return this.descriptor.getDataTypeName();
                    }
                    case 4: {
                        return this.descriptor.getPrecision();
                    }
                    case 23: {
                        return this.descriptor.getScale();
                    }
                    case 6: {
                        return this.descriptor.getShortLabel();
                    }
                    case 5: {
                        return this.descriptor.getLabel();
                    }
                    case 7: {
                        return this.descriptor.getDescription();
                    }
                    case 8: {
                        return this.descriptor.getDataProfileName();
                    }
                    case 9: {
                        return this.descriptor.getGroup();
                    }
                    case 10: {
                        return this.descriptor.getOder();
                    }
                    case 11: {
                        return this.descriptor.isPrimaryKey();
                    }
                    case 12: {
                        return this.descriptor.isForeingKey();
                    }
                    case 13: {
                        if (this.descriptor.isForeingKey()) {
                            return this.descriptor.getForeingKey().isClosedList();
                        }
                        return false;
                    }
                    case 14: {
                        return this.descriptor.isReadOnly();
                    }
                    case 15: {
                        return this.descriptor.isComputed();
                    }
                    case 16: {
                        return this.descriptor.isAutomatic();
                    }
                    case 17: {
                        return this.descriptor.isHidden();
                    }
                    case 18: {
                        return this.descriptor.allowNull();
                    }
                    case 19: {
                        Expression exp;
                        FeatureAttributeEmulator x = this.descriptor.getFeatureAttributeEmulator();
                        if (x instanceof FeatureAttributeEmulatorExpression && (exp = ((FeatureAttributeEmulatorExpression)x).getExpression()) != null) {
                            return exp.getPhrase();
                        }
                        return null;
                    }
                    case 20: {
                        if (this.descriptor.isForeingKey()) {
                            return this.descriptor.getForeingKey().getTableName();
                        }
                        return null;
                    }
                    case 21: {
                        if (this.descriptor.isForeingKey()) {
                            return this.descriptor.getForeingKey().getCodeName();
                        }
                        return null;
                    }
                    case 22: {
                        if (this.descriptor.isForeingKey()) {
                            return this.descriptor.getForeingKey().getLabelFormula();
                        }
                        return null;
                    }
                }
                return null;
            }

            public void set(String name, Object value) {
            }

            public Object get(String name) {
                int n = (Integer)attrName2Index.get(name);
                return this.get(n);
            }

            public void setOID(Object oid) {
            }

            public Object getOID() {
                return (long)this.descriptor.getIndex();
            }

            public FeatureType getType() {
                return featureTypeOfFeatureType;
            }

            public FeatureProvider getCopy() {
                return this;
            }

            public Envelope getDefaultEnvelope() {
                return null;
            }

            public Geometry getDefaultGeometry() {
                return null;
            }

            public Time getDefaultTime() {
                return null;
            }

            public void setDefaultEnvelope(Envelope extent) {
            }

            public void setDefaultGeometry(Geometry geom) {
            }

            public void setDefaultTime(Time time) {
            }

            public boolean isNull(int i) {
                return false;
            }

            public boolean isNull(String name) {
                return false;
            }

            public boolean isNew() {
                return false;
            }

            public void setNew(boolean isNew) {
            }

            public void setExtraValue(int index, Object value) {
            }

            public Object getExtraValue(int index) {
                return null;
            }

            public Object getExtraValue(String name) {
                return null;
            }

            public void setExtraValueNames(String[] extraValueNames) {
            }

            public boolean hasExtraValue(String name) {
                return false;
            }

            public boolean isBroken() {
                return false;
            }

            public int getDataStatus() {
                return 0;
            }
        }
    }
}

