/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.EditableForeingKey;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.LabelsCacheForFieldValues;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelsCacheForFieldValuesImpl
implements LabelsCacheForFieldValues {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LabelsCacheForFieldValuesImpl.class);
    private static final DynObjectValueItem[] INVALID_AVAILABLE_VALUES = new DynObjectValueItem[1];
    private final Map<String, DynObjectValueItem[]> availableValues = new HashMap<String, DynObjectValueItem[]>();
    private final Invocable labelFormulaProvider;
    private final SimpleTaskStatus status;

    public LabelsCacheForFieldValuesImpl(Invocable labelFormulaProvider, SimpleTaskStatus status) {
        this.labelFormulaProvider = labelFormulaProvider;
        this.status = status;
    }

    public LabelsCacheForFieldValuesImpl() {
        this(null, null);
    }

    private void message(String msg) {
        if (this.status == null) {
            return;
        }
        this.status.message(msg);
    }

    private DynObjectValueItem[] getAvailableValuesFromCache(String fieldName) {
        return this.availableValues.get(fieldName);
    }

    private void addAvailableValuesToCache(String fieldName, DynObjectValueItem[] values) {
        this.availableValues.put(fieldName, values);
    }

    private boolean areValidAvailableValues(DynObjectValueItem[] values) {
        return values != null && values != INVALID_AVAILABLE_VALUES;
    }

    private void invalidateAvailableValuesInCache(String fieldName) {
        this.availableValues.put(fieldName, INVALID_AVAILABLE_VALUES);
    }

    private String getAlternativeLabelFormula(FeatureType featureType, Feature feature, String fieldName) {
        if (this.labelFormulaProvider == null) {
            return null;
        }
        String labelPhrase = (String)this.labelFormulaProvider.call(new Object[]{featureType, feature, fieldName});
        return labelPhrase;
    }

    public String getLabelForFieldValue(Feature feature, String fieldName) {
        FeatureStore store = feature.getStore();
        String availableValuesId = store.getFullName() + "/" + fieldName;
        String availableValuesLabelId = store.getName() + "/" + fieldName;
        DynObjectValueItem[] theAvailableValues = this.getAvailableValuesFromCache(availableValuesId);
        Object value = feature.get(fieldName);
        try {
            if (theAvailableValues == null) {
                DynObjectValueItem[] featureType = feature.getType();
                FeatureAttributeDescriptor attr = featureType.getAttributeDescriptor(fieldName);
                String labelFormula = this.getAlternativeLabelFormula((FeatureType)featureType, feature, fieldName);
                if (StringUtils.isBlank((CharSequence)labelFormula)) {
                    if (attr.hasAvailableValues()) {
                        this.message("Loading values for " + availableValuesLabelId);
                        this.addAvailableValuesToCache(availableValuesId, attr.getAvailableValues(null));
                    }
                } else if (attr.isForeingKey()) {
                    try {
                        EditableForeingKey fk = (EditableForeingKey)attr.getForeingKey().clone();
                        fk.unbind();
                        fk.setLabelFormula(labelFormula);
                        this.message("Loading values for " + availableValuesLabelId);
                        this.addAvailableValuesToCache(availableValuesId, fk.getAvailableValues(null));
                    }
                    catch (CloneNotSupportedException ex) {
                        LOGGER.warn("Not able to clone foreing key. " + ex.toString());
                    }
                }
                theAvailableValues = this.getAvailableValuesFromCache(availableValuesId);
            }
            if (this.areValidAvailableValues(theAvailableValues)) {
                for (DynObjectValueItem theAvailableValue : theAvailableValues) {
                    if (!Objects.equals(value, theAvailableValue.getValue())) continue;
                    return theAvailableValue.getLabel();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Fail", (Throwable)ex);
            this.invalidateAvailableValuesInCache(availableValuesId);
        }
        return Objects.toString(value, "");
    }
}

