/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.editing.memory;

import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.EditingManager;
import org.gvsig.fmap.dal.feature.impl.editing.memory.FeatureManager;
import org.gvsig.fmap.dal.feature.impl.editing.memory.FeatureTypeManager;
import org.gvsig.fmap.dal.feature.impl.editing.memory.SpatialManager;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.geom.primitive.Envelope;

public class MemoryEditingManager
implements EditingManager {
    private final FeatureTypeManager featureTypeManager;
    private final FeatureManager featureManager;
    private final SpatialManager spatialManager;

    public MemoryEditingManager(DefaultFeatureStore store, Envelope envelope) throws DataException {
        this.featureManager = new FeatureManager(store);
        this.featureTypeManager = new FeatureTypeManager(store);
        this.spatialManager = new SpatialManager(store);
    }

    @Override
    public void dispose() {
        this.featureTypeManager.dispose();
        this.spatialManager.clear();
        this.featureManager.clear();
    }

    @Override
    public void delete(Feature feature) {
        this.featureManager.delete(feature);
        this.spatialManager.deleteFeature(feature);
    }

    @Override
    public void add(EditableFeature newFeature) {
        this.featureManager.add(newFeature);
        this.spatialManager.insertFeature((Feature)newFeature);
    }

    @Override
    public int update(EditableFeature newFeature, Feature oldFeature) {
        int code = this.featureManager.update(newFeature, oldFeature);
        this.spatialManager.updateFeature((Feature)newFeature, oldFeature);
        return code;
    }

    @Override
    public int update(FeatureType newFeatureType, FeatureType oldFeatureType) {
        int code = this.featureTypeManager.update(oldFeatureType, oldFeatureType);
        return code;
    }

    @Override
    public boolean isSelectionCompromised() {
        return this.featureManager.isSelectionCompromised();
    }

    @Override
    public Iterator<FeatureReference> getDeletedFeatures() {
        return this.featureManager.getDeleted();
    }

    @Override
    public Iterator<FeatureProvider> getInsertedFeatures() {
        return this.featureManager.getInserted();
    }

    @Override
    public Iterator<FeatureProvider> getUpdatedFeatures() {
        return this.featureManager.getUpdated();
    }

    @Override
    public List<FeatureType.FeatureTypeChanged> getFeatureTypesChanged() throws DataException {
        return this.featureTypeManager.getFeatureTypesChanged();
    }

    @Override
    public FeatureType getFeatureType(String id) throws DataException {
        return this.featureTypeManager.getType(id);
    }

    @Override
    public Feature getFeature(FeatureReference reference, FeatureStore store, FeatureType type) throws DataException {
        return this.featureManager.get(reference, store, type);
    }

    @Override
    public void restore(FeatureReference featureReference) {
        this.featureManager.restore(featureReference);
    }

    @Override
    public void restore(FeatureReference featureReference, int code) {
        this.featureManager.restore(featureReference, code);
    }

    @Override
    public void restore(String featureTypeId) {
        this.featureTypeManager.restore(featureTypeId);
    }

    @Override
    public void restore(String featureTypeId, int code) {
        this.featureTypeManager.restore(featureTypeId, code);
    }

    @Override
    public boolean isDeleted(Feature feature) {
        return this.featureManager.isDeleted(feature);
    }

    @Override
    public boolean isDeleted(FeatureReference featureReference) {
        return this.featureManager.isDeleted(featureReference);
    }

    @Override
    public boolean isDeleted(FeatureType type) {
        return this.featureTypeManager.isDeleted(type);
    }

    @Override
    public boolean isDeleted(String featureTypeId) {
        return this.featureTypeManager.isDeleted(featureTypeId);
    }
}

