/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featurereference;

import java.lang.ref.WeakReference;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import org.apache.commons.lang3.ArrayUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FeatureReferencePK
implements FeatureReferenceProviderServices,
Persistent {
    public static final String PK_TYPE = "pk";
    private Object[] pk;
    private String[] pkNames;
    private WeakReference storeRef;
    private String featureTypeId;
    private Integer myHashCode;

    FeatureReferencePK(FeatureStore store, FeatureProvider data) {
        this.storeRef = new WeakReference<FeatureStore>(store);
        this.featureTypeId = store.getDefaultFeatureTypeQuietly().getId();
        this.doCalculatePK(data);
    }

    FeatureReferencePK(FeatureStore store, Object pkvalue) {
        this.storeRef = new WeakReference<FeatureStore>(store);
        FeatureType featureType = store.getDefaultFeatureTypeQuietly();
        this.featureTypeId = featureType.getId();
        Object[] pkattrs = featureType.getPrimaryKey();
        if (ArrayUtils.isEmpty((Object[])pkattrs)) {
            throw new IllegalArgumentException("Feature don't has primary key");
        }
        if (pkattrs.length != 1) {
            throw new IllegalArgumentException("Feature has a non supported multi-field primary key");
        }
        this.pk = new Object[]{pkvalue};
        this.pkNames = new String[]{pkattrs[0].getName()};
    }

    FeatureReferencePK(FeatureStore store, JsonObject code) {
        this.storeRef = new WeakReference<FeatureStore>(store);
        this.featureTypeId = store.getDefaultFeatureTypeQuietly().getId();
        this.pk = Json.toArray((JsonObject)code, (String)"values", (Object[])new Object[code.getJsonArray("values").size()]);
        this.pkNames = (String[])Json.toArray((JsonObject)code, (String)"names", (Object[])new String[code.getJsonArray("names").size()]);
    }

    public FeatureReferencePK() {
    }

    public void calculatePK(FeatureProvider fdata) {
        this.doCalculatePK(fdata);
    }

    private void doCalculatePK(FeatureProvider fdata) {
        Object[] pkattrs = fdata.getType().getPrimaryKey();
        if (ArrayUtils.isEmpty((Object[])pkattrs)) {
            throw new IllegalArgumentException("Feature don't has primary key");
        }
        this.pk = new Object[pkattrs.length];
        this.pkNames = new String[pkattrs.length];
        int n = 0;
        for (Object pkattr : pkattrs) {
            this.pk[n] = fdata.get(pkattr.getIndex());
            this.pkNames[n] = pkattr.getName();
            ++n;
        }
    }

    public Object getOID() {
        return null;
    }

    public String[] getKeyNames() {
        return this.pkNames;
    }

    public Object getKeyValue(String name) {
        for (int i = 0; i < this.pkNames.length; ++i) {
            if (!this.pkNames[i].equalsIgnoreCase(name)) continue;
            return this.pk[i];
        }
        return null;
    }

    public String getFeatureTypeId() {
        return this.featureTypeId;
    }

    public Feature getFeature() throws DataException {
        return this.getStore().getFeatureByReference((FeatureReference)this);
    }

    public Feature getFeatureQuietly() {
        try {
            return this.getFeature();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Feature getFeature(FeatureType featureType) throws DataException {
        return this.getStore().getFeatureByReference((FeatureReference)this, featureType);
    }

    private DefaultFeatureStore getStore() {
        return (DefaultFeatureStore)((Object)this.storeRef.get());
    }

    public boolean isNewFeature() {
        return false;
    }

    public String getCode() {
        String s = this.toJsonBuilder().toString();
        String r = Base64.getEncoder().encodeToString(s.getBytes());
        return r;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("type", PK_TYPE);
        state.set("store", (Persistent)this.storeRef.get());
        state.set("featureTypeId", this.featureTypeId);
        if (this.pk == null) {
            state.setNull(PK_TYPE);
            state.setNull("pkNames");
        } else {
            state.set(PK_TYPE, this.pk);
            state.set("pkNames", this.pkNames);
        }
        state.set("isNewFeature", this.isNewFeature());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.storeRef = new WeakReference<Object>(state.get("store"));
        this.featureTypeId = state.getString("featureTypeId");
        List pkList = (List)state.get(PK_TYPE);
        if (pkList != null) {
            List pkNamesList = (List)state.get("pkNames");
            if (pkNamesList == null || pkList.size() != pkNamesList.size()) {
                throw new PersistenceException("bad pkNames value");
            }
            this.pk = pkList.toArray();
            this.pkNames = pkNamesList.toArray(new String[pkList.size()]);
        } else {
            this.pk = null;
            this.pkNames = null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureReferencePK)) {
            return false;
        }
        FeatureReferencePK other = (FeatureReferencePK)obj;
        FeatureStore otherStore = (FeatureStore)other.storeRef.get();
        FeatureStore myrStore = (FeatureStore)this.storeRef.get();
        if (otherStore == null || myrStore == null) {
            return false;
        }
        if (!myrStore.equals(otherStore)) {
            return false;
        }
        if (this.myHashCode != null && other.myHashCode != null && !this.myHashCode.equals(other.myHashCode)) {
            return false;
        }
        if (this.pk == other.pk) {
            return true;
        }
        if (this.pk == null || other.pk == null) {
            return false;
        }
        for (int i = 0; i < this.pk.length; ++i) {
            if (this.pk[i].equals(other.pk[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < this.pk.length; ++i) {
                buff.append(Objects.hashCode(this.pk[i]));
                buff.append("##");
            }
            this.myHashCode = buff.toString().hashCode();
        }
        return this.myHashCode;
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("type", PK_TYPE);
        if (this.pk == null) {
            builder.addNull("names");
            builder.addNull("values");
        } else {
            org.gvsig.json.JsonArrayBuilder arrayNames = Json.createArrayBuilder();
            org.gvsig.json.JsonArrayBuilder arrayValues = Json.createArrayBuilder();
            for (int i = 0; i < this.pk.length; ++i) {
                arrayNames.add(this.pkNames[i]);
                arrayValues.add(this.pk[i]);
            }
            builder.add("names", (JsonArrayBuilder)arrayNames);
            builder.add("values", (JsonArrayBuilder)arrayValues);
        }
        return builder;
    }

    public String toString() {
        if (this.pk == null) {
            return "NULL";
        }
        boolean needsep = false;
        StringBuilder builder = new StringBuilder();
        for (Object v : this.pk) {
            if (needsep) {
                builder.append("/");
            }
            builder.append(Objects.toString(v));
            needsep = true;
        }
        return builder.toString();
    }
}

