/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featureset;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultEditableFeature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultFeatureSet;
import org.gvsig.fmap.dal.feature.impl.featureset.EditedIterator;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.tools.exception.BaseException;

public class FastEditedIterator
extends EditedIterator {
    private DefaultFeature myFeature;

    public FastEditedIterator(DefaultFeatureSet featureSet, long index, long elements) throws DataException {
        super(featureSet, index, elements);
    }

    @Override
    protected DefaultFeature createFeature(FeatureProvider data) throws DataException {
        DefaultFeature f;
        if (this.myFeature == null) {
            this.myFeature = new DefaultFeature(this.fset.store);
        }
        if ((f = this.featureManager.get(data)) == null) {
            this.myFeature.setData(data);
        } else {
            this.myFeature.setData(f.getData().getCopy());
        }
        if (this.fset.transform.isEmpty()) {
            return this.myFeature;
        }
        if (f == null) {
            this.myFeature = (DefaultFeature)this.fset.transform.applyTransform(this.myFeature, this.fset.getDefaultFeatureType());
        } else {
            DefaultFeature saved_feat = (DefaultFeature)this.myFeature.getCopy();
            this.myFeature = (DefaultFeature)this.fset.transform.applyTransform(this.myFeature, this.fset.getDefaultFeatureType());
            this.myFeature = this.overwrite(this.myFeature, saved_feat);
        }
        return this.myFeature;
    }

    private DefaultFeature overwrite(DefaultFeature old_feat, DefaultFeature new_feat) {
        DefaultEditableFeature resp = (DefaultEditableFeature)old_feat.getEditable();
        FeatureType fty = new_feat.getData().getType();
        FeatureAttributeDescriptor[] atts = fty.getAttributeDescriptors();
        for (int i = 0; i < atts.length; ++i) {
            try {
                resp.set(atts[i].getName(), new_feat.get(atts[i].getName()));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (DefaultFeature)resp.getNotEditableCopy();
    }

    @Override
    public void remove() {
        super.remove();
        this.myFeature = new DefaultFeature(this.fset.store);
    }

    @Override
    protected void doDispose() throws BaseException {
        super.doDispose();
        this.myFeature = null;
    }
}

