/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.indexes.memorybasictypes;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.gvsig.fmap.dal.feature.impl.indexes.memorybasictypes.ListOfLong;

public class ArrayListOfLong
extends AbstractList<Long>
implements ListOfLong,
RandomAccess,
Cloneable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 10;
    private static final long[] EMPTY_ELEMENTDATA = new long[0];
    private static final long[] DEFAULTCAPACITY_EMPTY_ELEMENTDATA = new long[0];
    transient long[] elementData;
    private int size;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public ArrayListOfLong(int initialCapacity) {
        if (initialCapacity > 0) {
            this.elementData = new long[initialCapacity];
        } else if (initialCapacity == 0) {
            this.elementData = EMPTY_ELEMENTDATA;
        } else {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
    }

    public ArrayListOfLong() {
        this.elementData = DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
    }

    public ArrayListOfLong(Collection<? extends Long> c) {
        this.size = c.size();
        if (this.size != 0) {
            this.grow(c.size());
            int i = 0;
            for (Long l : c) {
                this.elementData[i++] = l;
            }
        } else {
            this.elementData = EMPTY_ELEMENTDATA;
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.elementData.length) {
            this.elementData = this.size == 0 ? EMPTY_ELEMENTDATA : Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int minExpand;
        int n = minExpand = this.elementData != DEFAULTCAPACITY_EMPTY_ELEMENTDATA ? 0 : 10;
        if (minCapacity > minExpand) {
            this.ensureExplicitCapacity(minCapacity);
        }
    }

    private static int calculateCapacity(long[] elementData, int minCapacity) {
        if (elementData == DEFAULTCAPACITY_EMPTY_ELEMENTDATA) {
            return Math.max(10, minCapacity);
        }
        return minCapacity;
    }

    private void ensureCapacityInternal(int minCapacity) {
        this.ensureExplicitCapacity(ArrayListOfLong.calculateCapacity(this.elementData, minCapacity));
    }

    private void ensureExplicitCapacity(int minCapacity) {
        ++this.modCount;
        if (minCapacity - this.elementData.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ArrayListOfLong.hugeCapacity(minCapacity);
        }
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!o.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (!o.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            ArrayListOfLong v = (ArrayListOfLong)super.clone();
            v.elementData = Arrays.copyOf(this.elementData, this.size);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public Long[] toArray() {
        return this.toArray((Long[])null);
    }

    public Long[] toArray(Long[] a) {
        if (a == null || a.length < this.size) {
            a = new Long[this.size];
        }
        for (int i = 0; i < this.size; ++i) {
            a[i] = this.elementData[i];
        }
        return a;
    }

    long elementData(int index) {
        return this.elementData[index];
    }

    @Override
    public Long get(int index) {
        return this.getLong(index);
    }

    @Override
    public long getLong(int index) {
        this.rangeCheck(index);
        return this.elementData(index);
    }

    @Override
    public Long set(int index, Long element) {
        this.rangeCheck(index);
        Long oldValue = this.elementData(index);
        this.elementData[index] = element;
        return oldValue;
    }

    @Override
    public boolean add(Long e) {
        return this.add((long)e);
    }

    @Override
    public boolean add(long e) {
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public void add(int index, Long element) {
        this.add(index, (long)element);
    }

    @Override
    public void add(int index, long element) {
        this.rangeCheckForAdd(index);
        this.ensureCapacityInternal(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    @Override
    public Long remove(int index) {
        this.rangeCheck(index);
        ++this.modCount;
        Long oldValue = this.elementData(index);
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        return oldValue;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return true;
        }
        return this.removeLong((Long)o);
    }

    @Override
    public boolean removeLong(long o) {
        for (int index = 0; index < this.size; ++index) {
            if (o != this.elementData[index]) continue;
            this.remove(index);
            return true;
        }
        return false;
    }

    private void fastRemove(int index) {
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends Long> c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacityInternal(this.size + numNew);
        System.arraycopy(a, 0, this.elementData, this.size, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Long> c) {
        this.rangeCheckForAdd(index);
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacityInternal(this.size + numNew);
        int numMoved = this.size - index;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, this.elementData, index, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        int newSize;
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        this.size = newSize = this.size - (toIndex - fromIndex);
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.batchRemove(c, false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.batchRemove(c, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchRemove(Collection<?> c, boolean complement) {
        int r;
        long[] elementData = this.elementData;
        int w = 0;
        boolean modified = false;
        try {
            for (r = 0; r < this.size; ++r) {
                if (c.contains(elementData[r]) != complement) continue;
                elementData[w++] = elementData[r];
            }
        }
        finally {
            if (r != this.size) {
                System.arraycopy(elementData, r, elementData, w, this.size - r);
                w += this.size - r;
            }
            if (w != this.size) {
                this.modCount += this.size - w;
                this.size = w;
                modified = true;
            }
        }
        return modified;
    }

    @Override
    public ListIterator<Long> listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    @Override
    public ListIterator<Long> listIterator() {
        return new ListItr(0);
    }

    @Override
    public Iterator<Long> iterator() {
        return new Itr();
    }

    @Override
    public List<Long> subList(int fromIndex, int toIndex) {
        ArrayListOfLong.subListRangeCheck(fromIndex, toIndex, this.size);
        return new SubList(this, 0, fromIndex, toIndex);
    }

    static void subListRangeCheck(int fromIndex, int toIndex, int size) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > size) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
    }

    @Override
    public void forEach(Consumer<? super Long> action) {
        Objects.requireNonNull(action);
        int expectedModCount = this.modCount;
        long[] elementData = this.elementData;
        int size = this.size;
        for (int i = 0; this.modCount == expectedModCount && i < size; ++i) {
            action.accept((Long)elementData[i]);
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Spliterator<Long> spliterator() {
        return new ArrayListSpliterator(this, 0, -1, 0);
    }

    @Override
    public boolean removeIf(Predicate<? super Long> filter) {
        boolean anyToRemove;
        Objects.requireNonNull(filter);
        int removeCount = 0;
        BitSet removeSet = new BitSet(this.size);
        int expectedModCount = this.modCount;
        int size = this.size;
        for (int i = 0; this.modCount == expectedModCount && i < size; ++i) {
            Long element = this.elementData[i];
            if (!filter.test(element)) continue;
            removeSet.set(i);
            ++removeCount;
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        boolean bl = anyToRemove = removeCount > 0;
        if (anyToRemove) {
            int newSize = size - removeCount;
            int i = 0;
            for (int j = 0; i < size && j < newSize; ++i, ++j) {
                i = removeSet.nextClearBit(i);
                this.elementData[j] = this.elementData[i];
            }
            this.size = newSize;
            if (this.modCount != expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ++this.modCount;
        }
        return anyToRemove;
    }

    @Override
    public void replaceAll(UnaryOperator<Long> operator) {
        Objects.requireNonNull(operator);
        int expectedModCount = this.modCount;
        int size = this.size;
        for (int i = 0; this.modCount == expectedModCount && i < size; ++i) {
            this.elementData[i] = (Long)operator.apply(this.elementData[i]);
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    @Override
    public void sort(Comparator<? super Long> c) {
        int expectedModCount = this.modCount;
        Arrays.sort(this.elementData);
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    static /* synthetic */ int access$000(ArrayListOfLong x0) {
        return x0.modCount;
    }

    static final class ArrayListSpliterator
    implements Spliterator<Long> {
        private final ArrayListOfLong list;
        private int index;
        private int fence;
        private int expectedModCount;

        ArrayListSpliterator(ArrayListOfLong list, int origin, int fence, int expectedModCount) {
            this.list = list;
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                ArrayListOfLong lst = this.list;
                if (lst == null) {
                    this.fence = 0;
                    hi = 0;
                } else {
                    this.expectedModCount = lst.modCount;
                    hi = this.fence = lst.size;
                }
            }
            return hi;
        }

        public ArrayListSpliterator trySplit() {
            ArrayListSpliterator arrayListSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                arrayListSpliterator = null;
            } else {
                this.index = mid;
                ArrayListSpliterator arrayListSpliterator2 = new ArrayListSpliterator(this.list, lo, this.index, this.expectedModCount);
                arrayListSpliterator = arrayListSpliterator2;
            }
            return arrayListSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int i = this.index;
            int hi = this.getFence();
            if (i < hi) {
                this.index = i + 1;
                Long e = this.list.elementData[i];
                action.accept(e);
                if (this.list.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            ArrayListOfLong lst = this.list;
            if (lst != null) {
                long[] a = lst.elementData;
                if (lst.elementData != null) {
                    int i;
                    int mc;
                    int hi = this.fence;
                    if (hi < 0) {
                        mc = lst.modCount;
                        hi = lst.size;
                    } else {
                        mc = this.expectedModCount;
                    }
                    if (i >= 0 && (this.index = hi) <= a.length) {
                        for (i = this.index; i < hi; ++i) {
                            action.accept((Long)a[i]);
                        }
                        if (lst.modCount == mc) {
                            return;
                        }
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }

    private class SubList
    extends ArrayListOfLong
    implements RandomAccess {
        private final ArrayListOfLong parent;
        private final int parentOffset;
        private final int offset;
        int size;

        SubList(ArrayListOfLong parent, int offset, int fromIndex, int toIndex) {
            this.parent = parent;
            this.parentOffset = fromIndex;
            this.offset = offset + fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = ArrayListOfLong.this.modCount;
        }

        @Override
        public Long set(int index, Long e) {
            this.rangeCheck(index);
            this.checkForComodification();
            Long oldValue = ArrayListOfLong.this.elementData(this.offset + index);
            ArrayListOfLong.this.elementData[this.offset + index] = e;
            return oldValue;
        }

        @Override
        public Long get(int index) {
            this.rangeCheck(index);
            this.checkForComodification();
            return ArrayListOfLong.this.elementData(this.offset + index);
        }

        @Override
        public int size() {
            this.checkForComodification();
            return this.size;
        }

        @Override
        public void add(int index, Long e) {
            this.rangeCheckForAdd(index);
            this.checkForComodification();
            this.parent.add(this.parentOffset + index, e);
            this.modCount = this.parent.modCount;
            ++this.size;
        }

        @Override
        public Long remove(int index) {
            this.rangeCheck(index);
            this.checkForComodification();
            Long result = this.parent.remove(this.parentOffset + index);
            this.modCount = this.parent.modCount;
            --this.size;
            return result;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.checkForComodification();
            this.parent.removeRange(this.parentOffset + fromIndex, this.parentOffset + toIndex);
            this.modCount = this.parent.modCount;
            this.size -= toIndex - fromIndex;
        }

        @Override
        public boolean addAll(Collection<? extends Long> c) {
            return this.addAll(this.size, c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Long> c) {
            this.rangeCheckForAdd(index);
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.checkForComodification();
            this.parent.addAll(this.parentOffset + index, c);
            this.modCount = this.parent.modCount;
            this.size += cSize;
            return true;
        }

        @Override
        public Iterator<Long> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<Long> listIterator(final int index) {
            this.checkForComodification();
            this.rangeCheckForAdd(index);
            final int offset = this.offset;
            return new ListIterator<Long>(){
                int cursor;
                int lastRet;
                int expectedModCount;
                {
                    this.cursor = index;
                    this.lastRet = -1;
                    this.expectedModCount = ArrayListOfLong.this.modCount;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor != SubList.this.size;
                }

                @Override
                public Long next() {
                    this.checkForComodification();
                    int i = this.cursor;
                    if (i >= SubList.this.size) {
                        throw new NoSuchElementException();
                    }
                    long[] elementData = ArrayListOfLong.this.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i + 1;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public Long previous() {
                    this.checkForComodification();
                    int i = this.cursor - 1;
                    if (i < 0) {
                        throw new NoSuchElementException();
                    }
                    long[] elementData = ArrayListOfLong.this.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public void forEachRemaining(Consumer<? super Long> consumer) {
                    Objects.requireNonNull(consumer);
                    int size = SubList.this.size;
                    int i = this.cursor;
                    if (i >= size) {
                        return;
                    }
                    long[] elementData = ArrayListOfLong.this.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    while (i != size && SubList.this.modCount == this.expectedModCount) {
                        consumer.accept((Long)elementData[offset + i++]);
                    }
                    this.lastRet = this.cursor = i;
                    this.checkForComodification();
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        SubList.this.remove(this.lastRet);
                        this.cursor = this.lastRet;
                        this.lastRet = -1;
                        this.expectedModCount = ArrayListOfLong.this.modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void set(Long e) {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        ArrayListOfLong.this.set(offset + this.lastRet, e);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void add(Long e) {
                    this.checkForComodification();
                    try {
                        int i = this.cursor;
                        SubList.this.add(i, e);
                        this.cursor = i + 1;
                        this.lastRet = -1;
                        this.expectedModCount = ArrayListOfLong.this.modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                final void checkForComodification() {
                    if (this.expectedModCount != ArrayListOfLong.this.modCount) {
                        throw new ConcurrentModificationException();
                    }
                }
            };
        }

        @Override
        public List<Long> subList(int fromIndex, int toIndex) {
            SubList.subListRangeCheck(fromIndex, toIndex, this.size);
            return new SubList(this, this.offset, fromIndex, toIndex);
        }

        @Override
        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        @Override
        private void rangeCheckForAdd(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        @Override
        private String outOfBoundsMsg(int index) {
            return "Index: " + index + ", Size: " + this.size;
        }

        private void checkForComodification() {
            if (ArrayListOfLong.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public Spliterator<Long> spliterator() {
            this.checkForComodification();
            return new ArrayListSpliterator(ArrayListOfLong.this, this.offset, this.offset + this.size, this.modCount);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<Long> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public Long previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            long[] elementData = ArrayListOfLong.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void set(Long e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayListOfLong.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(Long e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                ArrayListOfLong.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
                this.expectedModCount = ArrayListOfLong.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<Long> {
        int cursor;
        int lastRet = -1;
        int expectedModCount = ArrayListOfLong.access$000(ArrayListOfLong.this);

        Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArrayListOfLong.this.size;
        }

        @Override
        public Long next() {
            this.checkForComodification();
            int i = this.cursor;
            if (i >= ArrayListOfLong.this.size) {
                throw new NoSuchElementException();
            }
            long[] elementData = ArrayListOfLong.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayListOfLong.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = ArrayListOfLong.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Long> consumer) {
            Objects.requireNonNull(consumer);
            int size = ArrayListOfLong.this.size;
            int i = this.cursor;
            if (i >= size) {
                return;
            }
            long[] elementData = ArrayListOfLong.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            while (i != size && ArrayListOfLong.this.modCount == this.expectedModCount) {
                consumer.accept((Long)elementData[i++]);
            }
            this.cursor = i;
            this.lastRet = i - 1;
            this.checkForComodification();
        }

        final void checkForComodification() {
            if (ArrayListOfLong.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

