/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.impl.expressionevaluator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.impl.DefaultExpression;
import org.gvsig.expressionevaluator.impl.symboltable.FeatureSymbolTableImpl;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.evaluator.AbstractEvaluator;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.evaluator.EvaluatorFieldsInfo;
import org.gvsig.tools.evaluator.EvaluatorWithDescriptions;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureExpressionEvaluator
extends AbstractEvaluator
implements ExpressionEvaluator,
Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFeatureExpressionEvaluator.class);
    private String storeName;
    private FeatureSymbolTable featureSymbolTable;
    private SymbolTable symbolTable;
    private Expression expression;
    private EvaluatorWithDescriptions.Description[] availableOperators;
    private EvaluatorWithDescriptions.Description[] availableFunctions;

    public DefaultFeatureExpressionEvaluator() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        this.symbolTable = manager.createSymbolTable();
        this.featureSymbolTable = new FeatureSymbolTableImpl();
        this.symbolTable.addSymbolTable((SymbolTable)this.featureSymbolTable);
        this.availableOperators = null;
        this.availableFunctions = null;
    }

    public DefaultFeatureExpressionEvaluator(String source) {
        this(null, source);
    }

    public DefaultFeatureExpressionEvaluator(String storeName, String source) {
        this();
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        this.expression = manager.createExpression();
        this.expression.setPhrase(source);
        this.storeName = storeName;
    }

    public DefaultFeatureExpressionEvaluator(Expression expression) {
        this(null, expression);
    }

    public DefaultFeatureExpressionEvaluator(String storeName, Expression expression) {
        this();
        this.expression = expression;
        this.storeName = storeName;
    }

    public String getName() {
        return "Genereric expression";
    }

    public String getDescription() {
        return this.expression.getPhrase();
    }

    public String getSQL() {
        return this.expression.getPhrase();
    }

    public Expression toExpression() {
        return this.expression;
    }

    public SymbolTable toSymbolTable() {
        return this.symbolTable;
    }

    public Object evaluate(EvaluatorData data) throws EvaluatorException {
        this.featureSymbolTable.setFeature((Feature)data);
        Object v = this.expression.execute(this.symbolTable);
        return v;
    }

    public EvaluatorFieldsInfo getFieldsInfo() {
        HashSet names = new HashSet();
        try {
            this.expression.getCode().accept(code -> {
                Code.Callable callable;
                if (code instanceof Code.Identifier) {
                    Code.Identifier identifier = (Code.Identifier)code;
                    if (!StringUtils.equalsIgnoreCase((CharSequence)this.storeName, (CharSequence)identifier.name())) {
                        names.add(identifier.name());
                    }
                } else if (code instanceof Code.Callable && (callable = (Code.Callable)code).name().equals("GETATTR")) {
                    Code p0 = (Code)callable.parameters().get(0);
                    if (!(p0 instanceof Code.Identifier)) {
                        return;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)this.storeName, (CharSequence)((Code.Identifier)p0).name())) {
                        return;
                    }
                    Code p1 = (Code)callable.parameters().get(1);
                    if (!(p1 instanceof Code.Constant)) {
                        return;
                    }
                    String s = Objects.toString(((Code.Constant)p1).value(), null);
                    if (s != null) {
                        names.add(s);
                    }
                }
            });
            EvaluatorFieldsInfo info = new EvaluatorFieldsInfo();
            for (String name : names) {
                info.addFieldValue(name);
            }
            return info;
        }
        catch (BaseException ex) {
            throw new RuntimeException("Can't calculate fields information.", ex);
        }
    }

    public EvaluatorWithDescriptions.Description[] getAvailableOperators() {
        if (this.availableOperators == null) {
            ArrayList<DescriptionAdapter> l = new ArrayList<DescriptionAdapter>();
            for (Function function : this.toSymbolTable()) {
                if (!function.isOperator()) continue;
                l.add(new DescriptionAdapter(function));
            }
            this.availableOperators = l.toArray(new EvaluatorWithDescriptions.Description[l.size()]);
        }
        return this.availableOperators;
    }

    public EvaluatorWithDescriptions.Description[] getAvailableFunctions() {
        if (this.availableFunctions == null) {
            ArrayList<DescriptionAdapter> l = new ArrayList<DescriptionAdapter>();
            for (Function function : this.toSymbolTable()) {
                if (function.isOperator()) continue;
                l.add(new DescriptionAdapter(function));
            }
            this.availableFunctions = l.toArray(new EvaluatorWithDescriptions.Description[l.size()]);
        }
        return this.availableFunctions;
    }

    public Evaluator clone() throws CloneNotSupportedException {
        DefaultFeatureExpressionEvaluator other = (DefaultFeatureExpressionEvaluator)((Object)super.clone());
        other.expression = this.expression.clone();
        other.availableFunctions = null;
        other.availableOperators = null;
        if (this.featureSymbolTable != null) {
            other.featureSymbolTable = this.featureSymbolTable.clone();
        }
        if (this.symbolTable != null) {
            other.symbolTable = this.symbolTable.clone();
        }
        return other;
    }

    public void saveToState(PersistentState ps) throws PersistenceException {
        ps.set("expression", (Persistent)this.expression);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.expression = (Expression)state.get("expression");
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("DefaultFeatureExpressionEvaluator") == null) {
            DynStruct definition = manager.addDefinition(DefaultFeatureExpressionEvaluator.class, "DefaultFeatureExpressionEvaluator", "DefaultFeatureExpressionEvaluator persistence definition", null, null);
            definition.addDynFieldObject("expression").setClassOfValue(DefaultExpression.class).setMandatory(false);
        }
    }

    public void addSymbolTable(SymbolTable symbolTable) {
        if (symbolTable != null) {
            this.symbolTable.addSymbolTable(symbolTable);
        }
    }

    public void fromJson(JsonObject json) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        this.symbolTable = manager.createSymbolTable();
        this.featureSymbolTable = new FeatureSymbolTableImpl();
        this.symbolTable.addSymbolTable((SymbolTable)this.featureSymbolTable);
        this.availableOperators = null;
        this.availableFunctions = null;
        this.expression = (Expression)Json.toObject((JsonObject)json, (String)"expression");
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder state = Json.createObjectBuilder();
        state.add("expression", (SupportToJson)this.expression);
        return state;
    }

    public String toString() {
        try {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("storeName", (Object)this.storeName);
            builder.append("expression", (Object)this.expression, true);
            builder.append("symbolTable", (Object)this.symbolTable);
            return builder.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    private static class DescriptionAdapter
    implements EvaluatorWithDescriptions.Description {
        Function function;

        public DescriptionAdapter(Function function) {
            this.function = function;
        }

        public String getName() {
            return this.function.name();
        }

        public String getDescription() {
            return this.function.description();
        }

        public String getTemplate() {
            return this.function.template();
        }

        public int getDataTypeCategories() {
            switch (this.function.group()) {
                case "String": {
                    return 2;
                }
                case "Boolean": {
                    return 8;
                }
                case "Datetime": {
                    return 4;
                }
                case "Numeric": {
                    return 1;
                }
                case "OGC": {
                    return 0;
                }
            }
            return 0;
        }
    }
}

