/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.PerformEditingException;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.feature.spi.memory.AbstractMemoryStoreProvider;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.memory.MemoryStoreParameters;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStoreProvider
extends AbstractMemoryStoreProvider {
    private static final Logger logger = LoggerFactory.getLogger(MemoryStoreProvider.class);
    public static final String NAME = "Memory";
    public static final String DESCRIPTION = "Memory provider";
    public static final String METADATA_DEFINITION_NAME = "MemoryProvider";
    private long counterNewsOIDs = 0L;
    private Envelope envelope = null;
    private Map oids = null;
    private Double sourceID = Math.random();
    private final ResourceProvider memoryResource;

    public static DynObject newMetadataContainer(String name) {
        return ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition(name));
    }

    public MemoryStoreProvider(MemoryStoreParameters memoryStoreParameters, DataStoreProviderServices storeServices) throws InitializeException {
        super((DataStoreParameters)memoryStoreParameters, storeServices, MemoryStoreProvider.newMetadataContainer(METADATA_DEFINITION_NAME));
        this.data = new ArrayList();
        this.oids = new HashMap();
        this.initialize();
        this.memoryResource = this.createResource("memory", new Object[]{memoryStoreParameters.getName()});
    }

    public boolean isTemporary() {
        try {
            return (Boolean)this.getParameters().getDynValue("isTemporary");
        }
        catch (Throwable th) {
            return false;
        }
    }

    public FeatureProvider createFeatureProvider(FeatureType featureType) throws DataException {
        this.open();
        return new AbstractMemoryStoreProvider.MemoryFeatureProvider((AbstractMemoryStoreProvider)this, featureType, this.createNewOID());
    }

    public String getName() {
        return "Memory_" + Integer.toHexString((int)(Math.random() * 100000.0)).toUpperCase();
    }

    public String getFullName() {
        return "memory:" + Double.toHexString(this.sourceID);
    }

    private void initialize() {
        EditableFeatureType editableFeatureType = this.getStoreServices().createFeatureType(this.getName());
        editableFeatureType.setHasOID(true);
        FeatureType featureType = editableFeatureType.getNotEditableCopy();
        ArrayList<FeatureType> types = new ArrayList<FeatureType>(1);
        types.add(featureType);
        this.getStoreServices().setFeatureTypes(types, featureType);
    }

    public Object createNewOID() {
        return this.counterNewsOIDs++;
    }

    public String getProviderName() {
        return NAME;
    }

    public int getOIDType() {
        return 5;
    }

    public Object getSourceId() {
        return this.sourceID;
    }

    public void open() throws OpenException {
    }

    public static void registerMetadataDefinition() throws MetadataException {
        MetadataManager manager = MetadataLocator.getMetadataManager();
        if (manager.getDefinition(METADATA_DEFINITION_NAME) == null) {
            DynStruct metadataDefinition = manager.addDefinition(METADATA_DEFINITION_NAME, "Memory Store");
            metadataDefinition.extend(manager.getDefinition("SpatialProvider"));
        }
    }

    public boolean allowWrite() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator originalFeatureTypesUpdated) throws PerformEditingException {
        block7: {
            FeatureSet set = null;
            Disposable iter = null;
            try {
                FeatureType featureType = this.getStoreServices().getDefaultFeatureType();
                ArrayList<FeatureType> types = new ArrayList<FeatureType>(1);
                types.add(featureType);
                this.getStoreServices().setFeatureTypes(types, featureType);
                set = this.getFeatureStore().getFeatureSet();
                EditionVisitor visitor = new EditionVisitor(set.getSize());
                set.accept((Visitor)visitor);
                this.data = visitor.getData();
                this.oids = visitor.getOids();
                this.envelope = visitor.getEnvelope();
                this.dispose(iter);
            }
            catch (DataException e) {
                logger.error("Error adding features", (Throwable)e);
                break block7;
            }
            catch (BaseException e2) {
                logger.error("Error performing edition", (Throwable)e2);
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.dispose(iter);
                this.dispose((Disposable)set);
            }
            this.dispose((Disposable)set);
        }
    }

    public Envelope getEnvelope() throws DataException {
        return this.envelope;
    }

    protected FeatureProvider internalGetFeatureProviderByReference(FeatureReferenceProviderServices reference) throws DataException {
        return (FeatureProvider)this.oids.get(reference.getOID());
    }

    public ResourceProvider getResource() {
        return this.memoryResource;
    }

    public boolean supportsAppendMode() {
        return true;
    }

    public void append(FeatureProvider featureProvider) throws DataException {
        FeatureProvider newFeatureProvider = featureProvider.getCopy();
        if (this.data.isEmpty()) {
            try {
                this.envelope = (Envelope)newFeatureProvider.getDefaultEnvelope().clone();
            }
            catch (CloneNotSupportedException e) {
                this.envelope = newFeatureProvider.getDefaultEnvelope();
            }
        } else {
            this.envelope.add(newFeatureProvider.getDefaultEnvelope());
        }
        newFeatureProvider.setNew(false);
        this.data.add(newFeatureProvider);
        this.oids.put(newFeatureProvider.getOID(), newFeatureProvider);
        logger.debug("Envelope after adding feature: ", (Object)this.envelope.toString());
    }

    public void beginAppend() throws DataException {
    }

    public void endAppend() throws DataException {
    }

    private class EditionVisitor
    implements Visitor {
        private List data;
        private Map oids;
        private Envelope envelope;
        private final FeatureStoreProviderServices services;

        public EditionVisitor(long size) {
            this.data = new ArrayList((int)size);
            this.oids = new HashMap((int)size);
            this.envelope = null;
            this.services = MemoryStoreProvider.this.getStoreServices();
        }

        public void visit(Object obj) throws VisitCanceledException, BaseException {
            Feature feature = (Feature)obj;
            FeatureProvider featureProvider = this.services.getFeatureProviderFromFeature(feature);
            featureProvider.setNew(false);
            this.data.add(featureProvider);
            this.oids.put(featureProvider.getOID(), featureProvider);
            Envelope aux = feature.getDefaultEnvelope();
            if (aux != null) {
                if (this.envelope == null) {
                    try {
                        this.envelope = (Envelope)aux.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        this.envelope = feature.getDefaultEnvelope();
                    }
                } else {
                    this.envelope.add(feature.getDefaultEnvelope());
                }
            }
        }

        public List getData() {
            return this.data;
        }

        public Map getOids() {
            return this.oids;
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }
    }
}

