/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.styling.editortools;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.gui.styling.EditorTool;
import org.gvsig.app.gui.styling.StyleEditor;
import org.gvsig.app.gui.styling.StylePreviewer;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.ILabelStyle;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.IStyle;
import org.gvsig.i18n.Messages;

public class LabelStyleNewTextFieldTool
extends EditorTool {
    private Point pIni;
    private Point pEnd;
    private final Cursor cursor = Cursor.getDefaultCursor();
    private ILabelStyle style;
    private JToggleButton btnNewTextArea;

    public LabelStyleNewTextFieldTool(JComponent targetEditor) {
        super(targetEditor);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void mousePressed(MouseEvent e) {
        this.pIni = e.getPoint();
        this.pEnd = e.getPoint();
        Rectangle2D rect = this.screenPointsToLabelRect(this.pIni, this.pEnd);
        this.style.addTextFieldArea(rect);
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        Dimension bounds = ((StyleEditor)this.owner).getStylePreviewer().getSize();
        this.pEnd = e.getPoint();
        if (this.pEnd.getX() < 0.0) {
            this.pEnd.x = 0;
        }
        if (this.pEnd.getX() > bounds.getWidth()) {
            this.pEnd.x = (int)bounds.getWidth();
        }
        if (this.pEnd.getY() < 0.0) {
            this.pEnd.y = 0;
        }
        if (this.pEnd.getY() > bounds.getHeight()) {
            this.pEnd.y = (int)bounds.getHeight();
        }
        Rectangle2D rect = this.screenPointsToLabelRect(this.pIni, this.pEnd);
        this.style.setTextFieldArea(this.style.getFieldCount() - 1, rect);
        this.owner.repaint();
    }

    private Rectangle2D screenPointsToLabelRect(Point pIni, Point pEnd) {
        Rectangle2D.Double rect;
        int minx = pIni.x;
        int miny = pIni.y;
        int width = pEnd.x - pIni.x;
        int height = pEnd.y - pIni.y;
        if (width < 0) {
            minx += width;
            width = -width;
        }
        if (height < 0) {
            miny += height;
            height = -height;
        }
        StylePreviewer sp = ((StyleEditor)this.owner).getStylePreviewer();
        Dimension bounds = sp.getSize();
        IStyle style = sp.getStyle();
        Dimension backgroundBounds = null;
        if (style instanceof ILabelStyle) {
            backgroundBounds = ((ILabelStyle)style).getSize();
        }
        if (backgroundBounds == null) {
            rect = new Rectangle2D.Double((double)minx / (bounds.getWidth() - (double)(sp.getHGap() / 2)), (double)miny / (bounds.getHeight() - (double)(sp.getVGap() / 2)), (double)width / (bounds.getWidth() - (double)sp.getHGap()), (double)height / (bounds.getHeight() - (double)sp.getVGap()));
        } else {
            double xOffset = 0.0;
            double yOffset = 0.0;
            double scale = 1.0;
            if (backgroundBounds.getWidth() > backgroundBounds.getHeight()) {
                scale = (bounds.getWidth() - (double)sp.getHGap()) / backgroundBounds.getWidth();
                yOffset = 0.5 * (bounds.getHeight() - (double)sp.getVGap() - backgroundBounds.getHeight() * scale);
            } else {
                scale = (bounds.getHeight() - (double)sp.getVGap()) / backgroundBounds.getHeight();
                xOffset = 0.5 * (bounds.getWidth() - (double)sp.getHGap() - backgroundBounds.getWidth() * scale);
            }
            rect = new Rectangle2D.Double(((double)(minx - sp.getHGap() / 2) - xOffset) / scale / backgroundBounds.getWidth(), ((double)(miny - sp.getVGap() / 2) - yOffset) / scale / backgroundBounds.getHeight(), (double)width / scale / backgroundBounds.getWidth(), (double)height / scale / backgroundBounds.getHeight());
        }
        return rect;
    }

    public AbstractButton getButton() {
        return this.getBtnNewTextArea();
    }

    public String getID() {
        return "2";
    }

    public boolean isSuitableFor(Object obj) {
        return obj instanceof ILabelStyle;
    }

    public void setModel(Object objectToBeEdited) {
        this.style = (ILabelStyle)objectToBeEdited;
    }

    private JToggleButton getBtnNewTextArea() {
        if (this.btnNewTextArea == null) {
            this.btnNewTextArea = new JToggleButton(IconThemeHelper.getImageIcon((String)"edit-add-text"));
            this.btnNewTextArea.setToolTipText(Messages.getText((String)"add_text_area"));
            this.btnNewTextArea.setSize(EditorTool.SMALL_BTN_SIZE);
        }
        return this.btnNewTextArea;
    }
}

