/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.lang;

import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.tools.evaluator.EvaluatorWithDescriptions;

public class EvaluatorCreator {
    private static final Map<String, EvaluatorWithDescriptions> EVALUATORS_CACHE = new LRUMap(100);

    public static EvaluatorWithDescriptions getEvaluator(String expr) {
        EvaluatorWithDescriptions resp = EVALUATORS_CACHE.get(expr);
        if (resp == null) {
            try {
                resp = (EvaluatorWithDescriptions)DALLocator.getDataManager().createFilter(expr);
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't create evaluator for '" + expr + "'.", ex);
            }
            EVALUATORS_CACHE.put(expr, resp);
        }
        return resp;
    }
}

