/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.placements;

import java.awt.Rectangle;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.labeling.placements.CannotPlaceLabel;
import org.gvsig.labeling.placements.ILabelPlacement;
import org.gvsig.labeling.placements.MarkerPlacementOnPoint;
import org.gvsig.labeling.placements.PointLabelPositioner;
import org.gvsig.labeling.placements.PointPlacementConstraints;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.LabelLocationMetrics;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerPlacementAroundPoint
implements ILabelPlacement {
    private static Logger logger = LoggerFactory.getLogger(MarkerPlacementAroundPoint.class);
    private static final MarkerPlacementOnPoint pos = new MarkerPlacementOnPoint();

    @Override
    public ArrayList<LabelLocationMetrics> guess(ILabelClass lc, Geometry geom, IPlacementConstraints placementConstraints, double cartographicSymbolSize, Cancellable cancel, ViewPort vp) {
        PointPlacementConstraints ppc;
        PointLabelPositioner plp;
        if (cancel.isCanceled()) {
            return CannotPlaceLabel.NO_PLACES;
        }
        Geometry shp = geom.cloneGeometry();
        shp.transform(vp.getAffineTransform());
        if (placementConstraints instanceof PointPlacementConstraints && (plp = (ppc = (PointPlacementConstraints)placementConstraints).getPositioner()) != null) {
            int j;
            Point po_screen = null;
            try {
                po_screen = shp.centroid();
            }
            catch (Exception exc) {
                logger.error("While getting centroid.", (Throwable)exc);
            }
            int[] preferredPositions = plp.getPreferenceVector();
            ArrayList<LabelLocationMetrics> highPreference = new ArrayList<LabelLocationMetrics>();
            ArrayList<LabelLocationMetrics> normalPreference = new ArrayList<LabelLocationMetrics>();
            ArrayList<LabelLocationMetrics> lowPreference = new ArrayList<LabelLocationMetrics>();
            Rectangle bounds = lc.getBounds();
            double width = bounds.getWidth() * 0.5;
            double heigth = bounds.getHeight() * 0.5;
            double offsetX = 0.0;
            double offsetY = 0.0;
            block18: for (int i = 0; i < preferredPositions.length; ++i) {
                Point po_aux = po_screen.cloneGeometry();
                switch (i) {
                    case 0: 
                    case 3: 
                    case 5: {
                        offsetX = -width;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: {
                        offsetX = width;
                        break;
                    }
                    default: {
                        offsetX = 0.0;
                    }
                }
                switch (i) {
                    case 0: 
                    case 1: 
                    case 2: {
                        offsetY = -heigth;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        offsetY = heigth;
                        break;
                    }
                    default: {
                        offsetY = 0.0;
                    }
                }
                po_aux.setX(po_aux.getX() + offsetX);
                po_aux.setY(po_aux.getY() + offsetY);
                try {
                    po_aux.transform(vp.getAffineTransform().createInverse());
                }
                catch (NoninvertibleTransformException e) {
                    logger.error("uninvertible matrix.", (Throwable)e);
                }
                switch (preferredPositions[i]) {
                    case 0: {
                        continue block18;
                    }
                    case 1: {
                        highPreference.addAll(pos.guess(lc, (Geometry)po_aux, placementConstraints, cartographicSymbolSize, cancel, vp));
                        continue block18;
                    }
                    case 2: {
                        normalPreference.addAll(pos.guess(lc, (Geometry)po_aux, placementConstraints, cartographicSymbolSize, cancel, vp));
                        continue block18;
                    }
                    case 3: {
                        lowPreference.addAll(pos.guess(lc, (Geometry)po_aux, placementConstraints, cartographicSymbolSize, cancel, vp));
                        continue block18;
                    }
                    default: {
                        throw new Error("unrecognised label position preference value: " + preferredPositions[i]);
                    }
                }
            }
            ArrayList<LabelLocationMetrics> guessed = new ArrayList<LabelLocationMetrics>();
            for (j = 0; j < highPreference.size(); ++j) {
                guessed.add((LabelLocationMetrics)highPreference.get(j));
            }
            for (j = 0; j < normalPreference.size(); ++j) {
                guessed.add((LabelLocationMetrics)normalPreference.get(j));
            }
            for (j = 0; j < lowPreference.size(); ++j) {
                guessed.add((LabelLocationMetrics)lowPreference.get(j));
            }
            return guessed;
        }
        return CannotPlaceLabel.NO_PLACES;
    }

    @Override
    public boolean isSuitableFor(IPlacementConstraints placementConstraints, int shapeType) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        if (geomManager.isSubtype(1, shapeType) || geomManager.isSubtype(7, shapeType)) {
            return placementConstraints != null && placementConstraints.isAroundThePoint();
        }
        return false;
    }
}

