/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wcs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.lang.StringUtils;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.remoteclient.exceptions.ServerErrorException;
import org.gvsig.remoteclient.exceptions.WCSException;
import org.gvsig.remoteclient.ogc.OGCProtocolHandler;
import org.gvsig.remoteclient.ogc.OGCServiceInformation;
import org.gvsig.remoteclient.utils.Utilities;
import org.gvsig.remoteclient.wcs.WCSServiceInformation;
import org.gvsig.remoteclient.wcs.WCSStatus;
import org.gvsig.remoteclient.wcs.request.WCSDescribeCoverageRequest;
import org.gvsig.remoteclient.wcs.request.WCSGetCoverageRequest;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class WCSProtocolHandler
extends OGCProtocolHandler {
    protected String encoding = "UTF-8";
    protected Hashtable layerPool = new Hashtable();
    protected WCSServiceInformation serviceInfo = new WCSServiceInformation();
    private static final StringUtils stringUtils = CompatLocator.getStringUtils();

    public void setHost(String host) {
        try {
            new URL(host);
            int index = host.indexOf("?");
            if (index == -1) {
                super.setHost(host);
            } else {
                super.setHost(host.substring(0, index));
            }
        }
        catch (MalformedURLException m) {
            super.setHost(host);
        }
    }

    public void getCapabilities(WCSStatus status, boolean override, ICancellable cancel) {
        URL request = null;
        try {
            request = new URL(this.buildCapabilitiesRequest(status));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            File f;
            if (override) {
                downloader.removeURL(request);
            }
            if ((f = downloader.downloadFile(request, "wcs_capabilities.xml", cancel)) != null) {
                this.parseCapabilities(f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String buildCapabilitiesRequest(WCSStatus status) {
        StringBuffer req = new StringBuffer();
        String symbol = null;
        String onlineResource = status == null || status.getOnlineResource() == null ? this.getHost() : status.getOnlineResource();
        symbol = WCSProtocolHandler.getSymbol((String)onlineResource);
        req.append(onlineResource).append(symbol).append("REQUEST=GetCapabilities&SERVICE=WCS&");
        req.append("VERSION=").append(this.getVersion()).append("&EXCEPTIONS=XML");
        return req.toString();
    }

    public abstract boolean parseDescribeCoverage(File var1);

    public void describeCoverage(WCSStatus status, boolean override, ICancellable cancel) {
        try {
            WCSDescribeCoverageRequest request = this.createDescribeCoverageRequest(status);
            File f = request.sendRequest(cancel);
            if (f != null) {
                this.parseDescribeCoverage(f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File getCoverage(WCSStatus status, ICancellable cancel) throws ServerErrorException, WCSException {
        try {
            WCSGetCoverageRequest request = this.createGetCoverageRequest(status);
            File f = request.sendRequest(cancel);
            if (f != null && Utilities.isTextFile((File)f)) {
                byte[] data = this.fileToBytes(f);
                WCSException wcsEx = null;
                String exceptionMessage = this.parseException(data);
                if (exceptionMessage == null) {
                    String error = new String(data);
                    int pos = error.indexOf("<?xml");
                    if (pos != -1) {
                        String xml = error.substring(pos, error.length());
                        exceptionMessage = this.parseException(xml.getBytes());
                    }
                    if (exceptionMessage == null) {
                        exceptionMessage = new String(data);
                    }
                }
                wcsEx = new WCSException(exceptionMessage);
                wcsEx.setWCSMessage(new String(data));
                downloader.removeURL((Object)request);
                throw wcsEx;
            }
            return f;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServerErrorException();
        }
    }

    public URL getCoverageURL(WCSStatus status, ICancellable cancel) throws ServerErrorException {
        try {
            WCSGetCoverageRequest request = this.createGetCoverageRequest(status);
            return request.getURL();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServerErrorException();
        }
    }

    public String getExceptionMessage(File f) throws IOException {
        if (f == null) {
            return null;
        }
        if (Utilities.isTextFile((File)f)) {
            byte[] data = this.fileToBytes(f);
            String exceptionMessage = this.parseException(data);
            if (exceptionMessage == null) {
                String error = new String(data);
                int pos = error.indexOf("<?xml");
                if (pos != -1) {
                    String xml = error.substring(pos, error.length());
                    exceptionMessage = this.parseException(xml.getBytes());
                }
                if (exceptionMessage == null) {
                    exceptionMessage = new String(data);
                }
            }
            return exceptionMessage;
        }
        return null;
    }

    private String parseException(byte[] data) {
        ArrayList<String> errors = new ArrayList<String>();
        KXmlParser kxmlParser = new KXmlParser();
        boolean end = false;
        try {
            kxmlParser.setInput((InputStream)new ByteArrayInputStream(data), this.encoding);
            kxmlParser.nextTag();
            if (kxmlParser.getEventType() != 1) {
                kxmlParser.require(2, null, "ServiceExceptionReport");
                int tag = kxmlParser.nextTag();
                while (!end) {
                    switch (tag) {
                        case 2: {
                            if (kxmlParser.getName().compareTo("ServiceException") != 0) break;
                            String errorCode = kxmlParser.getAttributeValue("", "code");
                            errorCode = errorCode != null ? "[" + errorCode + "] " : "";
                            String errorMessage = kxmlParser.nextText();
                            errors.add(errorCode + errorMessage);
                            break;
                        }
                        case 3: {
                            if (kxmlParser.getName().compareTo("ServiceException") != 0 && kxmlParser.getName().compareTo("ServiceExceptionReport") != 0) break;
                            end = true;
                        }
                    }
                    if (end) continue;
                    tag = kxmlParser.nextTag();
                }
            }
        }
        catch (XmlPullParserException parser_ex) {
            parser_ex.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        String message = errors.size() > 0 ? "" : null;
        for (int i = 0; i < errors.size(); ++i) {
            message = message + (String)errors.get(i) + "\n";
        }
        return message;
    }

    public static String buildCapabilitiesSuitableVersionRequest(String _host, String _version) {
        int index = _host.indexOf(63);
        if (index > -1) {
            String host = _host.substring(0, index + 1);
            String query = _host.substring(index + 1, _host.length());
            StringTokenizer tokens = new StringTokenizer(query, "&");
            String newQuery = "";
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (token.toUpperCase().compareTo("REQUEST=GETCAPABILITIES") == 0 || token.toUpperCase().compareTo("SERVICE=WCS") == 0 || _version != null && _version.length() > 0 && token.toUpperCase().compareTo("VERSION=" + _version) == 0 || token.toUpperCase().compareTo("EXCEPTIONS=XML") == 0) continue;
                newQuery = newQuery + token + "&";
            }
            _host = host + newQuery;
        } else {
            _host = _host + "?";
        }
        _host = _version != null && _version.compareTo("") != 0 ? _host + "REQUEST=GetCapabilities&SERVICE=WCS&VERSION=" + _version + "&EXCEPTIONS=XML" : _host + "REQUEST=GetCapabilities&SERVICE=WCS&EXCEPTIONS=XML";
        return stringUtils.replaceAll(_host, " ", "%20");
    }

    public ArrayList getFormats() {
        return new ArrayList(this.serviceInfo.formats);
    }

    public Hashtable getLayers() {
        return this.layerPool;
    }

    public abstract WCSDescribeCoverageRequest createDescribeCoverageRequest(WCSStatus var1);

    public abstract WCSGetCoverageRequest createGetCoverageRequest(WCSStatus var1);

    public OGCServiceInformation getServiceInformation() {
        return this.serviceInfo;
    }
}

