/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wcs.wcs_1_0_0;

import java.io.File;
import java.io.IOException;
import org.gvsig.remoteclient.utils.EncodingXMLParser;
import org.gvsig.remoteclient.wcs.CoverageOfferingBrief;
import org.gvsig.remoteclient.wcs.WCSProtocolHandler;
import org.gvsig.remoteclient.wcs.WCSStatus;
import org.gvsig.remoteclient.wcs.request.WCSDescribeCoverageRequest;
import org.gvsig.remoteclient.wcs.request.WCSGetCoverageRequest;
import org.gvsig.remoteclient.wcs.wcs_1_0_0.WCSCoverage1_0_0;
import org.gvsig.remoteclient.wcs.wcs_1_0_0.request.WCSDescribeCoverageRequest1_0_0;
import org.gvsig.remoteclient.wcs.wcs_1_0_0.request.WCSGetCoverageRequest1_0_0;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class WCSProtocolHandler1_0_0
extends WCSProtocolHandler {
    public WCSProtocolHandler1_0_0() {
        this.version = "1.0.0";
        this.name = "WCS1.0.0";
    }

    public boolean parseCapabilities(File f) {
        EncodingXMLParser parser = null;
        parser = new EncodingXMLParser();
        try {
            parser.setInput(f);
            parser.nextTag();
            if (parser.getEventType() != 1) {
                parser.require(2, null, "WCS_Capabilities");
                int tag = parser.nextTag();
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName().compareTo("Service") == 0) {
                                this.parseServiceTag((KXmlParser)parser);
                                break;
                            }
                            if (parser.getName().compareTo("Capability") == 0) {
                                this.parseCapabilityTag((KXmlParser)parser);
                                break;
                            }
                            if (parser.getName().compareTo("ContentMetadata") != 0) break;
                            this.parseContentMetadataTag((KXmlParser)parser);
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            if (parser.getName() == null) break;
                            System.out.println("[TEXT][" + parser.getText().trim() + "]");
                        }
                    }
                    tag = parser.next();
                }
                parser.require(1, null, null);
            }
        }
        catch (XmlPullParserException parser_ex) {
            System.out.println(parser_ex.getMessage());
            parser_ex.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean parseDescribeCoverage(File f) {
        EncodingXMLParser parser = null;
        parser = new EncodingXMLParser();
        try {
            parser.setInput(f);
            parser.nextTag();
            if (parser.getEventType() != 1) {
                parser.require(2, null, "CoverageDescription");
                int tag = parser.nextTag();
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName().compareTo("CoverageOffering") != 0) break;
                            WCSCoverage1_0_0 lyr = new WCSCoverage1_0_0();
                            lyr.parse((KXmlParser)parser);
                            if (lyr == null) break;
                            this.layerPool.put(lyr.getName(), lyr);
                        }
                    }
                    tag = parser.next();
                }
                parser.require(1, null, null);
            }
        }
        catch (XmlPullParserException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    private void parseCapabilityTag(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "Capability");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("Request") == 0) {
                        this.parseRequestTag(parser);
                        break;
                    }
                    if (parser.getName().compareTo("Exception") == 0) {
                        parser.skipSubTree();
                        break;
                    }
                    if (parser.getName().compareTo("VendorSpecificCapabilities") != 0 && parser.getName().compareTo("UserDefinedSymbolization") != 0) break;
                    parser.skipSubTree();
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Capability") != 0) break;
                    end = true;
                    break;
                }
            }
            currentTag = parser.next();
        }
    }

    private void parseServiceTag(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "Service");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareToIgnoreCase("Name") == 0) {
                        this.serviceInfo.name = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("label") == 0) {
                        this.serviceInfo.title = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("description") == 0) {
                        this.serviceInfo.abstr = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("keywords") == 0) {
                        parser.skipSubTree();
                        break;
                    }
                    if (parser.getName().compareTo("AccessConstraints") == 0) {
                        parser.skipSubTree();
                        break;
                    }
                    if (parser.getName().compareTo("Fees") != 0) break;
                    parser.skipSubTree();
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Service") != 0) break;
                    end = true;
                    break;
                }
            }
            currentTag = parser.next();
        }
    }

    private void parseRequestTag(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "Request");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    String value;
                    if (parser.getName().compareTo("GetCapabilities") == 0) {
                        currentTag = parser.nextTag();
                        parser.require(2, null, "DCPType");
                        currentTag = parser.nextTag();
                        if (parser.getName().compareTo("HTTP") != 0) break;
                        currentTag = parser.nextTag();
                        if (parser.getName().compareTo("Get") != 0) break;
                        currentTag = parser.nextTag();
                        if (parser.getName().compareTo("OnlineResource") != 0) break;
                        value = new String();
                        value = parser.getAttributeValue("", "xlink:href");
                        if (value == null) break;
                        this.serviceInfo.operations.put(value, null);
                        break;
                    }
                    if (parser.getName().compareTo("DescribeCoverage") == 0) {
                        currentTag = parser.nextTag();
                        parser.require(2, null, "DCPType");
                        currentTag = parser.nextTag();
                        if (parser.getName().compareTo("HTTP") != 0) break;
                        currentTag = parser.nextTag();
                        if (parser.getName().compareTo("Get") != 0) break;
                        currentTag = parser.nextTag();
                        if (parser.getName().compareTo("OnlineResource") != 0) break;
                        value = new String();
                        value = parser.getAttributeValue("", "xlink:href");
                        if (value == null) break;
                        this.serviceInfo.operations.put(value, null);
                        break;
                    }
                    if (parser.getName().compareTo("GetCoverage") != 0) break;
                    currentTag = parser.nextTag();
                    parser.require(2, null, "DCPType");
                    currentTag = parser.nextTag();
                    if (parser.getName().compareTo("HTTP") != 0) break;
                    currentTag = parser.nextTag();
                    if (parser.getName().compareTo("Get") != 0) break;
                    currentTag = parser.nextTag();
                    if (parser.getName().compareTo("OnlineResource") != 0) break;
                    value = new String();
                    value = parser.getAttributeValue("", "xlink:href");
                    if (value == null) break;
                    this.serviceInfo.operations.put(value, null);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Request") != 0) break;
                    end = true;
                    break;
                }
            }
            currentTag = parser.next();
        }
    }

    private void parseContentMetadataTag(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        parser.require(2, null, "ContentMetadata");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("wcs:CoverageOfferingBrief") != 0) break;
                    CoverageOfferingBrief cob = new CoverageOfferingBrief();
                    cob.parse(parser);
                    this.layerPool.put(cob.getName(), cob);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("ContentMetadata") != 0) break;
                    end = true;
                    break;
                }
            }
            currentTag = parser.next();
        }
    }

    @Override
    public WCSDescribeCoverageRequest createDescribeCoverageRequest(WCSStatus status) {
        return new WCSDescribeCoverageRequest1_0_0(status, this);
    }

    @Override
    public WCSGetCoverageRequest createGetCoverageRequest(WCSStatus status) {
        return new WCSGetCoverageRequest1_0_0(status, this);
    }
}

