/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.costInRoutesAnisotropicB;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.FixedTableModel;
import es.unex.sextante.rasterWrappers.GridCell;
import es.unex.sextante.shapesTools.ShapesTools;

public class CostInRoutesAnisotropicBAlgorithm
extends GeoAlgorithm {
    public static final String ROUTES = "ROUTES";
    public static final String COST = "COST";
    public static final String COSTDIR = "COSTDIR";
    public static final String RESULT = "RESULT";
    public static final String FACTORS = "FACTORS";
    private static final double[][] ANGLES = new double[][]{{135.0, 180.0, 225.0}, {90.0, 0.0, 270.0}, {45.0, 0.0, 315.0}};
    private static final double NO_DATA = -99999.0;
    private IRasterLayer m_Cost;
    private double[] m_dDist;
    private double[] m_dCost;
    private int m_iLastX;
    private int m_iLastY;
    private int m_iPoints = 0;
    private int m_iCurrentRoute;
    private IRasterLayer m_CostDir;
    private DeviationAndFactor[] m_Factors;

    public void defineCharacteristics() {
        String[] sColumnNames = new String[]{Sextante.getText((String)"Difference"), Sextante.getText((String)"Factor")};
        this.setName(Sextante.getText((String)"Cost_for_predefined_routes__anisotropic") + "(B)");
        this.setGroup(Sextante.getText((String)"Cost_distances_and_routes"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(ROUTES, Sextante.getText((String)"Routes"), 1, true);
            this.m_Parameters.addInputRasterLayer(COST, Sextante.getText((String)"Maximum_unitary_cost"), true);
            this.m_Parameters.addInputRasterLayer(COSTDIR, Sextante.getText((String)"Direction_of_maximum_cost_[degrees]"), true);
            this.m_Parameters.addFixedTable(FACTORS, Sextante.getText((String)"Cost_variation_factors"), sColumnNames, 5, false);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Routes_and_cost"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Cost = this.m_Parameters.getParameterValueAsRasterLayer(COST);
        this.m_CostDir = this.m_Parameters.getParameterValueAsRasterLayer(COSTDIR);
        FixedTableModel factors = (FixedTableModel)this.m_Parameters.getParameterValueAsObject(FACTORS);
        this.m_Factors = new DeviationAndFactor[factors.getRowCount()];
        for (int i = 0; i < factors.getRowCount(); ++i) {
            double dDeviation = Double.parseDouble(factors.getValueAt(i, 0).toString());
            double dFactor = Double.parseDouble(factors.getValueAt(i, 1).toString());
            this.m_Factors[i] = new DeviationAndFactor(dDeviation, dFactor);
        }
        this.m_Cost.setFullExtent();
        this.m_CostDir.setWindowExtent(this.m_Cost.getWindowGridExtent());
        IVectorLayer routes = this.m_Parameters.getParameterValueAsVectorLayer(ROUTES);
        if (routes.getShapesCount() == 0) {
            return false;
        }
        int iShapesCount = routes.getShapesCount();
        this.m_iCurrentRoute = 0;
        this.m_Cost.setFullExtent();
        this.m_dCost = new double[routes.getShapesCount()];
        this.m_dDist = new double[routes.getShapesCount()];
        IFeatureIterator iter = routes.iterator();
        while (iter.hasNext() && this.setProgress(this.m_iCurrentRoute, iShapesCount)) {
            this.m_iPoints = 0;
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            this.processLine(geom.getCoordinates());
            ++this.m_iCurrentRoute;
        }
        iter.close();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        Object[][] values = new Object[2][routes.getShapesCount()];
        String[] sFields = new String[]{Sextante.getText((String)"Distance"), Sextante.getText((String)"Cost")};
        Class[] types = new Class[]{Double.class, Double.class};
        for (int i = 0; i < routes.getShapesCount(); ++i) {
            values[0][i] = new Double(this.m_dDist[i]);
            values[1][i] = new Double(this.m_dCost[i]);
        }
        IOutputChannel channel = this.getOutputChannel(RESULT);
        OutputVectorLayer out = new OutputVectorLayer();
        out.setName(RESULT);
        out.setDescription(Sextante.getText((String)"Routes"));
        out.setOutputChannel(channel);
        out.setOutputObject((Object)ShapesTools.addFields((OutputFactory)this.m_OutputFactory, (IVectorLayer)routes, (IOutputChannel)channel, (String[])sFields, (Object[][])values, (Class[])types));
        this.addOutputObject((Output)out);
        return true;
    }

    private void processLine(Coordinate[] coords) {
        for (int i = 0; i < coords.length - 1; ++i) {
            double x = coords[i].x;
            double y = coords[i].y;
            double x2 = coords[i + 1].x;
            double y2 = coords[i + 1].y;
            this.processSegment(x, y, x2, y2);
        }
    }

    private void processSegment(double x, double y, double x2, double y2) {
        double dx = Math.abs(x2 - x);
        double dy = Math.abs(y2 - y);
        if (dx > 0.0 || dy > 0.0) {
            double n;
            if (dx > dy) {
                n = dx /= this.m_Cost.getWindowCellSize();
                dy /= dx;
                dx = this.m_Cost.getWindowCellSize();
            } else {
                n = dy /= this.m_Cost.getWindowCellSize();
                dx /= dy;
                dy = this.m_Cost.getWindowCellSize();
            }
            if (x2 < x) {
                dx = -dx;
            }
            if (y2 < y) {
                dy = -dy;
            }
            double d = 0.0;
            while (d <= n) {
                this.addPoint(x, y);
                d += 1.0;
                x += dx;
                y += dy;
            }
        }
    }

    private void addPoint(double x, double y) {
        GridCell cell = this.m_Cost.getWindowGridExtent().getGridCoordsFromWorldCoords(x, y);
        int iX = cell.getX();
        int iY = cell.getY();
        if (this.m_iPoints == 0) {
            this.m_dDist[this.m_iCurrentRoute] = 0.0;
            this.m_dCost[this.m_iCurrentRoute] = 0.0;
            this.m_iLastX = cell.getX();
            this.m_iLastY = cell.getY();
        } else {
            int iDX = iX - this.m_iLastX;
            int iDY = iY - this.m_iLastY;
            int n = this.m_iCurrentRoute;
            this.m_dDist[n] = this.m_dDist[n] + Math.sqrt(iDX * iDX + iDY * iDY) * this.m_Cost.getWindowCellSize();
            double dCost = this.getCostInDir(this.m_iLastX, this.m_iLastY, iDX, iDY);
            if (dCost != -99999.0) {
                int n2 = this.m_iCurrentRoute;
                this.m_dCost[n2] = this.m_dCost[n2] + dCost;
            }
            this.m_iLastX = iX;
            this.m_iLastY = iY;
        }
        this.m_iLastX = iX;
        this.m_iLastY = iY;
        ++this.m_iPoints;
    }

    private double getCostInDir(int x, int y, int iH, int iV) {
        double dAngle = ANGLES[iV + 1][iH + 1];
        int x2 = x + iH;
        int y2 = y + iV;
        double dCostDir1 = this.m_CostDir.getCellValueAsDouble(x, y);
        double dCostDir2 = this.m_CostDir.getCellValueAsDouble(x2, y2);
        double dCost1 = this.m_Cost.getCellValueAsDouble(x, y);
        double dCost2 = this.m_Cost.getCellValueAsDouble(x2, y2);
        if (this.m_Cost.isNoDataValue(dCost1) || this.m_Cost.isNoDataValue(dCost1) || this.m_CostDir.isNoDataValue(dCostDir1) || this.m_CostDir.isNoDataValue(dCostDir1)) {
            return -99999.0;
        }
        double dDifAngle1 = Math.abs(dCostDir1 - dAngle);
        double dDifAngle2 = Math.abs(dCostDir2 - dAngle);
        dCost1 = this.getWeigthedCost(dCost1, dDifAngle1);
        dCost2 = this.getWeigthedCost(dCost2, dDifAngle2);
        return dCost1 + dCost2;
    }

    private double getWeigthedCost(double cost, double difAngle) {
        for (int i = 0; i < this.m_Factors.length - 1; ++i) {
            if (!(this.m_Factors[i].deviation < difAngle) && !(this.m_Factors[i + 1].deviation >= difAngle)) continue;
            return this.m_Factors[i].factor * cost / 2.0;
        }
        return cost / 2.0;
    }

    private class DeviationAndFactor
    implements Comparable {
        public double factor;
        public double deviation;

        DeviationAndFactor(double dDeviation, double dFactor) {
            this.deviation = dDeviation;
            this.factor = dFactor;
        }

        public int compareTo(Object ob) throws ClassCastException {
            if (!(ob instanceof DeviationAndFactor)) {
                throw new ClassCastException();
            }
            double dDeviation = ((DeviationAndFactor)ob).deviation;
            double dDif = this.deviation - dDeviation;
            if (dDif > 0.0) {
                return 1;
            }
            if (dDif < 0.0) {
                return -1;
            }
            return 0;
        }
    }
}

