/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.supervisedClassificationB;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.parameters.RasterLayerAndBand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class SupervisedClassificationBAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String METHOD = "METHOD";
    public static final String CLASSIFICATION = "CLASSIFICATION";
    public static final String CLASSES = "CLASSES";
    public static final String TABLE = "TABLE";
    public static final int METHOD_PARALELLPIPED = 0;
    public static final int METHOD_MIN_DISTANCE = 1;
    public static final int METHOD_MAX_LIKELIHOOD = 2;
    private IRasterLayer[] m_Window;
    private IRasterLayer m_Output;
    private ArrayList m_Bands;
    private HashMap m_Classes;
    private int[] m_iBands;

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Parallelepiped"), Sextante.getText((String)"Minimum_distance"), Sextante.getText((String)"Maximum_likelihood")};
        this.setName(Sextante.getText((String)"Supervised_classification") + "(B)");
        this.setGroup(Sextante.getText((String)"Raster_layer_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addMultipleInput(INPUT, Sextante.getText((String)"Bands"), 7, true);
            this.m_Parameters.addInputTable(TABLE, Sextante.getText((String)"Classes"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.addOutputRasterLayer(CLASSIFICATION, Sextante.getText((String)"Classification"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_Bands = this.m_Parameters.getParameterValueAsArrayList(INPUT);
        if (this.m_Bands.size() == 0) {
            return false;
        }
        this.m_Classes = new HashMap();
        this.getClassInformation();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        this.m_Output = this.getNewRasterLayer(CLASSIFICATION, Sextante.getText((String)"Classification"), 2);
        this.m_Output.setNoDataValue(-1.0);
        AnalysisExtent ge = this.m_Output.getWindowGridExtent();
        this.m_Window = new IRasterLayer[this.m_Bands.size()];
        this.m_iBands = new int[this.m_Bands.size()];
        for (int i = 0; i < this.m_Window.length; ++i) {
            RasterLayerAndBand band = (RasterLayerAndBand)this.m_Bands.get(i);
            this.m_iBands[i] = band.getBand();
            this.m_Window[i] = band.getRasterLayer();
            this.m_Window[i].setWindowExtent(ge);
        }
        switch (iMethod) {
            case 0: {
                this.doParalellpiped();
            }
            default: {
                this.doMinimumDistance();
            }
            case 2: 
        }
        this.doMaximumLikelihood();
        return !this.m_Task.isCanceled();
    }

    private void getClassInformation() throws GeoAlgorithmExecutionException {
        try {
            ITable table = this.m_Parameters.getParameterValueAsTable(TABLE);
            this.m_Window = new IRasterLayer[this.m_Bands.size()];
            for (IRecord record : table) {
                String sClassName = record.getValue(0).toString();
                ArrayList<MeanAndStdDev> stats = new ArrayList<MeanAndStdDev>();
                for (int i = 0; i < this.m_Window.length; ++i) {
                    String sFieldName = this.m_Window[i].getName() + "|" + Integer.toString(this.m_iBands[i] + 1);
                    MeanAndStdDev masd = new MeanAndStdDev();
                    boolean bMatchFound = false;
                    for (int j = 1; j < table.getFieldCount(); j += 2) {
                        if (!table.getFieldName(j).equals(sFieldName)) continue;
                        masd.mean = Double.parseDouble(record.getValue(j).toString());
                        masd.stdDev = Double.parseDouble(record.getValue(j + 1).toString());
                        bMatchFound = true;
                    }
                    if (!bMatchFound) {
                        throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Error_reading_table"));
                    }
                    stats.add(masd);
                }
                this.m_Classes.put(sClassName, stats);
            }
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Error_reading_table"));
        }
    }

    private void doParalellpiped() {
        int iGrid;
        int iMatchingClass = 0;
        double[][] dMean = new double[this.m_Classes.size()][this.m_Window.length];
        double[][] dStdDev = new double[this.m_Classes.size()][this.m_Window.length];
        int iNX = this.m_Output.getWindowGridExtent().getNX();
        int iNY = this.m_Output.getWindowGridExtent().getNY();
        Set set = this.m_Classes.keySet();
        Iterator iter = set.iterator();
        int iClass = 0;
        while (iter.hasNext()) {
            ArrayList stats = (ArrayList)this.m_Classes.get(iter.next());
            for (iGrid = 0; iGrid < this.m_Window.length; ++iGrid) {
                MeanAndStdDev substats = (MeanAndStdDev)stats.get(iGrid);
                dMean[iClass][iGrid] = substats.mean;
                dStdDev[iClass][iGrid] = substats.stdDev;
            }
            ++iClass;
        }
        for (int y = 0; y < iNY; ++y) {
            for (int x = 0; x < iNX; ++x) {
                for (iClass = 0; iClass < this.m_Classes.size(); ++iClass) {
                    double dValue;
                    iMatchingClass = iClass;
                    for (iGrid = 0; iGrid < this.m_Window.length && !this.m_Window[iGrid].isNoDataValue(dValue = this.m_Window[iGrid].getCellValueAsDouble(x, y)); ++iGrid) {
                        if (!(Math.abs(this.m_Window[iGrid].getCellValueAsDouble(x, y) - dMean[iClass][iGrid]) > dStdDev[iClass][iGrid])) continue;
                        iMatchingClass = -1;
                        break;
                    }
                    if (iMatchingClass != -1) break;
                }
                if (iMatchingClass != -1) {
                    this.m_Output.setCellValue(x, y, (double)(iMatchingClass + 1));
                    continue;
                }
                this.m_Output.setNoData(x, y);
            }
        }
    }

    private void doMinimumDistance() {
        int iGrid;
        int iMin = 0;
        double[][] dMean = new double[this.m_Classes.size()][this.m_Window.length];
        int iNX = this.m_Output.getWindowGridExtent().getNX();
        int iNY = this.m_Output.getWindowGridExtent().getNY();
        Set set = this.m_Classes.keySet();
        Iterator iter = set.iterator();
        int iClass = 0;
        while (iter.hasNext()) {
            ArrayList stats = (ArrayList)this.m_Classes.get(iter.next());
            for (iGrid = 0; iGrid < this.m_Window.length; ++iGrid) {
                dMean[iClass][iGrid] = ((MeanAndStdDev)stats.get((int)iGrid)).mean;
            }
            ++iClass;
        }
        for (int y = 0; y < iNY; ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dMin = -1.0;
                for (iClass = 0; iClass < this.m_Classes.size(); ++iClass) {
                    double d = 0.0;
                    for (iGrid = 0; iGrid < this.m_Window.length; ++iGrid) {
                        double dValue = this.m_Window[iGrid].getCellValueAsDouble(x, y);
                        if (!this.m_Window[iGrid].isNoDataValue(dValue)) {
                            double e = this.m_Window[iGrid].getCellValueAsDouble(x, y) - dMean[iClass][iGrid];
                            d += e * e;
                            if (!(dMin < 0.0) && !(dMin > d)) continue;
                            dMin = d;
                            iMin = iClass;
                            continue;
                        }
                        dMin = -1.0;
                    }
                }
                if (dMin >= 0.0) {
                    this.m_Output.setCellValue(x, y, (double)(iMin + 1));
                    continue;
                }
                this.m_Output.setNoData(x, y);
            }
        }
    }

    private void doMaximumLikelihood() {
        int iGrid;
        int iMax = 0;
        double[][] dMean = new double[this.m_Classes.size()][this.m_Window.length];
        double[][] dStdDev = new double[this.m_Classes.size()][this.m_Window.length];
        double[][] dK = new double[this.m_Classes.size()][this.m_Window.length];
        int iNX = this.m_Output.getWindowGridExtent().getNX();
        int iNY = this.m_Output.getWindowGridExtent().getNY();
        Set set = this.m_Classes.keySet();
        Iterator iter = set.iterator();
        int iClass = 0;
        while (iter.hasNext()) {
            ArrayList stats = (ArrayList)this.m_Classes.get(iter.next());
            for (iGrid = 0; iGrid < this.m_Window.length; ++iGrid) {
                MeanAndStdDev substats = (MeanAndStdDev)stats.get(iGrid);
                dMean[iClass][iGrid] = substats.mean;
                dStdDev[iClass][iGrid] = substats.stdDev;
                dK[iClass][iGrid] = 1.0 / (dStdDev[iClass][iGrid] * Math.sqrt(Math.PI * 2));
            }
            ++iClass;
        }
        for (int y = 0; y < iNY; ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dMax = 0.0;
                for (iClass = 0; iClass < this.m_Classes.size(); ++iClass) {
                    double d = 0.0;
                    for (iGrid = 0; iGrid < this.m_Window.length; ++iGrid) {
                        double dValue = this.m_Window[iGrid].getCellValueAsDouble(x, y);
                        if (!this.m_Window[iGrid].isNoDataValue(dValue)) {
                            double e = (this.m_Window[iGrid].getCellValueAsDouble(x, y) - dMean[iClass][iGrid]) / dStdDev[iClass][iGrid];
                            if (!(dMax < (d += (e = dK[iClass][iGrid] * Math.exp(-0.5 * e * e)) * e))) continue;
                            dMax = d;
                            iMax = iClass;
                            continue;
                        }
                        dMax = -1.0;
                    }
                }
                if (dMax > 0.0) {
                    this.m_Output.setCellValue(x, y, (double)(iMax + 1));
                    continue;
                }
                this.m_Output.setNoData(x, y);
            }
        }
    }

    private class MeanAndStdDev {
        public double mean = 0.0;
        public double stdDev = 0.0;

        private MeanAndStdDev() {
        }
    }
}

