/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCalculus.gridCalculator;

import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.WrongOutputIDException;
import es.unex.sextante.gridCalculus.gridCalculator.CalculatorKeysPanel;
import es.unex.sextante.gridCalculus.gridCalculator.FormulaParser;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.modeler.GeoAlgorithmModelerParametersPanel;
import es.unex.sextante.gui.modeler.OutputLayerSettingsPanel;
import es.unex.sextante.modeler.elements.ModelElementNumericalValue;
import es.unex.sextante.modeler.elements.ModelElementRasterLayer;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.parameters.Parameter;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class GridCalculatorModelerParametersPanel
extends GeoAlgorithmModelerParametersPanel {
    private static final int MAX_BANDS = 3;
    private JTextArea jTextExpression;
    private JScrollPane jScrollPane;
    private JTree jTree;
    private JScrollPane jScrollPane1;
    private CalculatorKeysPanel m_KeysPanel;
    private HashMap m_Constants;
    private OutputLayerSettingsPanel m_OutputLayerSettingsPanel;

    protected void initGUI() {
        this.setPreferredSize(new Dimension(570, 350));
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{10.0, -1.0, -1.0, -1.0, -1.0, 10.0}, {10.0, -1.0, -1.0, -1.0, 50.0, 5.0, 50.0, 5.0, 10.0}});
        thisLayout.setHGap(10);
        thisLayout.setVGap(10);
        this.setLayout((LayoutManager)thisLayout);
        this.setSize(new Dimension(350, 350));
        this.jScrollPane = new JScrollPane();
        this.add(this.jScrollPane, "1, 4, 4, 4");
        this.jScrollPane.setHorizontalScrollBarPolicy(31);
        this.jTextExpression = new JTextArea();
        this.jScrollPane.setViewportView(this.jTextExpression);
        this.jTextExpression.setPreferredSize(new Dimension(0, 0));
        this.jTextExpression.setBorder(BorderFactory.createBevelBorder(1));
        try {
            Parameter param = this.m_Algorithm.getParameters().getParameter("FORMULA");
            ObjectAndDescription oad = (ObjectAndDescription)this.getParameterValue(param);
            if (oad != null) {
                String sFormula = (String)oad.getObject();
                this.jTextExpression.setText(sFormula);
            }
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.m_KeysPanel = new CalculatorKeysPanel(this.jTextExpression);
        this.add(this.m_KeysPanel, "3, 1, 4, 3");
        this.jScrollPane1 = new JScrollPane();
        this.add(this.jScrollPane1, "1, 1, 2, 3");
        this.jTree = new JTree();
        this.jScrollPane1.setViewportView(this.jTree);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jTree.setBorder(BorderFactory.createBevelBorder(1));
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int iRow = GridCalculatorModelerParametersPanel.this.jTree.getRowForLocation(e.getX(), e.getY());
                TreePath path = GridCalculatorModelerParametersPanel.this.jTree.getPathForLocation(e.getX(), e.getY());
                if (iRow != -1 && e.getClickCount() == 2) {
                    GridCalculatorModelerParametersPanel.this.insertTextFromTree(path);
                }
            }
        };
        this.jTree.addMouseListener(ml);
        try {
            this.populateTree();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OutputObjectsSet oosetGlobal = this.m_GlobalAlgorithm.getOutputObjects();
        this.m_OutputLayerSettingsPanel = new OutputLayerSettingsPanel();
        String sDescription = Sextante.getText((String)"Result");
        String sKey = "RESULT";
        if (!oosetGlobal.containsKey("RESULT" + this.m_sAlgorithmName)) {
            sDescription = "\"" + sDescription + "\" " + Sextante.getText((String)"from") + " " + this.m_sAlgorithmDescription;
            this.m_OutputLayerSettingsPanel.setKeepAsFinalResult(false);
        } else {
            try {
                Output out = oosetGlobal.getOutput("RESULT" + this.m_sAlgorithmName);
                sDescription = out.getDescription();
                this.m_OutputLayerSettingsPanel.setKeepAsFinalResult(true);
            }
            catch (WrongOutputIDException wrongOutputIDException) {
                // empty catch block
            }
        }
        this.m_OutputLayerSettingsPanel.setName(sDescription);
        this.add((Component)this.m_OutputLayerSettingsPanel, "2, 6, 4, 6");
        this.add(new JLabel(Sextante.getText((String)"Result")), "1,6,2,6");
    }

    private void populateTree() {
        DefaultMutableTreeNode child;
        String sVariableName;
        String sName;
        int i;
        this.jTree.setModel(null);
        ObjectAndDescription[] layers = this.getElementsOfClass(ModelElementRasterLayer.class, false);
        DefaultMutableTreeNode main = new DefaultMutableTreeNode(Sextante.getText((String)"ELEMENTS"));
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(Sextante.getText((String)"Layers"));
        for (i = 0; i < layers.length; ++i) {
            ObjectAndDescription oad = (ObjectAndDescription)this.m_DataObjects.get(layers[i].getObject());
            ModelElementRasterLayer merl = (ModelElementRasterLayer)oad.getObject();
            int iBands = merl.getNumberOfBands();
            if (iBands == -1) {
                iBands = 3;
            }
            for (int j = 0; j < iBands; ++j) {
                sName = layers[i].getDescription() + " Band " + Integer.toString(j + 1);
                sVariableName = layers[i].getObject() + " Band " + Integer.toString(j + 1);
                child = iBands == 3 && j != 0 ? new DefaultMutableTreeNode(new ObjectAndDescription(sName + "[" + Sextante.getText((String)"unchecked") + "]", (Object)sVariableName)) : new DefaultMutableTreeNode(new ObjectAndDescription(sName, (Object)sVariableName));
                node.add(child);
            }
        }
        main.add(node);
        String[] sFunctions = new String[]{"sin", "cos", "tan", "asin", "acos", "atan", "atan2", "sinh", "cosh", "tanh", "asinh", "acosh", "atanh", "ln", "log", "exp", "abs", "rand", "mod", "sqrt", "if"};
        node = new DefaultMutableTreeNode(Sextante.getText((String)"Functions"));
        for (i = 0; i < sFunctions.length; ++i) {
            child = new DefaultMutableTreeNode(" " + sFunctions[i] + "() ");
            node.add(child);
        }
        main.add(node);
        String[] sOperators = new String[]{"+", "-", "*", "/", "%", "!", "^", "&&", "||", "<", ">", "<=", ">=", "==", "!="};
        node = new DefaultMutableTreeNode(Sextante.getText((String)"Operators"));
        for (i = 0; i < sOperators.length; ++i) {
            String s = " " + sOperators[i] + " ";
            child = new DefaultMutableTreeNode(new ObjectAndDescription(s, (Object)s));
            node.add(child);
        }
        main.add(node);
        ObjectAndDescription[] values = this.getElementsOfClass(ModelElementNumericalValue.class, false);
        node = new DefaultMutableTreeNode(Sextante.getText((String)"Numerical_values"));
        for (i = 0; i < values.length; ++i) {
            sName = values[i].getDescription();
            sVariableName = values[i].getObject().toString();
            child = new DefaultMutableTreeNode(new ObjectAndDescription(sName, (Object)sVariableName));
            node.add(child);
        }
        main.add(node);
        node = new DefaultMutableTreeNode(Sextante.getText((String)"Constants"));
        this.m_Constants = new HashMap();
        this.m_Constants.put("e", " " + Double.toString(Math.E) + " ");
        this.m_Constants.put("Pi", " " + Double.toString(Math.PI) + " ");
        this.m_Constants.put("NODATA", " " + Double.toString(SextanteGUI.getOutputFactory().getDefaultNoDataValue()) + " ");
        Set set = this.m_Constants.keySet();
        for (String s : set) {
            child = new DefaultMutableTreeNode(new ObjectAndDescription(s, (Object)s));
            node.add(child);
        }
        main.add(node);
        this.jTree.setModel(new DefaultTreeModel(main));
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.jTree.getCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
    }

    private void insertTextFromTree(TreePath path) {
        TreePath parent = path.getParentPath();
        if (parent != null && !parent.toString().equals("[" + Sextante.getText((String)"ELEMENTS") + "]")) {
            String sParentName = parent.toString();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            String s = (String)((ObjectAndDescription)node.getUserObject()).getObject();
            if (sParentName.equals("[" + Sextante.getText((String)"ELEMENTS") + ", " + Sextante.getText((String)"Constants]"))) {
                s = this.m_Constants.containsKey(s) ? (String)this.m_Constants.get(s) : "";
            }
            this.jTextExpression.insert(s, this.jTextExpression.getCaretPosition());
            if (sParentName.equals("[" + Sextante.getText((String)"ELEMENTS") + ", " + Sextante.getText((String)"Functions]"))) {
                this.jTextExpression.setCaretPosition(this.jTextExpression.getCaretPosition() - 2);
            }
        }
    }

    public boolean assignParameters(HashMap map) {
        ObjectAndDescription[] layers = this.getElementsOfClass(ModelElementRasterLayer.class, false);
        ObjectAndDescription[] numerical = this.getElementsOfClass(ModelElementNumericalValue.class, false);
        ArrayList<String> layersList = new ArrayList<String>();
        String sFormula = this.jTextExpression.getText();
        List<String> array = FormulaParser.getBandsFromFormulaForModeler(sFormula, layers, numerical);
        if (array == null) {
            return false;
        }
        layersList.clear();
        for (int i = 0; i < array.size(); ++i) {
            String sKey = array.get(i);
            if (layersList.contains(sKey)) continue;
            layersList.add(sKey);
        }
        ObjectAndDescription[] values = this.getElementsOfClass(ModelElementNumericalValue.class, false);
        for (int i = 0; i < values.length; ++i) {
            if (!sFormula.contains(values[i].getObject().toString())) continue;
            map.put("DUMMY" + this.getInnerParameterKey(), values[i].getObject().toString());
        }
        String sArrayKey = this.getInnerParameterKey();
        map.put("LAYERS", sArrayKey);
        this.m_DataObjects.put(sArrayKey, new ObjectAndDescription("Multiple Input", layersList));
        String sFormulaKey = this.getInnerParameterKey();
        map.put("FORMULA", sFormulaKey);
        this.m_DataObjects.put(sFormulaKey, new ObjectAndDescription("String", (Object)this.jTextExpression.getText()));
        OutputObjectsSet oosetGlobal = this.m_GlobalAlgorithm.getOutputObjects();
        OutputObjectsSet ooset = this.m_Algorithm.getOutputObjects();
        String sName = "RESULT" + this.m_sAlgorithmName;
        if (this.m_OutputLayerSettingsPanel.getKeepAsFinalResult()) {
            try {
                Output out = ooset.getOutput("RESULT");
                Output outToAdd = (Output)out.getClass().newInstance();
                outToAdd.setName(sName);
                outToAdd.setDescription(this.m_OutputLayerSettingsPanel.getName());
                oosetGlobal.add(outToAdd);
            }
            catch (Exception exception) {}
        } else {
            oosetGlobal.remove(sName);
        }
        return true;
    }
}

