/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCalculus.kernelFilter;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.parameters.FixedTableModel;

public class KernelFilterAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String KERNEL = "KERNEL";
    public static final String LAYER = "LAYER";
    private IRasterLayer m_Window;
    protected double[] m_dValues;
    private double m_dNoData;
    private double[] m_dCoeffs;

    public void defineCharacteristics() {
        String[] sColumnNames = new String[]{"1", "2", "3"};
        this.setUserCanDefineAnalysisExtent(false);
        this.setName(Sextante.getText((String)"User-defined_3_X_3_filter"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addFixedTable(KERNEL, Sextante.getText((String)"Filter_kernel"), sColumnNames, 3, true);
            this.addOutputRasterLayer(RESULT, this.getName());
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        FixedTableModel kernel = (FixedTableModel)this.m_Parameters.getParameterValueAsObject(KERNEL);
        this.m_Window.setFullExtent();
        IRasterLayer result = this.getNewRasterLayer(RESULT, this.getName(), 5, this.m_Window.getLayerGridExtent());
        int iNX = this.m_Window.getNX();
        int iNY = this.m_Window.getNY();
        this.m_dValues = new double[9];
        this.m_dCoeffs = new double[9];
        this.m_dNoData = this.m_Window.getNoDataValue();
        result.setNoDataValue(this.m_dNoData);
        int iCell = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                try {
                    this.m_dCoeffs[iCell] = Double.parseDouble(kernel.getValueAt(i, j).toString());
                }
                catch (NumberFormatException e) {
                    this.m_dCoeffs[iCell] = 1.0;
                }
                ++iCell;
            }
        }
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                this.setNeighborhoodValues(x, y);
                result.setCellValue(x, y, this.processValues());
            }
            this.setProgress(y, iNY);
        }
        return !this.m_Task.isCanceled();
    }

    private void setNeighborhoodValues(int iX, int iY) {
        int iCell = 0;
        for (int y = -1; y < 2; ++y) {
            for (int x = -1; x < 2; ++x) {
                this.m_dValues[iCell] = this.m_Window.getCellValueAsDouble(iX + x, iY + y);
                ++iCell;
            }
        }
    }

    protected double processValues() {
        int i = 0;
        double dResult = 0.0;
        for (i = 0; i < this.m_dValues.length; ++i) {
            if (this.m_dValues[i] != this.m_dNoData) {
                dResult += this.m_dCoeffs[i] * this.m_dValues[i];
                continue;
            }
            return this.m_dNoData;
        }
        return dResult;
    }
}

