/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCalculus.unaryOperators;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public abstract class UnaryOperatorAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";
    private IRasterLayer m_window;
    protected double m_dValue;

    public void defineCharacteristics() {
        this.setGroup(Sextante.getText((String)"Calculus_tools_for_raster_layer"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Layer"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_window = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        this.m_window.setWindowExtent(this.m_AnalysisExtent);
        IRasterLayer result = this.getNewRasterLayer(RESULT, this.getName(), 5, this.m_window.getWindowGridExtent());
        result.setNoDataValue(this.m_OutputFactory.getDefaultNoDataValue());
        result.assignNoData();
        int iNX = this.m_window.getNX();
        int iNY = this.m_window.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                this.m_dValue = this.m_window.getCellValueAsDouble(x, y);
                if (!this.m_window.isNoDataValue(this.m_dValue)) {
                    result.setCellValue(x, y, this.getProcessedValue());
                    continue;
                }
                result.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }

    protected abstract double getProcessedValue();
}

