/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.aggregationIndex;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class AggregationIndexAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String INPUT = "INPUT";
    private final int[] m_iOffsetX = new int[]{-1, 0, 0, 1};
    private final int[] m_iOffsetY = new int[]{0, -1, 1, 0};
    int m_iNX;
    int m_iNY;
    int m_iTotalArea;
    IRasterLayer m_Window;
    HashMap m_Map;
    boolean[][] m_IsCellAlreadyVisited;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Aggregation_index"));
        this.setGroup(Sextante.getText((String)"Raster_categories_analysis"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.addOutputTable(RESULT, Sextante.getText((String)"Aggregation_index"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        this.m_Window.setFullExtent();
        this.m_iNX = this.m_Window.getNX();
        this.m_iNY = this.m_Window.getNY();
        this.m_Map = new HashMap();
        if (this.calculateIndex()) {
            this.createTable();
            return true;
        }
        return false;
    }

    private boolean calculateIndex() {
        this.m_iTotalArea = 0;
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                int iClass2;
                int i;
                int iClass = this.m_Window.getCellValueAsInt(x, y);
                AggregationInfo info = (AggregationInfo)this.m_Map.get(new Integer(iClass));
                if (info != null) {
                    ++this.m_iTotalArea;
                    ++info.iArea;
                    for (i = 0; i < 4; ++i) {
                        iClass2 = this.m_Window.getCellValueAsInt(x + this.m_iOffsetX[i], y + this.m_iOffsetY[i]);
                        if (iClass2 != iClass) continue;
                        ++info.iAggregation;
                    }
                    continue;
                }
                info = new AggregationInfo(iClass);
                ++this.m_iTotalArea;
                ++info.iArea;
                for (i = 0; i < 4; ++i) {
                    iClass2 = this.m_Window.getCellValueAsInt(x + this.m_iOffsetX[i], y + this.m_iOffsetY[i]);
                    if (iClass2 != iClass) continue;
                    ++info.iAggregation;
                }
                this.m_Map.put(new Integer(iClass), info);
            }
        }
        return !this.m_Task.isCanceled();
    }

    private void createTable() throws UnsupportedOutputChannelException {
        Set set = this.m_Map.keySet();
        Iterator iter = set.iterator();
        String[] sFields = new String[]{Sextante.getText((String)"Class"), Sextante.getText((String)"Area_cells"), Sextante.getText((String)"Area[%]"), Sextante.getText((String)"Aggregation_index")};
        Class[] types = new Class[]{Integer.class, Integer.class, Double.class, Double.class};
        String sTableName = Sextante.getText((String)"Aggregation_index_[") + this.m_Window.getName() + "]";
        ITable table = this.getNewTable(RESULT, sTableName, types, sFields);
        Object[] values = new Object[4];
        while (iter.hasNext()) {
            AggregationInfo info = (AggregationInfo)this.m_Map.get(iter.next());
            values[0] = new Integer(info.iClass);
            values[1] = new Integer(info.iArea);
            values[2] = new Double((double)info.iArea / (double)this.m_iTotalArea * 100.0);
            int iLargestInt = (int)Math.floor(Math.sqrt(info.iArea));
            int iRemainder = info.iArea - iLargestInt * iLargestInt;
            int iMaxEii = iRemainder != 0 ? (iRemainder < iLargestInt ? 2 * iLargestInt * (iLargestInt - 1) + 2 * iRemainder - 1 : 2 * iLargestInt * (iLargestInt - 1) + 2 * iRemainder - 2) : 2 * iLargestInt * (iLargestInt - 1);
            values[3] = new Double((double)info.iAggregation / (double)iMaxEii / 2.0);
            table.addRecord(values);
        }
    }

    private class AggregationInfo {
        public int iClass;
        public int iArea;
        public int iAggregation;

        public AggregationInfo(int i) {
            this.iClass = i;
            this.iArea = 0;
            this.iAggregation = 0;
        }
    }
}

