/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.combineGrids;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.parameters.FixedTableModel;

public class CombineGridsAlgorithm
extends GeoAlgorithm {
    public static final String GRID = "GRID";
    public static final String GRID2 = "GRID2";
    public static final String RESULT = "RESULT";
    public static final String LUT = "LUT";

    public void defineCharacteristics() {
        String[] sColumnNames = new String[]{Sextante.getText((String)"Valor_in_grid_1"), Sextante.getText((String)"Valor_in_grid_2"), Sextante.getText((String)"New_value")};
        this.setName(Sextante.getText((String)"Combine_grids"));
        this.setGroup(Sextante.getText((String)"Raster_categories_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(GRID, Sextante.getText((String)"Grid_1"), true);
            this.m_Parameters.addInputRasterLayer(GRID2, Sextante.getText((String)"Grid_2"), true);
            this.m_Parameters.addFixedTable(LUT, Sextante.getText((String)"Look-up_table"), sColumnNames, 1, false);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Grid_combination"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer grid = this.m_Parameters.getParameterValueAsRasterLayer(GRID);
        IRasterLayer grid2 = this.m_Parameters.getParameterValueAsRasterLayer(GRID2);
        IRasterLayer result = this.getNewRasterLayer(RESULT, grid.getName() + " + " + grid2.getName(), 5);
        FixedTableModel lut = (FixedTableModel)this.m_Parameters.getParameterValueAsObject(LUT);
        grid.setWindowExtent(result.getWindowGridExtent());
        grid.setInterpolationMethod(0);
        grid2.setWindowExtent(result.getWindowGridExtent());
        grid2.setInterpolationMethod(0);
        int iNX = grid.getNX();
        int iNY = grid.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                int i;
                double dCellValue = grid.getCellValueAsDouble(x, y);
                double dCellValue2 = grid2.getCellValueAsDouble(x, y);
                for (i = 0; i < lut.getRowCount(); ++i) {
                    double dTableValue2;
                    double dTableValue = Double.parseDouble(lut.getValueAt(i, 0).toString());
                    if (dTableValue != dCellValue || (dTableValue2 = Double.parseDouble(lut.getValueAt(i, 1).toString())) != dCellValue2) continue;
                    double dValue = Double.parseDouble(lut.getValueAt(i, 2).toString());
                    result.setCellValue(x, y, dValue);
                    break;
                }
                if (i < lut.getRowCount()) continue;
                result.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

