/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.reclassifyDisjoint;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.awt.Point;
import java.util.ArrayList;

public class ReclassifyDisjointAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String INPUT = "INPUT";
    public static final String RECLASS = "RECLASS";
    int m_iNX;
    int m_iNY;
    IRasterLayer m_Window;
    IRasterLayer m_Result;
    boolean[][] m_IsCellAlreadyVisited;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Reclassify_into_disjoint_classes"));
        this.setGroup(Sextante.getText((String)"Reclassify_raster_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.addOutputRasterLayer(RECLASS, Sextante.getText((String)"Reclassify"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iClass = 0;
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        this.m_Result = this.getNewRasterLayer(RECLASS, this.m_Window.getName() + Sextante.getText((String)"[reclassified]"), 3);
        this.m_Result.assignNoData();
        this.m_Window.setWindowExtent(this.m_Result);
        this.m_Window.setInterpolationMethod(0);
        this.m_iNX = this.m_Window.getNX();
        this.m_iNY = this.m_Window.getNY();
        this.m_IsCellAlreadyVisited = new boolean[this.m_iNX][this.m_iNY];
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_Window.getCellValueAsDouble(x, y);
                if (this.m_Window.isNoDataValue(dValue) || this.m_IsCellAlreadyVisited[x][y]) continue;
                this.setClass(x, y, ++iClass);
            }
        }
        return !this.m_Task.isCanceled();
    }

    private void setClass(int x, int y, int iNewClass) {
        ArrayList<Point> centralPoints = new ArrayList<Point>();
        ArrayList<Point> adjPoints = new ArrayList<Point>();
        int iInitClass = this.m_Window.getCellValueAsInt(x, y);
        centralPoints.add(new Point(x, y));
        this.m_IsCellAlreadyVisited[x][y] = true;
        while (centralPoints.size() != 0) {
            for (int iPt = 0; iPt < centralPoints.size(); ++iPt) {
                Point point = (Point)centralPoints.get(iPt);
                x = point.x;
                y = point.y;
                int iClass = this.m_Window.getCellValueAsInt(x, y);
                if (this.m_Window.isNoDataValue((double)iClass)) continue;
                for (int n = 0; n < 8; ++n) {
                    int x2 = x + m_iOffsetX[n];
                    int y2 = y + m_iOffsetY[n];
                    iClass = this.m_Window.getCellValueAsInt(x2, y2);
                    if (this.m_Window.isNoDataValue((double)iClass) || this.m_IsCellAlreadyVisited[x2][y2] || iInitClass != iClass) continue;
                    this.m_IsCellAlreadyVisited[x2][y2] = true;
                    this.m_Result.setCellValue(x2, y2, (double)iNewClass);
                    adjPoints.add(new Point(x2, y2));
                }
            }
            centralPoints = adjPoints;
            adjPoints = new ArrayList();
            if (!this.m_Task.isCanceled()) continue;
            return;
        }
    }
}

