/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.reclassifyEqualArea;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.util.Arrays;

public class ReclassifyEqualAreaAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String CLASSAREA = "CLASSAREA";
    public static final String RECLASS = "RECLASS";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Divide_into_n_classes_of_equal_area"));
        this.setGroup(Sextante.getText((String)"Reclassify_raster_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addNumericalValue(CLASSAREA, Sextante.getText((String)"Class_area_[cells]"), 1, 100.0, 2.0, 2.147483647E9);
            this.addOutputRasterLayer(RECLASS, Sextante.getText((String)"Reclassify"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer grid = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        int iClassArea = this.m_Parameters.getParameterValueAsInt(CLASSAREA);
        IRasterLayer result = this.getNewRasterLayer(RECLASS, grid.getName() + Sextante.getText((String)"[reclassified]"), 3);
        grid.setWindowExtent(this.getAnalysisExtent());
        GridCell[] cells = this.getSortedArrayOfCells(grid);
        result.assignNoData();
        int iCell = 0;
        for (int i = 0; i < cells.length; ++i) {
            GridCell cell = cells[i];
            if (!grid.isNoDataValue(cell.getValue())) {
                int iValue = iCell / iClassArea;
                result.setCellValue(cell.getX(), cell.getY(), (double)iValue);
                if (!this.setProgress(iCell, cells.length)) {
                    return false;
                }
                ++iCell;
                continue;
            }
            result.setNoData(cell.getX(), cell.getY());
        }
        return !this.m_Task.isCanceled();
    }

    public GridCell[] getSortedArrayOfCells(IRasterLayer layer) {
        int iNX = layer.getNX();
        int iCells = layer.getNX() * layer.getNY();
        Object[] cells = new GridCell[iCells];
        for (int i = 0; i < iCells; ++i) {
            int iX = i % iNX;
            int iY = i / iNX;
            GridCell cell = new GridCell(iX, iY, layer.getCellValueAsDouble(iX, iY));
            cells[i] = cell;
        }
        Arrays.sort(cells);
        return cells;
    }
}

