/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridStatistics.base;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public abstract class NeighborhoodStatsExtendedBaseAlgorithm
extends GeoAlgorithm {
    public static final String RADIUS = "RADIUS";
    public static final String LAYER = "LAYER";
    public static final String VALUE = "VALUE";
    public static final String FORCE_NODATA = "NODATA";
    public static final String RESULT = "RESULT";
    protected double NO_DATA;
    private int m_iRadius;
    private boolean m_bForceNoData;
    private boolean[][] m_bIsValidCell;
    private IRasterLayer m_window;
    protected double[] m_dValues;
    protected double m_dValue;

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addNumericalValue(RADIUS, Sextante.getText((String)"Radius"), 1, 1.0, 1.0, 20.0);
            this.m_Parameters.addNumericalValue(VALUE, Sextante.getText((String)"Value"), 0.0, 2);
            this.m_Parameters.addBoolean(FORCE_NODATA, Sextante.getText((String)"Force_no-data_value"), true);
            this.addOutputRasterLayer(RESULT, this.getName());
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int x;
        int y;
        int iValidCells = 0;
        this.NO_DATA = this.m_OutputFactory.getDefaultNoDataValue();
        this.m_iRadius = this.m_Parameters.getParameterValueAsInt(RADIUS);
        this.m_window = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        this.m_dValue = this.m_Parameters.getParameterValueAsDouble(VALUE);
        this.m_bForceNoData = this.m_Parameters.getParameterValueAsBoolean(FORCE_NODATA);
        this.m_window.setFullExtent();
        IRasterLayer result = this.getNewRasterLayer(RESULT, this.getName(), 5, this.m_window.getWindowGridExtent());
        result.setNoDataValue(this.NO_DATA);
        result.assignNoData();
        int iNX = this.m_window.getNX();
        int iNY = this.m_window.getNY();
        this.m_bIsValidCell = new boolean[2 * this.m_iRadius + 1][2 * this.m_iRadius + 1];
        for (y = -this.m_iRadius; y < this.m_iRadius + 1; ++y) {
            for (x = -this.m_iRadius; x < this.m_iRadius + 1; ++x) {
                double dDist = Math.sqrt(x * x + y * y);
                if (dDist < (double)this.m_iRadius) {
                    this.m_bIsValidCell[x + this.m_iRadius][y + this.m_iRadius] = true;
                    ++iValidCells;
                    continue;
                }
                this.m_bIsValidCell[x + this.m_iRadius][y + this.m_iRadius] = false;
            }
        }
        this.m_dValues = new double[iValidCells];
        for (y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (x = 0; x < iNX; ++x) {
                if (this.setNeighborhoodValues(x, y)) {
                    result.setCellValue(x, y, this.processValues());
                    continue;
                }
                result.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }

    private boolean setNeighborhoodValues(int iX, int iY) {
        int iCell = 0;
        for (int y = -this.m_iRadius; y < this.m_iRadius + 1; ++y) {
            for (int x = -this.m_iRadius; x < this.m_iRadius + 1; ++x) {
                if (!this.m_bIsValidCell[x + this.m_iRadius][y + this.m_iRadius]) continue;
                double dValue = this.m_window.getCellValueAsDouble(iX + x, iY + y);
                if (!this.m_window.isNoDataValue(dValue)) {
                    this.m_dValues[iCell] = dValue;
                } else {
                    if (this.m_bForceNoData) {
                        return false;
                    }
                    this.m_dValues[iCell] = this.NO_DATA;
                }
                ++iCell;
            }
        }
        return true;
    }

    protected abstract double processValues();
}

