/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.correlation;

import es.unex.sextante.additionalResults.CorrelationGraphCreator;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.math.regression.Regression;
import java.text.DecimalFormat;

public class CorrelationAlgorithm
extends GeoAlgorithm {
    public static final String REGRESSION_DATA = "REGRESSION_DATA";
    public static final String REGRESSION = "REGRESSION";
    public static final String METHOD = "METHOD";
    public static final String GRID2 = "GRID2";
    public static final String GRID = "GRID";

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Best_fit"), "y = a + b * x", "y = a + b / x", "y = a / (b - x)", "y = a * x^b", "y = a e^(b * x)", "y = a + b * ln(x)"};
        this.setName(Sextante.getText((String)"Correlation_between_layers"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(GRID, Sextante.getText((String)"Layer_1"), true);
            this.m_Parameters.addInputRasterLayer(GRID2, Sextante.getText((String)"Layer_2"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Function_type"), sMethod);
            this.addOutputChart(REGRESSION, Sextante.getText((String)"Regression"));
            this.addOutputText(REGRESSION_DATA, Sextante.getText((String)"Regression_values"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        Regression regression = new Regression();
        IRasterLayer window = this.m_Parameters.getParameterValueAsRasterLayer(GRID);
        IRasterLayer window2 = this.m_Parameters.getParameterValueAsRasterLayer(GRID2);
        int iType = this.m_Parameters.getParameterValueAsInt(METHOD);
        window.setFullExtent();
        window2.setWindowExtent(window.getWindowGridExtent());
        if (window2.getDataType() == 3 || window2.getDataType() == 2) {
            window2.setInterpolationMethod(0);
        }
        int iNX = window.getNX();
        int iNY = window.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dCellValue = window.getCellValueAsDouble(x, y);
                double dCellValue2 = window2.getCellValueAsDouble(x, y);
                if (window.isNoDataValue(dCellValue) || window2.isNoDataValue(dCellValue2)) continue;
                regression.addValue(dCellValue, dCellValue2);
            }
        }
        regression.calculate(iType);
        CorrelationGraphCreator panel = new CorrelationGraphCreator(regression);
        this.addOutputChart(REGRESSION, Sextante.getText((String)"Regression"), panel.getChartPanel());
        DecimalFormat df = new DecimalFormat("####.###");
        HTMLDoc doc = new HTMLDoc();
        doc.open(Sextante.getText((String)"Regression"));
        doc.addHeader(Sextante.getText((String)"Regression"), 2);
        doc.startUnorderedList();
        doc.addListElement(regression.getExpression());
        doc.addListElement("R2 = " + df.format(regression.getR2()));
        doc.closeUnorderedList();
        doc.close();
        this.addOutputText(REGRESSION_DATA, Sextante.getText((String)"Regression_values"), doc.getHTMLCode());
        return !this.m_Task.isCanceled();
    }
}

