/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.gridBasicStats;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.math.simpleStats.SimpleStats;
import java.text.DecimalFormat;

public class GridBasicStatsAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String STATS = "STATS";
    public static final String MEAN = "MEAN";
    public static final String MEAN_SQUARED = "MEAN_SQUARED";
    public static final String MIN = "MIN";
    public static final String MAX = "MAX";
    public static final String VARIANCE = "VARIANCE";
    public static final String SUM = "SUM";
    public static final String COEF_OF_VARIATION = "COEF_OF_VARIATION";
    public static final String VALID_CELLS = "VALID_CELLS";
    public static final String NO_DATA_CELLS = "NO_DATA_CELLS";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Basic_statistics"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.addOutputText(STATS, Sextante.getText((String)"Statistics"));
            this.addOutputNumericalValue(MEAN, Sextante.getText((String)"Mean_value"));
            this.addOutputNumericalValue(MEAN_SQUARED, Sextante.getText((String)"Mean_squared_value"));
            this.addOutputNumericalValue(MIN, Sextante.getText((String)"Minimum_value"));
            this.addOutputNumericalValue(MAX, Sextante.getText((String)"Maximum_value"));
            this.addOutputNumericalValue(VARIANCE, Sextante.getText((String)"Variance"));
            this.addOutputNumericalValue(SUM, Sextante.getText((String)"Total_sum"));
            this.addOutputNumericalValue(COEF_OF_VARIATION, Sextante.getText((String)"Coefficient_of_variation"));
            this.addOutputNumericalValue(VALID_CELLS, Sextante.getText((String)"Valid_data_cells"));
            this.addOutputNumericalValue(NO_DATA_CELLS, Sextante.getText((String)"No_data_cells"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iNoDataCells = 0;
        SimpleStats stats = new SimpleStats();
        IRasterLayer input = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        input.setFullExtent();
        int iNX = input.getNX();
        int iNY = input.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dValue = input.getCellValueAsDouble(x, y);
                if (!input.isNoDataValue(dValue)) {
                    stats.addValue(dValue);
                    continue;
                }
                ++iNoDataCells;
            }
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        DecimalFormat df = new DecimalFormat("##.###");
        HTMLDoc doc = new HTMLDoc();
        doc.open(Sextante.getText((String)"Statistics"));
        doc.addHeader(Sextante.getText((String)"Basic_statistics"), 2);
        doc.startUnorderedList();
        doc.addListElement(Sextante.getText((String)"Mean_value") + ": " + df.format(stats.getMean()));
        doc.addListElement(Sextante.getText((String)"Mean_squared_value") + ": " + df.format(stats.getRMS()));
        doc.addListElement(Sextante.getText((String)"Minimum_value") + ": " + df.format(stats.getMin()));
        doc.addListElement(Sextante.getText((String)"Maximum_value") + ": " + df.format(stats.getMax()));
        doc.addListElement(Sextante.getText((String)"Variance") + ": " + df.format(stats.getVariance()));
        doc.addListElement(Sextante.getText((String)"Total_sum") + ": " + df.format(stats.getSum()));
        doc.addListElement(Sextante.getText((String)"Coefficient_of_variation") + ": " + df.format(stats.getCoeffOfVar()));
        doc.addListElement(Sextante.getText((String)"Valid_data_cells") + ": " + Integer.toString(stats.getCount()));
        doc.addListElement(Sextante.getText((String)"No_data_cells") + ": " + Integer.toString(iNX * iNY - stats.getCount()));
        doc.closeUnorderedList();
        doc.close();
        this.addOutputText(STATS, Sextante.getText((String)"Statistics") + "[" + input.getName() + "]", doc.getHTMLCode());
        this.addOutputNumericalValue(MEAN, stats.getMean());
        this.addOutputNumericalValue(MEAN_SQUARED, stats.getRMS());
        this.addOutputNumericalValue(MIN, stats.getMin());
        this.addOutputNumericalValue(MAX, stats.getMax());
        this.addOutputNumericalValue(VARIANCE, stats.getVariance());
        this.addOutputNumericalValue(SUM, stats.getSum());
        this.addOutputNumericalValue(COEF_OF_VARIATION, stats.getCoeffOfVar());
        this.addOutputNumericalValue(VALID_CELLS, stats.getCount());
        this.addOutputNumericalValue(NO_DATA_CELLS, iNX * iNY - stats.getCount());
        return true;
    }
}

