/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.gridsFromTableAndGrid;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IRecordsetIterator;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;

public class GridsFromTableAndGridAlgorithm
extends GeoAlgorithm {
    private double NO_DATA;
    public static final String INPUT = "INPUT";
    public static final String TABLE = "TABLE";
    public static final String FIELD = "FIELD";
    public static final String RESULT = "RESULT";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Grids_from_table_and_classified_grid"));
        this.setGroup(Sextante.getText((String)"Raster_categories_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addInputTable(TABLE, Sextante.getText((String)"Look-up_table"), true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), TABLE);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        int iClass;
        Object[] record;
        int iMax = 0;
        int iValidFields = 0;
        this.NO_DATA = this.m_OutputFactory.getDefaultNoDataValue();
        IRasterLayer grid = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        ITable table = this.m_Parameters.getParameterValueAsTable(TABLE);
        int iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        IRecordsetIterator iter = table.iterator();
        iMax = Integer.MIN_VALUE;
        while (iter.hasNext()) {
            record = iter.next().getValues();
            try {
                iClass = new Integer(record[iField].toString());
                if (iClass <= iMax) continue;
                iMax = iClass;
            }
            catch (NumberFormatException e) {
                Sextante.addErrorToLog((Throwable)e);
                return false;
            }
        }
        for (i = 0; i < table.getFieldCount(); ++i) {
            if (table.getFieldType(i) != Double.class && table.getFieldType(i) != Integer.class && table.getFieldType(i) != Float.class && table.getFieldType(i) != Byte.class && (table.getFieldType(i) != Long.class || i == iField)) continue;
            ++iValidFields;
        }
        int[] ValidFields = new int[iValidFields];
        iValidFields = 0;
        for (i = 0; i < table.getFieldCount(); ++i) {
            if (table.getFieldType(i) != Double.class && table.getFieldType(i) != Integer.class && table.getFieldType(i) != Float.class && table.getFieldType(i) != Byte.class && (table.getFieldType(i) != Long.class || i == iField)) continue;
            ValidFields[iValidFields] = i;
            ++iValidFields;
        }
        if (iValidFields != 0) {
            double[][] Values2 = new double[iMax + 1][iValidFields];
            iter = table.iterator();
            while (iter.hasNext()) {
                record = iter.next().getValues();
                iClass = new Integer(record[iField].toString());
                for (int j = 0; j < iValidFields; ++j) {
                    try {
                        Values2[iClass][j] = new Double(record[ValidFields[j]].toString());
                        continue;
                    }
                    catch (Exception e) {
                        Values2[iClass][j] = this.NO_DATA;
                    }
                }
            }
            IRasterLayer[] grids = new IRasterLayer[iValidFields];
            for (i = 0; i < iValidFields; ++i) {
                grids[i] = this.getNewRasterLayer(RESULT + Integer.toString(i), "[" + table.getFieldName(ValidFields[i]) + "]", 5);
                grids[i].setNoDataValue(this.NO_DATA);
            }
            grid.setWindowExtent(grids[0].getWindowGridExtent());
            grid.setInterpolationMethod(0);
            int iNX = grid.getNX();
            int iNY = grid.getNY();
            for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
                for (int x = 0; x < iNX; ++x) {
                    iClass = grid.getCellValueAsInt(x, y);
                    if (iClass <= 0 || iClass >= iMax + 1) continue;
                    for (i = 0; i < iValidFields; ++i) {
                        grids[i].setCellValue(x, y, Values2[iClass][i]);
                    }
                }
            }
            return !this.m_Task.isCanceled();
        }
        throw new GeoAlgorithmExecutionException("No valid fields in table");
    }

    public boolean isSuitableForModelling() {
        return false;
    }

    public boolean generatesLayers() {
        return true;
    }
}

